/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Error {
    private final String message;
    private final List<Location> locations;
    private final Map<String, Object> customAttributes;

    public Error(String message, @Nullable List<Location> locations, @Nullable Map<String, Object> customAttributes) {
        this.message = message;
        this.locations = locations != null ? Collections.unmodifiableList(locations) : Collections.emptyList();
        this.customAttributes = customAttributes != null ? Collections.unmodifiableMap(customAttributes) : Collections.emptyMap();
    }

    public String message() {
        return this.message;
    }

    @Nonnull
    public List<Location> locations() {
        return this.locations;
    }

    @Nonnull
    public Map<String, Object> customAttributes() {
        return this.customAttributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Error)) {
            return false;
        }
        Error error = (Error)o;
        if (this.message != null ? !this.message.equals(error.message) : error.message != null) {
            return false;
        }
        if (!this.locations.equals(error.locations)) {
            return false;
        }
        return this.customAttributes.equals(error.customAttributes);
    }

    public int hashCode() {
        int result = this.message != null ? this.message.hashCode() : 0;
        result = 31 * result + this.locations.hashCode();
        result = 31 * result + this.customAttributes.hashCode();
        return result;
    }

    public String toString() {
        return "Error{message='" + this.message + '\'' + ", locations=" + this.locations + ", customAttributes=" + this.customAttributes + '}';
    }

    public static class Location {
        private final long line;
        private final long column;

        public Location(long line, long column) {
            this.line = line;
            this.column = column;
        }

        public long line() {
            return this.line;
        }

        public long column() {
            return this.column;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Location location = (Location)o;
            if (this.line != location.line) {
                return false;
            }
            return this.column == location.column;
        }

        public int hashCode() {
            int result = (int)(this.line ^ this.line >>> 32);
            result = 31 * result + (int)(this.column ^ this.column >>> 32);
            return result;
        }

        public String toString() {
            return "Location{line=" + this.line + ", column=" + this.column + '}';
        }
    }
}

