/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.streams.operators;

import java.beans.ConstructorProperties;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;

public final class SkipWhileTimeOperator<U> {
    private final Stream<U> stream;

    public Stream<U> skipWhile(long time, TimeUnit unit) {
        long start = System.nanoTime();
        long allowed = unit.toNanos(time);
        return this.stream.filter(a -> System.nanoTime() - start > allowed);
    }

    @ConstructorProperties(value={"stream"})
    public SkipWhileTimeOperator(Stream<U> stream) {
        this.stream = stream;
    }

    public Stream<U> getStream() {
        return this.stream;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SkipWhileTimeOperator)) {
            return false;
        }
        SkipWhileTimeOperator other = (SkipWhileTimeOperator)o;
        Stream<U> this$stream = this.getStream();
        Stream<U> other$stream = other.getStream();
        return !(this$stream == null ? other$stream != null : !this$stream.equals(other$stream));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Stream<U> $stream = this.getStream();
        result = result * 59 + ($stream == null ? 0 : $stream.hashCode());
        return result;
    }

    public String toString() {
        return "SkipWhileTimeOperator(stream=" + this.getStream() + ")";
    }
}

