/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.streams.operators;

import com.aol.cyclops.streams.StreamUtils;
import java.beans.ConstructorProperties;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.stream.Stream;

public final class SkipWhileOperator<U> {
    private final Stream<U> stream;

    public Stream<U> skipWhile(final Predicate<? super U> predicate) {
        final Iterator it = this.stream.iterator();
        return StreamUtils.stream(new Iterator<U>(){
            U next;
            boolean nextSet = false;
            boolean init = false;

            @Override
            public boolean hasNext() {
                if (this.init) {
                    return it.hasNext();
                }
                try {
                    while (it.hasNext()) {
                        this.next = it.next();
                        this.nextSet = true;
                        if (predicate.test(this.next)) continue;
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    this.init = true;
                }
            }

            @Override
            public U next() {
                if (!this.init) {
                    this.hasNext();
                }
                if (this.nextSet) {
                    this.nextSet = false;
                    return this.next;
                }
                return it.next();
            }
        });
    }

    @ConstructorProperties(value={"stream"})
    public SkipWhileOperator(Stream<U> stream) {
        this.stream = stream;
    }

    public Stream<U> getStream() {
        return this.stream;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SkipWhileOperator)) {
            return false;
        }
        SkipWhileOperator other = (SkipWhileOperator)o;
        Stream<U> this$stream = this.getStream();
        Stream<U> other$stream = other.getStream();
        return !(this$stream == null ? other$stream != null : !this$stream.equals(other$stream));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Stream<U> $stream = this.getStream();
        result = result * 59 + ($stream == null ? 0 : $stream.hashCode());
        return result;
    }

    public String toString() {
        return "SkipWhileOperator(stream=" + this.getStream() + ")";
    }
}

