/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.streams.operators;

import com.aol.cyclops.invokedynamic.ExceptionSoftener;
import com.aol.cyclops.streams.StreamUtils;
import java.beans.ConstructorProperties;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Stream;

public final class RecoverOperator<T> {
    private final Stream<T> stream;
    private final Class<Throwable> type;
    private static final Object UNSET = new Object();

    public Stream<T> recover(final Function<Throwable, ? extends T> fn) {
        final Iterator it = this.stream.iterator();
        return StreamUtils.stream(new Iterator<T>(){
            T result = RecoverOperator.access$000();

            @Override
            public boolean hasNext() {
                try {
                    return it.hasNext();
                }
                catch (Throwable t) {
                    if (RecoverOperator.this.type.isAssignableFrom(t.getClass())) {
                        this.result = fn.apply(t);
                        return true;
                    }
                    ExceptionSoftener.throwSoftenedException((Throwable)t);
                    return false;
                }
            }

            @Override
            public T next() {
                if (this.result != UNSET) {
                    Object toReturn = this.result;
                    this.result = UNSET;
                    return toReturn;
                }
                return it.next();
            }
        });
    }

    @ConstructorProperties(value={"stream", "type"})
    public RecoverOperator(Stream<T> stream, Class<Throwable> type) {
        this.stream = stream;
        this.type = type;
    }

    public Stream<T> getStream() {
        return this.stream;
    }

    public Class<Throwable> getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecoverOperator)) {
            return false;
        }
        RecoverOperator other = (RecoverOperator)o;
        Stream<T> this$stream = this.getStream();
        Stream<T> other$stream = other.getStream();
        if (this$stream == null ? other$stream != null : !this$stream.equals(other$stream)) {
            return false;
        }
        Class<Throwable> this$type = this.getType();
        Class<Throwable> other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Stream<T> $stream = this.getStream();
        result = result * 59 + ($stream == null ? 0 : $stream.hashCode());
        Class<Throwable> $type = this.getType();
        result = result * 59 + ($type == null ? 0 : $type.hashCode());
        return result;
    }

    public String toString() {
        return "RecoverOperator(stream=" + this.getStream() + ", type=" + this.getType() + ")";
    }
}

