/*
 * Decompiled with CFR 0.152.
 */
package org.mule.exchange.resource.portals.organizationDomain;

import java.net.URLEncoder;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.mule.exchange.exceptions.ExchangexapiException;
import org.mule.exchange.resource.portals.organizationDomain.applications.Applications;
import org.mule.exchange.resource.portals.organizationDomain.assets.Assets;
import org.mule.exchange.resource.portals.organizationDomain.domain.Domain;
import org.mule.exchange.resource.portals.organizationDomain.draft.Draft;
import org.mule.exchange.resource.portals.organizationDomain.metadata.Metadata;
import org.mule.exchange.resource.portals.organizationDomain.model.OrganizationDomainGETResponseBody;
import org.mule.exchange.resource.portals.organizationDomain.pages.Pages;
import org.mule.exchange.resource.portals.organizationDomain.resources.Resources;
import org.mule.exchange.responses.ExchangexapiResponse;

public class OrganizationDomain {
    private String _baseUrl;
    private Client _client;
    public final Applications applications;
    public final Metadata metadata;
    public final Pages pages;
    public final Assets assets;
    public final Draft draft;
    public final Domain domain;
    public final Resources resources;

    public OrganizationDomain() {
        this._baseUrl = null;
        this._client = null;
        this.applications = null;
        this.metadata = null;
        this.pages = null;
        this.assets = null;
        this.draft = null;
        this.domain = null;
        this.resources = null;
    }

    public OrganizationDomain(String baseUrl, Client _client, String uriParam) {
        this._baseUrl = baseUrl + "/" + URLEncoder.encode(uriParam);
        this._client = _client;
        this.applications = new Applications(this.getBaseUri(), this.getClient());
        this.metadata = new Metadata(this.getBaseUri(), this.getClient());
        this.pages = new Pages(this.getBaseUri(), this.getClient());
        this.assets = new Assets(this.getBaseUri(), this.getClient());
        this.draft = new Draft(this.getBaseUri(), this.getClient());
        this.domain = new Domain(this.getBaseUri(), this.getClient());
        this.resources = new Resources(this.getBaseUri(), this.getClient());
    }

    protected Client getClient() {
        return this._client;
    }

    private String getBaseUri() {
        return this._baseUrl;
    }

    public ExchangexapiResponse<Void> patch(String authorizationToken) {
        WebTarget target = this._client.target(this.getBaseUri());
        Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        invocationBuilder.header("Authorization", (Object)("bearer " + authorizationToken));
        Response response = invocationBuilder.method("PATCH", (Entity)null);
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            Response.StatusType statusInfo = response.getStatusInfo();
            throw new ExchangexapiException(statusInfo.getStatusCode(), statusInfo.getReasonPhrase(), (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        }
        ExchangexapiResponse<Object> apiResponse = new ExchangexapiResponse<Object>(null, (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        return apiResponse;
    }

    public ExchangexapiResponse<OrganizationDomainGETResponseBody> get(String authorizationToken) {
        WebTarget target = this._client.target(this.getBaseUri());
        Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        invocationBuilder.header("Authorization", (Object)("bearer " + authorizationToken));
        Response response = invocationBuilder.method("GET");
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            Response.StatusType statusInfo = response.getStatusInfo();
            throw new ExchangexapiException(statusInfo.getStatusCode(), statusInfo.getReasonPhrase(), (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        }
        ExchangexapiResponse<Object> apiResponse = new ExchangexapiResponse<Object>(response.readEntity(OrganizationDomainGETResponseBody.class), (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        return apiResponse;
    }
}

