/*
 * Decompiled with CFR 0.152.
 */
package org.mule.exchange.resource.organizations.organizationId;

import java.net.URLEncoder;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.mule.exchange.exceptions.ExchangexapiException;
import org.mule.exchange.resource.organizations.organizationId.assets.Assets;
import org.mule.exchange.resource.organizations.organizationId.categories.Categories;
import org.mule.exchange.resource.organizations.organizationId.fields.Fields;
import org.mule.exchange.resource.organizations.organizationId.queries.Queries;
import org.mule.exchange.responses.ExchangexapiResponse;

public class OrganizationId {
    private String _baseUrl;
    private Client _client;
    public final Fields fields;
    public final Queries queries;
    public final Assets assets;
    public final Categories categories;

    public OrganizationId() {
        this._baseUrl = null;
        this._client = null;
        this.fields = null;
        this.queries = null;
        this.assets = null;
        this.categories = null;
    }

    public OrganizationId(String baseUrl, Client _client, String uriParam) {
        this._baseUrl = baseUrl + "/" + URLEncoder.encode(uriParam);
        this._client = _client;
        this.fields = new Fields(this.getBaseUri(), this.getClient());
        this.queries = new Queries(this.getBaseUri(), this.getClient());
        this.assets = new Assets(this.getBaseUri(), this.getClient());
        this.categories = new Categories(this.getBaseUri(), this.getClient());
    }

    protected Client getClient() {
        return this._client;
    }

    private String getBaseUri() {
        return this._baseUrl;
    }

    public ExchangexapiResponse<Void> delete(String authorizationToken) {
        WebTarget target = this._client.target(this.getBaseUri());
        Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        invocationBuilder.header("Authorization", (Object)("bearer " + authorizationToken));
        Response response = invocationBuilder.method("DELETE");
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            Response.StatusType statusInfo = response.getStatusInfo();
            throw new ExchangexapiException(statusInfo.getStatusCode(), statusInfo.getReasonPhrase(), (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        }
        ExchangexapiResponse<Object> apiResponse = new ExchangexapiResponse<Object>(null, (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        return apiResponse;
    }
}

