/*
 * Decompiled with CFR 0.152.
 */
package org.mule.exchange.resource.organizations.masterOrganizationId.applications;

import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.mule.exchange.exceptions.ExchangexapiException;
import org.mule.exchange.resource.organizations.masterOrganizationId.applications.applicationId.ApplicationId;
import org.mule.exchange.resource.organizations.masterOrganizationId.applications.model.ApplicationsGETQueryParam;
import org.mule.exchange.resource.organizations.masterOrganizationId.applications.model.ApplicationsGETResponseBody;
import org.mule.exchange.resource.organizations.masterOrganizationId.applications.model.ApplicationsPOSTBody;
import org.mule.exchange.resource.organizations.masterOrganizationId.applications.model.ApplicationsPOSTQueryParam;
import org.mule.exchange.resource.organizations.masterOrganizationId.applications.model.ApplicationsPOSTResponseBody;
import org.mule.exchange.responses.ExchangexapiResponse;

public class Applications {
    private String _baseUrl;
    private Client _client;

    public Applications() {
        this._baseUrl = null;
        this._client = null;
    }

    public Applications(String baseUrl, Client _client) {
        this._baseUrl = baseUrl + "/applications";
        this._client = _client;
    }

    protected Client getClient() {
        return this._client;
    }

    private String getBaseUri() {
        return this._baseUrl;
    }

    public ExchangexapiResponse<List<ApplicationsGETResponseBody>> get(ApplicationsGETQueryParam queryParameters, String authorizationToken) {
        WebTarget target = this._client.target(this.getBaseUri());
        if (queryParameters.getGroupInstanceId() != null) {
            target = target.queryParam("groupInstanceId", new Object[]{queryParameters.getGroupInstanceId()});
        }
        if (queryParameters.getOffset() != null) {
            target = target.queryParam("offset", new Object[]{queryParameters.getOffset()});
        }
        if (queryParameters.getIncludeContractsForApiVersion() != null) {
            target = target.queryParam("includeContractsForApiVersion", new Object[]{queryParameters.getIncludeContractsForApiVersion()});
        }
        if (queryParameters.getQuery() != null) {
            target = target.queryParam("query", new Object[]{queryParameters.getQuery()});
        }
        if (queryParameters.getLiteralMatch() != null) {
            target = target.queryParam("literalMatch", new Object[]{queryParameters.getLiteralMatch()});
        }
        if (queryParameters.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{queryParameters.getLimit()});
        }
        if (queryParameters.getApiInstanceId() != null) {
            target = target.queryParam("apiInstanceId", new Object[]{queryParameters.getApiInstanceId()});
        }
        if (queryParameters.getSort() != null) {
            target = target.queryParam("sort", new Object[]{queryParameters.getSort()});
        }
        if (queryParameters.getAscending() != null) {
            target = target.queryParam("ascending", new Object[]{queryParameters.getAscending()});
        }
        Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        invocationBuilder.header("Authorization", (Object)("bearer " + authorizationToken));
        Response response = invocationBuilder.method("GET");
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            Response.StatusType statusInfo = response.getStatusInfo();
            throw new ExchangexapiException(statusInfo.getStatusCode(), statusInfo.getReasonPhrase(), (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        }
        ExchangexapiResponse<Object> apiResponse = new ExchangexapiResponse<Object>(response.readEntity((GenericType)new GenericType<List<ApplicationsGETResponseBody>>(){}), (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        return apiResponse;
    }

    public ExchangexapiResponse<ApplicationsPOSTResponseBody> post(ApplicationsPOSTBody body, ApplicationsPOSTQueryParam queryParameters, String authorizationToken) {
        WebTarget target = this._client.target(this.getBaseUri());
        if (queryParameters.getApiInstanceId() != null) {
            target = target.queryParam("apiInstanceId", new Object[]{queryParameters.getApiInstanceId()});
        }
        if (queryParameters.getApiGroupInstanceId() != null) {
            target = target.queryParam("apiGroupInstanceId", new Object[]{queryParameters.getApiGroupInstanceId()});
        }
        Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        invocationBuilder.header("Authorization", (Object)("bearer " + authorizationToken));
        Response response = invocationBuilder.method("POST", Entity.json((Object)body));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            Response.StatusType statusInfo = response.getStatusInfo();
            throw new ExchangexapiException(statusInfo.getStatusCode(), statusInfo.getReasonPhrase(), (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        }
        ExchangexapiResponse<Object> apiResponse = new ExchangexapiResponse<Object>(response.readEntity(ApplicationsPOSTResponseBody.class), (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        return apiResponse;
    }

    public ApplicationId applicationId(String applicationId) {
        return new ApplicationId(this.getBaseUri(), this.getClient(), applicationId);
    }
}

