/*
 * Decompiled with CFR 0.152.
 */
package org.mule.exchange.resource.assets.groupId.assetId;

import java.net.URLEncoder;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.mule.exchange.exceptions.ExchangexapiException;
import org.mule.exchange.resource.assets.groupId.assetId.asset.Asset;
import org.mule.exchange.resource.assets.groupId.assetId.domain.Domain;
import org.mule.exchange.resource.assets.groupId.assetId.icon.Icon;
import org.mule.exchange.resource.assets.groupId.assetId.identities.Identities;
import org.mule.exchange.resource.assets.groupId.assetId.minorVersions.MinorVersions;
import org.mule.exchange.resource.assets.groupId.assetId.model.AssetIdDELETEHeader;
import org.mule.exchange.resource.assets.groupId.assetId.model.AssetIdPATCHBody;
import org.mule.exchange.resource.assets.groupId.assetId.public_.Public;
import org.mule.exchange.resource.assets.groupId.assetId.version.Version;
import org.mule.exchange.resource.assets.groupId.assetId.versionGroups.VersionGroups;
import org.mule.exchange.responses.ExchangexapiResponse;

public class AssetId {
    private String _baseUrl;
    private Client _client;
    public final Identities identities;
    public final Asset asset;
    public final VersionGroups versionGroups;
    public final Public public_;
    public final Domain domain;
    public final MinorVersions minorVersions;
    public final Icon icon;

    public AssetId() {
        this._baseUrl = null;
        this._client = null;
        this.identities = null;
        this.asset = null;
        this.versionGroups = null;
        this.public_ = null;
        this.domain = null;
        this.minorVersions = null;
        this.icon = null;
    }

    public AssetId(String baseUrl, Client _client, String uriParam) {
        this._baseUrl = baseUrl + "/" + URLEncoder.encode(uriParam);
        this._client = _client;
        this.identities = new Identities(this.getBaseUri(), this.getClient());
        this.asset = new Asset(this.getBaseUri(), this.getClient());
        this.versionGroups = new VersionGroups(this.getBaseUri(), this.getClient());
        this.public_ = new Public(this.getBaseUri(), this.getClient());
        this.domain = new Domain(this.getBaseUri(), this.getClient());
        this.minorVersions = new MinorVersions(this.getBaseUri(), this.getClient());
        this.icon = new Icon(this.getBaseUri(), this.getClient());
    }

    protected Client getClient() {
        return this._client;
    }

    private String getBaseUri() {
        return this._baseUrl;
    }

    public Version version(String version) {
        return new Version(this.getBaseUri(), this.getClient(), version);
    }

    public ExchangexapiResponse<Void> delete(AssetIdDELETEHeader headers, String authorizationToken) {
        WebTarget target = this._client.target(this.getBaseUri());
        Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        if (headers.getXDeleteType() != null) {
            invocationBuilder.header("X-Delete-Type", (Object)headers.getXDeleteType());
        }
        invocationBuilder.header("Authorization", (Object)("bearer " + authorizationToken));
        Response response = invocationBuilder.method("DELETE");
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            Response.StatusType statusInfo = response.getStatusInfo();
            throw new ExchangexapiException(statusInfo.getStatusCode(), statusInfo.getReasonPhrase(), (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        }
        ExchangexapiResponse<Object> apiResponse = new ExchangexapiResponse<Object>(null, (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        return apiResponse;
    }

    public ExchangexapiResponse<Void> patch(AssetIdPATCHBody body, String authorizationToken) {
        WebTarget target = this._client.target(this.getBaseUri());
        Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        invocationBuilder.header("Authorization", (Object)("bearer " + authorizationToken));
        Response response = invocationBuilder.method("PATCH", Entity.json((Object)body));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            Response.StatusType statusInfo = response.getStatusInfo();
            throw new ExchangexapiException(statusInfo.getStatusCode(), statusInfo.getReasonPhrase(), (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        }
        ExchangexapiResponse<Object> apiResponse = new ExchangexapiResponse<Object>(null, (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        return apiResponse;
    }
}

