/*
 * Decompiled with CFR 0.152.
 */
package com.anthonycr.progress;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.Transformation;
import com.anthonycr.progress.BezierEaseInterpolator;
import com.anthonycr.progress.R;
import java.util.ArrayDeque;
import java.util.Queue;

public class AnimatedProgressBar
extends View {
    private int mProgress = 0;
    private boolean mBidirectionalAnimate = true;
    private int mDrawWidth = 0;
    private int mProgressColor;
    private final Interpolator mAlphaInterpolator = new LinearInterpolator();
    private final Interpolator mProgressInterpolator = new BezierEaseInterpolator();
    private final Queue<Animation> mAnimationQueue = new ArrayDeque<Animation>();
    private static final long PROGRESS_DURATION = 500L;
    private static final long ALPHA_DURATION = 200L;
    private final Paint mPaint = new Paint();
    private final Rect mRect = new Rect();

    public AnimatedProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public AnimatedProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        TypedArray array = context.getTheme().obtainStyledAttributes(attrs, R.styleable.AnimatedProgressBar, 0, 0);
        try {
            int DEFAULT_PROGRESS_COLOR = -65536;
            this.mProgressColor = array.getColor(R.styleable.AnimatedProgressBar_progressColor, DEFAULT_PROGRESS_COLOR);
            this.mBidirectionalAnimate = array.getBoolean(R.styleable.AnimatedProgressBar_bidirectionalAnimate, false);
        }
        finally {
            array.recycle();
        }
    }

    public int getProgress() {
        return this.mProgress;
    }

    protected void onDraw(Canvas canvas) {
        this.mPaint.setColor(this.mProgressColor);
        this.mPaint.setStrokeWidth(10.0f);
        this.mRect.right = this.mRect.left + this.mDrawWidth;
        canvas.drawRect(this.mRect, this.mPaint);
    }

    public void setProgress(int progress) {
        if (progress > 100) {
            progress = 100;
        } else if (progress < 0) {
            progress = 0;
        }
        if (this.getAlpha() < 1.0f) {
            this.fadeIn();
        }
        int mWidth = this.getMeasuredWidth();
        this.mRect.left = 0;
        this.mRect.top = 0;
        this.mRect.bottom = this.getBottom() - this.getTop();
        if (progress < this.mProgress && !this.mBidirectionalAnimate) {
            this.mDrawWidth = 0;
        } else if (progress == this.mProgress && progress == 100) {
            this.fadeOut();
        }
        this.mProgress = progress;
        int deltaWidth = mWidth * this.mProgress / 100 - this.mDrawWidth;
        if (deltaWidth != 0) {
            this.animateView(this.mDrawWidth, deltaWidth, mWidth);
        }
    }

    private void animateView(int initialWidth, int deltaWidth, int maxWidth) {
        ProgressAnimation fill = new ProgressAnimation(initialWidth, deltaWidth, maxWidth);
        fill.setDuration(500L);
        fill.setInterpolator(this.mProgressInterpolator);
        if (!this.mAnimationQueue.isEmpty()) {
            this.mAnimationQueue.add(fill);
        } else {
            this.startAnimation(fill);
        }
    }

    private void fadeIn() {
        this.animate().alpha(1.0f).setDuration(200L).setInterpolator((TimeInterpolator)this.mAlphaInterpolator).start();
    }

    private void fadeOut() {
        this.animate().alpha(0.0f).setDuration(200L).setInterpolator((TimeInterpolator)this.mAlphaInterpolator).start();
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.mProgress = bundle.getInt("progressState");
            state = bundle.getParcelable("instanceState");
        }
        super.onRestoreInstanceState(state);
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("instanceState", super.onSaveInstanceState());
        bundle.putInt("progressState", this.mProgress);
        return bundle;
    }

    private class ProgressAnimation
    extends Animation {
        private int mInitialWidth;
        private int mDeltaWidth;
        private int mMaxWidth;

        ProgressAnimation(int initialWidth, int deltaWidth, int maxWidth) {
            this.mInitialWidth = initialWidth;
            this.mDeltaWidth = deltaWidth;
            this.mMaxWidth = maxWidth;
        }

        protected void applyTransformation(float interpolatedTime, Transformation t) {
            int width = this.mInitialWidth + (int)((float)this.mDeltaWidth * interpolatedTime);
            if (width <= this.mMaxWidth) {
                AnimatedProgressBar.this.mDrawWidth = width;
                AnimatedProgressBar.this.invalidate();
            }
            if ((double)Math.abs(1.0f - interpolatedTime) < 1.0E-5) {
                if (AnimatedProgressBar.this.mProgress >= 100) {
                    AnimatedProgressBar.this.fadeOut();
                }
                if (!AnimatedProgressBar.this.mAnimationQueue.isEmpty()) {
                    AnimatedProgressBar.this.startAnimation((Animation)AnimatedProgressBar.this.mAnimationQueue.poll());
                }
            }
        }

        public boolean willChangeBounds() {
            return false;
        }

        public boolean willChangeTransformationMatrix() {
            return false;
        }
    }
}

