/*
 * Decompiled with CFR 0.152.
 */
package com.log.kit;

import com.log.kit.ILogConfig;
import com.log.kit.ILogManager;
import com.log.kit.common.IStackTraceUtil;
import com.log.kit.print.ILogPrinter;
import java.util.Arrays;
import java.util.List;

public class ILog {
    private static final String I_LOG_PACKAGE;

    public static void v(Object ... contents) {
        ILog.log(2, contents);
    }

    public static void vt(String tag, Object ... contents) {
        ILog.log(2, tag, contents);
    }

    public static void d(Object ... contents) {
        ILog.log(3, contents);
    }

    public static void dt(String tag, Object ... contents) {
        ILog.log(3, tag, contents);
    }

    public static void i(Object ... contents) {
        ILog.log(4, contents);
    }

    public static void it(String tag, Object ... contents) {
        ILog.log(4, tag, contents);
    }

    public static void w(Object ... contents) {
        ILog.log(5, contents);
    }

    public static void wt(String tag, Object ... contents) {
        ILog.log(5, tag, contents);
    }

    public static void e(Object ... contents) {
        ILog.log(6, contents);
    }

    public static void et(String tag, Object ... contents) {
        ILog.log(6, tag, contents);
    }

    public static void a(Object ... contents) {
        ILog.log(7, contents);
    }

    public static void at(String tag, Object ... contents) {
        ILog.log(7, tag, contents);
    }

    private static void log(int type, Object ... contents) {
        String globalTag = ILogManager.getInstance().getConfig().getGlobalTag();
        ILog.log(type, globalTag, contents);
    }

    private static void log(int type, String tag, Object ... contents) {
        ILogConfig config = ILogManager.getInstance().getConfig();
        ILog.log(config, type, tag, contents);
    }

    private static void log(ILogConfig config, int type, String tag, Object ... contents) {
        List<ILogPrinter> printerList;
        String body;
        if (!config.enable()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (config.includeThread()) {
            String threadInfo = ILogConfig.I_THREAD_FORMATTER.format(Thread.currentThread());
            sb.append(threadInfo).append("\n");
        }
        if (config.stackTraceDepth() > 0) {
            StackTraceElement[] traceElements = IStackTraceUtil.getCroppedRealStackTrack(new Throwable().getStackTrace(), I_LOG_PACKAGE, config.stackTraceDepth());
            String traceInfo = ILogConfig.I_STACK_TRACE_FORMATTER.format(traceElements);
            sb.append(traceInfo).append("\n");
        }
        if ((body = ILog.parseBody(contents, config)) != null) {
            body = body.replace("\\\"", "\"");
        }
        sb.append(body);
        List<ILogPrinter> list = printerList = config.printers() != null ? Arrays.asList(config.printers()) : ILogManager.getInstance().getPrinters();
        if (printerList == null) {
            return;
        }
        for (ILogPrinter printer : printerList) {
            printer.print(config, type, tag, sb.toString());
        }
    }

    private static String parseBody(Object[] contents, ILogConfig config) {
        if (config.injectJsonParser() != null) {
            if (contents.length == 1 && contents[0] instanceof String) {
                return (String)contents[0];
            }
            return config.injectJsonParser().toJson(contents);
        }
        StringBuilder sb = new StringBuilder();
        for (Object o : contents) {
            sb.append(o.toString()).append(";");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    static {
        String className = ILog.class.getName();
        I_LOG_PACKAGE = className.substring(0, className.lastIndexOf(46) + 1);
    }
}

