/*
 * Decompiled with CFR 0.152.
 */
package com.crash.kit;

import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Environment;
import android.os.Process;
import android.os.StatFs;
import android.text.format.Formatter;
import com.crash.kit.util.ActivityManager;
import com.crash.kit.util.AppGlobals;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/crash/kit/CrashHandler;", "", "()V", "CRASH_DIR", "", "crashFiles", "", "Ljava/io/File;", "()[Ljava/io/File;", "init", "", "crashDir", "CaughtExceptionHandler", "crash-kit_release"})
public final class CrashHandler {
    private static String CRASH_DIR;
    public static final CrashHandler INSTANCE;

    public final void init(@NotNull String crashDir) {
        Intrinsics.checkParameterIsNotNull((Object)crashDir, (String)"crashDir");
        Thread.setDefaultUncaughtExceptionHandler(new CaughtExceptionHandler());
        CRASH_DIR = crashDir;
    }

    @NotNull
    public final File[] crashFiles() {
        Application application = AppGlobals.INSTANCE.get();
        File[] fileArray = new File(application != null ? application.getCacheDir() : null, CRASH_DIR).listFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileArray, (String)"File(AppGlobals.get()?.c\u2026r, CRASH_DIR).listFiles()");
        return fileArray;
    }

    private CrashHandler() {
    }

    static {
        CrashHandler crashHandler;
        INSTANCE = crashHandler = new CrashHandler();
        CRASH_DIR = "crash_dir";
    }

    public static final /* synthetic */ String access$getCRASH_DIR$p(CrashHandler $this) {
        CrashHandler crashHandler = $this;
        return CRASH_DIR;
    }

    public static final /* synthetic */ void access$setCRASH_DIR$p(CrashHandler $this, String string) {
        CrashHandler crashHandler = $this;
        CRASH_DIR = string;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/crash/kit/CrashHandler$CaughtExceptionHandler;", "Ljava/lang/Thread$UncaughtExceptionHandler;", "()V", "LAUNCH_TIME", "", "kotlin.jvm.PlatformType", "context", "Landroid/app/Application;", "defaultExceptionHandler", "formatter", "Ljava/text/SimpleDateFormat;", "collectionDeviceInfo", "e", "", "handleException", "", "restartApp", "", "saveCrashInfo2File", "log", "uncaughtException", "t", "Ljava/lang/Thread;", "crash-kit_release"})
    private static final class CaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private final Application context;
        private final SimpleDateFormat formatter;
        private final String LAUNCH_TIME;
        private final Thread.UncaughtExceptionHandler defaultExceptionHandler;

        @Override
        public void uncaughtException(@NotNull Thread t, @NotNull Throwable e) {
            Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            if (!this.handleException(e) && this.defaultExceptionHandler != null) {
                this.defaultExceptionHandler.uncaughtException(t, e);
            }
            this.restartApp();
        }

        private final boolean handleException(Throwable e) {
            if (e == null) {
                return false;
            }
            String log = this.collectionDeviceInfo(e);
            this.saveCrashInfo2File(log);
            return true;
        }

        private final String collectionDeviceInfo(Throwable e) {
            File file;
            StringBuilder sb = new StringBuilder();
            sb.append("brand=" + Build.BRAND + '\n');
            sb.append("rom=" + Build.MODEL + '\n');
            sb.append("os=" + Build.VERSION.RELEASE + '\n');
            sb.append("sdk=" + Build.VERSION.SDK_INT + '\n');
            sb.append("launch_time=" + this.LAUNCH_TIME + '\n');
            sb.append("crash_time=" + this.formatter.format(new Date()) + '\n');
            sb.append("forground=" + ActivityManager.Companion.getInstance().getFront() + '\n');
            StringBuilder stringBuilder = new StringBuilder().append("thread=");
            Thread thread = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
            sb.append(stringBuilder.append(thread.getName()).append('\n').toString());
            sb.append("cpu_arch=" + Build.CPU_ABI + '\n');
            PackageInfo packageInfo = this.context.getPackageManager().getPackageInfo(this.context.getPackageName(), 0);
            sb.append("version_code=" + packageInfo.versionCode + '\n');
            sb.append("version_name=" + packageInfo.versionName + '\n');
            sb.append("package_name=" + packageInfo.packageName + '\n');
            sb.append("requested_permission=" + Arrays.toString(packageInfo.requestedPermissions) + '\n');
            ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
            Object object = this.context.getSystemService("activity");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.app.ActivityManager");
            }
            android.app.ActivityManager ams = (android.app.ActivityManager)object;
            ams.getMemoryInfo(memInfo);
            sb.append("availMem=" + Formatter.formatFileSize((Context)((Context)this.context), (long)memInfo.availMem) + '\n');
            sb.append("totalMem=" + Formatter.formatFileSize((Context)((Context)this.context), (long)memInfo.totalMem) + '\n');
            File file2 = file = Environment.getExternalStorageDirectory();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
            StatFs statFs = new StatFs(file2.getPath());
            int availableSize = statFs.getAvailableBlocks() * statFs.getBlockSize();
            sb.append("availStorage=" + Formatter.formatFileSize((Context)((Context)this.context), (long)availableSize) + '\n');
            Writer write = new StringWriter();
            PrintWriter printWriter = new PrintWriter(write);
            e.printStackTrace(printWriter);
            for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                cause.printStackTrace(printWriter);
            }
            printWriter.close();
            sb.append(write.toString());
            String string = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void saveCrashInfo2File(String log) {
            File crashDir = new File(CrashHandler.access$getCRASH_DIR$p(INSTANCE));
            if (!crashDir.exists()) {
                crashDir.mkdirs();
            }
            File crashFile = new File(crashDir, this.formatter.format(new Date()) + "-crash.txt");
            crashFile.createNewFile();
            FileOutputStream fos = new FileOutputStream(crashFile);
            try {
                String string = log;
                FileOutputStream fileOutputStream = fos;
                Charset charset = Charsets.UTF_8;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string2.getBytes(charset);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] byArray2 = byArray;
                fileOutputStream.write(byArray2);
                fos.flush();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                fos.close();
            }
        }

        private final void restartApp() {
            Intent intent;
            PackageManager packageManager = this.context.getPackageManager();
            Intent intent2 = intent = packageManager != null ? packageManager.getLaunchIntentForPackage(this.context.getPackageName()) : null;
            if (intent2 != null) {
                intent2.addFlags(0x4000000);
            }
            this.context.startActivity(intent);
            Process.killProcess((int)Process.myPid());
            int n = 10;
            boolean bl = false;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }

        public CaughtExceptionHandler() {
            Application application = AppGlobals.INSTANCE.get();
            if (application == null) {
                Intrinsics.throwNpe();
            }
            this.context = application;
            this.formatter = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss", Locale.CHINA);
            this.LAUNCH_TIME = this.formatter.format(new Date());
            this.defaultExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        }
    }
}

