/*
 * Decompiled with CFR 0.152.
 */
package com.android.xselector.selector;

import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.support.annotation.ColorRes;
import android.support.annotation.Dimension;
import android.view.View;
import com.android.xselector.XSelector;
import com.android.xselector.interfaces.ISelectorUtil;
import com.android.xselector.selector.ShapeSelector;
import com.android.xselector.utils.XHelper;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class ShapeSelector
implements ISelectorUtil<Drawable, View> {
    static ShapeSelector mDevShape;
    private int lineWidth = 1;
    private int dashLineWidth = 1;
    private int dashLineColor = 1;
    private float dashWidth = 1.0f;
    private float dashGap = 1.0f;
    private int[] gradientColors;
    private float radialRadius;
    private int gradientType = 0;
    private String gradientOrientation = "TOP_BOTTOM";
    public static final String TOP_BOTTOM = "TOP_BOTTOM";
    public static final String TR_BL = "TR_BL";
    public static final String RIGHT_LEFT = "RIGHT_LEFT";
    public static final String BR_TL = "BR_TL";
    public static final String BOTTOM_TOP = "BOTTOM_TOP";
    public static final String BL_TR = "BL_TR";
    public static final String LEFT_RIGHT = "LEFT_RIGHT";
    public static final String TL_BR = "TL_BR";
    private boolean isBackgroundColor;
    private boolean isLine;
    private boolean isDashLine;
    private boolean isGradient;
    private boolean isRadius;
    private float topRightRadius = 0.0f;
    private float topLeftRadius = 0.0f;
    private float bottomRightRadius = 0.0f;
    private float bottomLeftRadius = 0.0f;
    private int mShape = 0;
    private int mDefaultBgColor;
    private int mDisabledBgColor;
    private int mPressedBgColor;
    private int mSelectedBgColor;
    private int mFocusedBgColor;
    private int mStrokeWidth = 0;
    private int mDefaultStrokeColor;
    private int mDisabledStrokeColor;
    private int mPressedStrokeColor;
    private int mSelectedStrokeColor;
    private int mFocusedStrokeColor;
    private int mCornerRadius = 0;
    private boolean hasSetDisabledBgColor = false;
    private boolean hasSetPressedBgColor = false;
    private boolean hasSetSelectedBgColor = false;
    private boolean hasSetFocusedBgColor = false;
    private boolean hasSetDisabledStrokeColor = false;
    private boolean hasSetPressedStrokeColor = false;
    private boolean hasSetSelectedStrokeColor = false;
    private boolean hasSetFocusedStrokeColor = false;

    private ShapeSelector() {
    }

    public static ShapeSelector getInstance() {
        mDevShape = new ShapeSelector();
        return mDevShape;
    }

    public ShapeSelector setShape(@Shape int shape) {
        this.mShape = shape;
        return this;
    }

    public ShapeSelector defaultBgColor(@ColorRes int tmpColor) {
        int color;
        this.mDefaultBgColor = color = XHelper.getColorRes(tmpColor);
        this.isBackgroundColor = true;
        if (!this.hasSetDisabledBgColor) {
            this.mDisabledBgColor = color;
        }
        if (!this.hasSetPressedBgColor) {
            this.mPressedBgColor = color;
        }
        if (!this.hasSetSelectedBgColor) {
            this.mSelectedBgColor = color;
        }
        if (!this.hasSetFocusedBgColor) {
            this.mFocusedBgColor = color;
        }
        return this;
    }

    public ShapeSelector defaultBgColor(String tmpColor) {
        int color;
        this.mDefaultBgColor = color = Color.parseColor((String)tmpColor);
        this.isBackgroundColor = true;
        if (!this.hasSetDisabledBgColor) {
            this.mDisabledBgColor = color;
        }
        if (!this.hasSetPressedBgColor) {
            this.mPressedBgColor = color;
        }
        if (!this.hasSetSelectedBgColor) {
            this.mSelectedBgColor = color;
        }
        if (!this.hasSetFocusedBgColor) {
            this.mFocusedBgColor = color;
        }
        return this;
    }

    public ShapeSelector disabledBgColor(@ColorRes int color) {
        this.mDisabledBgColor = XHelper.getColorRes(color);
        this.hasSetDisabledBgColor = true;
        this.isBackgroundColor = true;
        return this;
    }

    public ShapeSelector disabledBgColor(String color) {
        this.mDisabledBgColor = Color.parseColor((String)color);
        this.hasSetDisabledBgColor = true;
        this.isBackgroundColor = true;
        return this;
    }

    public ShapeSelector pressedBgColor(@ColorRes int color) {
        this.mPressedBgColor = XHelper.getColorRes(color);
        this.hasSetPressedBgColor = true;
        this.isBackgroundColor = true;
        return this;
    }

    public ShapeSelector pressedBgColor(String color) {
        this.mPressedBgColor = Color.parseColor((String)color);
        this.hasSetPressedBgColor = true;
        this.isBackgroundColor = true;
        return this;
    }

    public ShapeSelector selectedBgColor(@ColorRes int color) {
        this.mSelectedBgColor = XHelper.getColorRes(color);
        this.hasSetSelectedBgColor = true;
        this.isBackgroundColor = true;
        return this;
    }

    public ShapeSelector selectedBgColor(String color) {
        this.mSelectedBgColor = Color.parseColor((String)color);
        this.hasSetSelectedBgColor = true;
        this.isBackgroundColor = true;
        return this;
    }

    public ShapeSelector focusedBgColor(@ColorRes int color) {
        this.mFocusedBgColor = XHelper.getColorRes(color);
        this.isBackgroundColor = true;
        this.hasSetPressedBgColor = true;
        return this;
    }

    public ShapeSelector focusedBgColor(String color) {
        this.mFocusedBgColor = Color.parseColor((String)color);
        this.isBackgroundColor = true;
        this.hasSetPressedBgColor = true;
        return this;
    }

    public ShapeSelector strokeWidth(@Dimension int width) {
        this.mStrokeWidth = width;
        return this;
    }

    public ShapeSelector defaultStrokeColor(@ColorRes int tmpColor) {
        int color;
        this.mDefaultStrokeColor = color = XHelper.getColorRes(tmpColor);
        this.isLine = true;
        if (!this.hasSetDisabledStrokeColor) {
            this.mDisabledStrokeColor = color;
        }
        if (!this.hasSetPressedStrokeColor) {
            this.mPressedStrokeColor = color;
        }
        if (!this.hasSetSelectedStrokeColor) {
            this.mSelectedStrokeColor = color;
        }
        if (!this.hasSetFocusedStrokeColor) {
            this.mFocusedStrokeColor = color;
        }
        return this;
    }

    public ShapeSelector defaultStrokeColor(String tmpColor) {
        int color;
        this.mDefaultStrokeColor = color = Color.parseColor((String)tmpColor);
        this.isLine = true;
        if (!this.hasSetDisabledStrokeColor) {
            this.mDisabledStrokeColor = color;
        }
        if (!this.hasSetPressedStrokeColor) {
            this.mPressedStrokeColor = color;
        }
        if (!this.hasSetSelectedStrokeColor) {
            this.mSelectedStrokeColor = color;
        }
        if (!this.hasSetFocusedStrokeColor) {
            this.mFocusedStrokeColor = color;
        }
        return this;
    }

    public ShapeSelector disabledStrokeColor(@ColorRes int color) {
        this.mDisabledStrokeColor = XHelper.getColorRes(color);
        this.hasSetDisabledStrokeColor = true;
        this.isLine = true;
        return this;
    }

    public ShapeSelector disabledStrokeColor(String color) {
        this.mDisabledStrokeColor = Color.parseColor((String)color);
        this.hasSetDisabledStrokeColor = true;
        this.isLine = true;
        return this;
    }

    public ShapeSelector pressedStrokeColor(@ColorRes int color) {
        this.mPressedStrokeColor = XHelper.getColorRes(color);
        this.hasSetPressedStrokeColor = true;
        this.isLine = true;
        return this;
    }

    public ShapeSelector pressedStrokeColor(String color) {
        this.mPressedStrokeColor = Color.parseColor((String)color);
        this.hasSetPressedStrokeColor = true;
        this.isLine = true;
        return this;
    }

    public ShapeSelector selectedStrokeColor(@ColorRes int color) {
        this.mSelectedStrokeColor = XHelper.getColorRes(color);
        this.hasSetSelectedStrokeColor = true;
        this.isLine = true;
        return this;
    }

    public ShapeSelector selectedStrokeColor(String color) {
        this.mSelectedStrokeColor = Color.parseColor((String)color);
        this.hasSetSelectedStrokeColor = true;
        this.isLine = true;
        return this;
    }

    public ShapeSelector focusedStrokeColor(@ColorRes int color) {
        this.mFocusedStrokeColor = XHelper.getColorRes(color);
        this.hasSetFocusedStrokeColor = true;
        this.isLine = true;
        return this;
    }

    public ShapeSelector focusedStrokeColor(String color) {
        this.mFocusedStrokeColor = Color.parseColor((String)color);
        this.hasSetFocusedStrokeColor = true;
        this.isLine = true;
        return this;
    }

    public ShapeSelector dashLine(int dashLineWidth, @ColorRes int dashLineColorResId, float dashWidth, float dashGap) {
        this.isDashLine = true;
        this.dashLineWidth = dashLineWidth;
        this.dashWidth = dashWidth;
        this.dashGap = dashGap;
        this.dashLineColor = XSelector.getContext().getResources().getColor(dashLineColorResId);
        return this;
    }

    public ShapeSelector dashLine(int dashLineWidth, String dashLineColor, float dashWidth, float dashGap) {
        this.isDashLine = true;
        this.dashLineWidth = dashLineWidth;
        this.dashWidth = dashWidth;
        this.dashGap = dashGap;
        this.dashLineColor = Color.parseColor((String)dashLineColor);
        return this;
    }

    public ShapeSelector gradient(@ColorRes int startColor, @ColorRes int endColor) {
        this.isGradient = true;
        this.gradientColors = new int[2];
        this.gradientColors[0] = XSelector.getContext().getResources().getColor(startColor);
        this.gradientColors[1] = XSelector.getContext().getResources().getColor(endColor);
        this.gradientType = 0;
        this.gradientOrientation = TOP_BOTTOM;
        return this;
    }

    public ShapeSelector gradient(String startColor, String endColor) {
        this.isGradient = true;
        this.gradientColors = new int[2];
        this.gradientColors[0] = Color.parseColor((String)startColor);
        this.gradientColors[1] = Color.parseColor((String)endColor);
        this.gradientType = 0;
        this.gradientOrientation = TOP_BOTTOM;
        return this;
    }

    public ShapeSelector gradientLinear(int ... gradientColorsResId) {
        this.isGradient = true;
        this.gradientType = 0;
        this.gradientOrientation = TOP_BOTTOM;
        if (gradientColorsResId.length > 1) {
            this.gradientColors = new int[gradientColorsResId.length];
            for (int i = 0; i < gradientColorsResId.length; ++i) {
                this.gradientColors[i] = XSelector.getContext().getResources().getColor(gradientColorsResId[i]);
            }
        } else {
            throw new ExceptionInInitializerError("\u6e10\u53d8\u989c\u8272\u6570\u7ec4\u81f3\u5c11\u9700\u8981\u4e24\u4e2a\u989c\u8272");
        }
        return this;
    }

    public ShapeSelector gradientLinear(String ... gradientColorsResId) {
        this.isGradient = true;
        this.gradientType = 0;
        this.gradientOrientation = TOP_BOTTOM;
        if (gradientColorsResId.length > 1) {
            this.gradientColors = new int[gradientColorsResId.length];
            for (int i = 0; i < gradientColorsResId.length; ++i) {
                this.gradientColors[i] = Color.parseColor((String)gradientColorsResId[i]);
            }
        } else {
            throw new ExceptionInInitializerError("\u6e10\u53d8\u989c\u8272\u6570\u7ec4\u81f3\u5c11\u9700\u8981\u4e24\u4e2a\u989c\u8272");
        }
        return this;
    }

    public ShapeSelector gradientLinear(String gradientOrientation, int ... gradientColorsResId) {
        this.isGradient = true;
        this.gradientType = 0;
        this.gradientOrientation = gradientOrientation;
        if (gradientColorsResId.length > 1) {
            this.gradientColors = new int[gradientColorsResId.length];
            for (int i = 0; i < gradientColorsResId.length; ++i) {
                this.gradientColors[i] = XSelector.getContext().getResources().getColor(gradientColorsResId[i]);
            }
        } else {
            throw new ExceptionInInitializerError("\u6e10\u53d8\u989c\u8272\u6570\u7ec4\u81f3\u5c11\u9700\u8981\u4e24\u4e2a\u989c\u8272");
        }
        return this;
    }

    public ShapeSelector gradientLinear(String gradientOrientation, String ... gradientColors) {
        this.isGradient = true;
        this.gradientType = 0;
        this.gradientOrientation = gradientOrientation;
        if (gradientColors.length > 1) {
            this.gradientColors = new int[gradientColors.length];
            for (int i = 0; i < gradientColors.length; ++i) {
                this.gradientColors[i] = Color.parseColor((String)gradientColors[i]);
            }
        } else {
            throw new ExceptionInInitializerError("\u6e10\u53d8\u989c\u8272\u6570\u7ec4\u81f3\u5c11\u9700\u8981\u4e24\u4e2a\u989c\u8272");
        }
        return this;
    }

    public ShapeSelector gradientSweep(int ... gradientColors) {
        this.isGradient = true;
        this.gradientType = 2;
        if (gradientColors.length > 1) {
            this.gradientColors = new int[gradientColors.length];
            for (int i = 0; i < gradientColors.length; ++i) {
                this.gradientColors[i] = XSelector.getContext().getResources().getColor(gradientColors[i]);
            }
        } else {
            throw new ExceptionInInitializerError("\u6e10\u53d8\u989c\u8272\u6570\u7ec4\u81f3\u5c11\u9700\u8981\u4e24\u4e2a\u989c\u8272");
        }
        return this;
    }

    public ShapeSelector gradientSweep(String ... gradientColors) {
        this.isGradient = true;
        this.gradientType = 2;
        if (gradientColors.length > 1) {
            this.gradientColors = new int[gradientColors.length];
            for (int i = 0; i < gradientColors.length; ++i) {
                this.gradientColors[i] = Color.parseColor((String)gradientColors[i]);
            }
        } else {
            throw new ExceptionInInitializerError("\u6e10\u53d8\u989c\u8272\u6570\u7ec4\u81f3\u5c11\u9700\u8981\u4e24\u4e2a\u989c\u8272");
        }
        return this;
    }

    public ShapeSelector gradientRadial(float radialRadius, int ... gradientColors) {
        this.isGradient = true;
        this.gradientType = 1;
        this.radialRadius = radialRadius;
        if (gradientColors.length > 1) {
            this.gradientColors = new int[gradientColors.length];
            for (int i = 0; i < gradientColors.length; ++i) {
                this.gradientColors[i] = XSelector.getContext().getResources().getColor(gradientColors[i]);
            }
        } else {
            throw new ExceptionInInitializerError("\u6e10\u53d8\u989c\u8272\u6570\u7ec4\u81f3\u5c11\u9700\u8981\u4e24\u4e2a\u989c\u8272");
        }
        return this;
    }

    public ShapeSelector gradientRadial(float radialRadius, String ... gradientColors) {
        this.isGradient = true;
        this.gradientType = 1;
        this.radialRadius = radialRadius;
        if (gradientColors.length > 1) {
            this.gradientColors = new int[gradientColors.length];
            for (int i = 0; i < gradientColors.length; ++i) {
                this.gradientColors[i] = Color.parseColor((String)gradientColors[i]);
            }
        } else {
            throw new ExceptionInInitializerError("\u6e10\u53d8\u989c\u8272\u6570\u7ec4\u81f3\u5c11\u9700\u8981\u4e24\u4e2a\u989c\u8272");
        }
        return this;
    }

    public ShapeSelector radius(float radius) {
        this.isRadius = true;
        this.topRightRadius = radius;
        this.topLeftRadius = radius;
        this.bottomRightRadius = radius;
        this.bottomLeftRadius = radius;
        return this;
    }

    public ShapeSelector trRadius(float topRightRadius) {
        this.isRadius = true;
        this.topRightRadius = topRightRadius;
        return this;
    }

    public ShapeSelector tlRadius(float topLeftRadius) {
        this.isRadius = true;
        this.topLeftRadius = topLeftRadius;
        return this;
    }

    public ShapeSelector brRadius(float bottomRightRadius) {
        this.isRadius = true;
        this.bottomRightRadius = bottomRightRadius;
        return this;
    }

    public ShapeSelector blRadius(float bottomLeftRadius) {
        this.isRadius = true;
        this.bottomLeftRadius = bottomLeftRadius;
        return this;
    }

    @Override
    public void into(View view) {
        if (this.isBackgroundColor) {
            view.setClickable(true);
        }
        view.setBackground((Drawable)this.createShape());
    }

    @Override
    public Drawable build() {
        return this.createShape();
    }

    private StateListDrawable createShape() {
        StateListDrawable selector = new StateListDrawable();
        if (this.hasSetDisabledBgColor || this.hasSetDisabledStrokeColor) {
            GradientDrawable disabledShape = this.getItemShape(this.mShape, this.mDisabledBgColor, this.mDisabledStrokeColor, this.dashLineColor);
            selector.addState(new int[]{-16842910}, (Drawable)disabledShape);
        }
        if (this.hasSetPressedBgColor || this.hasSetPressedStrokeColor) {
            GradientDrawable pressedShape = this.getItemShape(this.mShape, this.mPressedBgColor, this.mPressedStrokeColor, this.dashLineColor);
            selector.addState(new int[]{16842919}, (Drawable)pressedShape);
        }
        if (this.hasSetSelectedBgColor || this.hasSetSelectedStrokeColor) {
            GradientDrawable selectedShape = this.getItemShape(this.mShape, this.mSelectedBgColor, this.mSelectedStrokeColor, this.dashLineColor);
            selector.addState(new int[]{0x10100A1}, (Drawable)selectedShape);
        }
        if (this.hasSetFocusedBgColor || this.hasSetFocusedStrokeColor) {
            GradientDrawable focusedShape = this.getItemShape(this.mShape, this.mFocusedBgColor, this.mFocusedStrokeColor, this.dashLineColor);
            selector.addState(new int[]{16842908}, (Drawable)focusedShape);
        }
        GradientDrawable defaultShape = this.getItemShape(this.mShape, this.mDefaultBgColor, this.mDefaultStrokeColor, this.dashLineColor);
        selector.addState(new int[0], (Drawable)defaultShape);
        return selector;
    }

    private GradientDrawable.Orientation createGradientOrientation() {
        GradientDrawable.Orientation orientation = GradientDrawable.Orientation.TOP_BOTTOM;
        switch (this.gradientOrientation) {
            case "TOP_BOTTOM": {
                orientation = GradientDrawable.Orientation.TOP_BOTTOM;
                break;
            }
            case "TR_BL": {
                orientation = GradientDrawable.Orientation.TR_BL;
                break;
            }
            case "RIGHT_LEFT": {
                orientation = GradientDrawable.Orientation.RIGHT_LEFT;
                break;
            }
            case "BR_TL": {
                orientation = GradientDrawable.Orientation.BR_TL;
                break;
            }
            case "BOTTOM_TOP": {
                orientation = GradientDrawable.Orientation.BOTTOM_TOP;
                break;
            }
            case "BL_TR": {
                orientation = GradientDrawable.Orientation.BL_TR;
                break;
            }
            case "LEFT_RIGHT": {
                orientation = GradientDrawable.Orientation.LEFT_RIGHT;
                break;
            }
            case "TL_BR": {
                orientation = GradientDrawable.Orientation.TL_BR;
            }
        }
        return orientation;
    }

    private int dip2px(float dipValue) {
        float scale = XSelector.getContext().getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    private GradientDrawable getItemShape(int shape, int solidColor, int lineColor, int dashLineColor) {
        GradientDrawable drawable = new GradientDrawable();
        drawable.setShape(shape);
        if (this.isRadius) {
            float[] radii = new float[]{this.dip2px(this.topLeftRadius), this.dip2px(this.topLeftRadius), this.dip2px(this.topRightRadius), this.dip2px(this.topRightRadius), this.dip2px(this.bottomRightRadius), this.dip2px(this.bottomRightRadius), this.dip2px(this.bottomLeftRadius), this.dip2px(this.bottomLeftRadius)};
            drawable.setCornerRadii(radii);
        }
        if (this.isBackgroundColor) {
            drawable.setColor(solidColor);
        }
        if (this.isLine) {
            drawable.setStroke(this.dip2px(this.lineWidth), lineColor);
        }
        if (this.isDashLine) {
            drawable.setStroke(this.dip2px(this.dashLineWidth), dashLineColor, (float)this.dip2px(this.dashWidth), (float)this.dip2px(this.dashGap));
        }
        if (this.isGradient) {
            switch (this.gradientType) {
                case 0: {
                    drawable.setOrientation(this.createGradientOrientation());
                    break;
                }
                case 1: {
                    drawable.setGradientRadius((float)this.dip2px(this.radialRadius));
                    break;
                }
            }
            drawable.setGradientType(this.gradientType);
            drawable.setColors(this.gradientColors);
        }
        return drawable;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GradientOrientation {
    }
}

