/*
 * Decompiled with CFR 0.152.
 */
package com.android.xselector.selector;

import android.content.res.ColorStateList;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.view.View;
import android.widget.TextView;
import com.android.xselector.interfaces.ISelectorUtil;
import com.android.xselector.selector.ColorSelector;
import com.android.xselector.utils.XHelper;

public class DrawableSelector
implements ISelectorUtil<Drawable, View> {
    private static DrawableSelector mDrawableSelector;
    private Drawable mDisabledDrawable;
    private Drawable mSelectedDrawable;
    private Drawable mFocusedDrawable;
    private Drawable mPressedDrawable;
    private Drawable mNormalDrawable = new ColorDrawable(0);
    private boolean isSelectorColor;
    private ColorStateList mColorStateList;
    private boolean hasSetDisabledDrawable = false;
    private boolean hasSetPressedDrawable = false;
    private boolean hasSetSelectedDrawable = false;
    private boolean hasSetFocusedDrawable = false;

    public static DrawableSelector getInstance() {
        mDrawableSelector = new DrawableSelector();
        return mDrawableSelector;
    }

    private DrawableSelector() {
    }

    public DrawableSelector defaultDrawable(Drawable drawable) {
        this.mNormalDrawable = drawable;
        if (!this.hasSetDisabledDrawable) {
            this.mDisabledDrawable = drawable;
        }
        if (!this.hasSetPressedDrawable) {
            this.mPressedDrawable = drawable;
        }
        if (!this.hasSetSelectedDrawable) {
            this.mSelectedDrawable = drawable;
        }
        if (!this.hasSetFocusedDrawable) {
            this.mFocusedDrawable = drawable;
        }
        return this;
    }

    public DrawableSelector disabledDrawable(Drawable drawable) {
        this.mDisabledDrawable = drawable;
        this.hasSetDisabledDrawable = true;
        return this;
    }

    public DrawableSelector pressedDrawable(Drawable drawable) {
        this.mPressedDrawable = drawable;
        this.hasSetPressedDrawable = true;
        return this;
    }

    public DrawableSelector selectedDrawable(Drawable drawable) {
        this.mSelectedDrawable = drawable;
        this.hasSetSelectedDrawable = true;
        return this;
    }

    public DrawableSelector focusedDrawable(Drawable drawable) {
        this.mFocusedDrawable = drawable;
        this.hasSetFocusedDrawable = true;
        return this;
    }

    public DrawableSelector defaultDrawable(@DrawableRes int drawableRes) {
        return this.defaultDrawable(XHelper.getDrawableRes(drawableRes));
    }

    public DrawableSelector disabledDrawable(@DrawableRes int drawableRes) {
        return this.disabledDrawable(XHelper.getDrawableRes(drawableRes));
    }

    public DrawableSelector pressedDrawable(@DrawableRes int drawableRes) {
        return this.pressedDrawable(XHelper.getDrawableRes(drawableRes));
    }

    public DrawableSelector selectedDrawable(@DrawableRes int drawableRes) {
        return this.selectedDrawable(XHelper.getDrawableRes(drawableRes));
    }

    public DrawableSelector focusedDrawable(@DrawableRes int drawableRes) {
        return this.focusedDrawable(XHelper.getDrawableRes(drawableRes));
    }

    public DrawableSelector selectorBackground(Drawable pressedDrawable, Drawable normalDrawable) {
        this.mPressedDrawable = pressedDrawable;
        this.mNormalDrawable = normalDrawable;
        return this;
    }

    public DrawableSelector selectorColor(@ColorRes int pressedColorResId, @ColorRes int normalColorResId) {
        this.mColorStateList = ColorSelector.getInstance().pressedColor(pressedColorResId).defaultColor(normalColorResId).build();
        this.isSelectorColor = true;
        return this;
    }

    public DrawableSelector selectorColor(String pressedColor, String normalColor) {
        this.mColorStateList = ColorSelector.getInstance().pressedColor(pressedColor).defaultColor(normalColor).build();
        this.isSelectorColor = true;
        return this;
    }

    @Override
    public void into(View view) {
        view.setBackground((Drawable)this.create());
        if (this.isSelectorColor) {
            try {
                ((TextView)view).setTextColor(this.mColorStateList);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ExceptionInInitializerError("\u8bbe\u7f6e\u5b57\u4f53\u989c\u8272\u9009\u62e9\u5668\uff08Selector\uff09\u8bf7\u4f20\u5165TextView\uff08\u5305\u62ecButton\uff09\uff01\uff01\uff01");
            }
        }
    }

    @Override
    public Drawable build() {
        return this.create();
    }

    public StateListDrawable create() {
        StateListDrawable selector = new StateListDrawable();
        if (this.hasSetDisabledDrawable) {
            selector.addState(new int[]{-16842910}, this.mDisabledDrawable);
        }
        if (this.hasSetPressedDrawable) {
            selector.addState(new int[]{16842919}, this.mPressedDrawable);
        }
        if (this.hasSetSelectedDrawable) {
            selector.addState(new int[]{0x10100A1}, this.mSelectedDrawable);
        }
        if (this.hasSetFocusedDrawable) {
            selector.addState(new int[]{16842908}, this.mFocusedDrawable);
        }
        selector.addState(new int[0], this.mNormalDrawable);
        return selector;
    }
}

