/*
 * Decompiled with CFR 0.152.
 */
package com.cc.rnbridge.util;

import android.annotation.TargetApi;
import android.app.Application;
import android.app.DownloadManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import com.cc.rnbridge.RNBridge;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class RNBundleUtil {
    private static volatile RNBundleUtil defaultInstance;
    private DownloadManager mDownLoadManager;
    private long mDownloadId;
    private UpdateBundleCallBack mUpdateBundleCb;
    private File mBundleZipFile;
    private final String KEY_BUNDLE_DEFAULT_PATH_FILE = "finalbundle";
    private String mBundleFileName;
    private BroadcastReceiver receiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            RNBundleUtil.this.checkDownloadStatus();
        }
    };

    private RNBundleUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RNBundleUtil getInstance() {
        if (defaultInstance != null) return defaultInstance;
        Class<RNBundleUtil> clazz = RNBundleUtil.class;
        synchronized (RNBundleUtil.class) {
            if (defaultInstance != null) return defaultInstance;
            defaultInstance = new RNBundleUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultInstance;
        }
    }

    public static boolean unzip(File zipFile) {
        return RNBundleUtil.unzip(zipFile, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unzip(File zipFile, Boolean delete) {
        if (zipFile != null && zipFile.exists()) {
            ZipInputStream inZip = null;
            try {
                ZipEntry zipEntry;
                inZip = new ZipInputStream(new FileInputStream(zipFile));
                File dir = zipFile.getParentFile();
                while ((zipEntry = inZip.getNextEntry()) != null) {
                    int len;
                    String entryName = zipEntry.getName();
                    if (zipEntry.isDirectory()) {
                        File folder = new File(dir, entryName);
                        folder.mkdirs();
                        continue;
                    }
                    File file = new File(dir, entryName);
                    file.createNewFile();
                    FileOutputStream fos = new FileOutputStream(file);
                    byte[] buffer = new byte[1024];
                    while ((len = inZip.read(buffer)) != -1) {
                        fos.write(buffer, 0, len);
                        fos.flush();
                    }
                    fos.close();
                }
                if (delete.booleanValue()) {
                    RNBundleUtil.deleteDir(zipFile);
                }
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                e.printStackTrace();
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (inZip != null) {
                        inZip.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    public static void deleteDir(File dir) {
        if (dir == null || !dir.exists()) {
            return;
        }
        if (dir.isFile()) {
            dir.delete();
            return;
        }
        if (dir.isDirectory()) {
            File[] childFile = dir.listFiles();
            if (childFile == null || childFile.length == 0) {
                dir.delete();
                return;
            }
            for (File f : childFile) {
                RNBundleUtil.deleteDir(f);
            }
            dir.delete();
        }
    }

    @TargetApi(value=23)
    public static boolean checkPermission(AppCompatActivity activity, @NonNull String[] permissions, int requestCode) {
        return RNBundleUtil.checkPermission(activity, permissions, requestCode, true);
    }

    public static boolean checkPermission(AppCompatActivity activity, @NonNull String[] permissions, int requestCode, boolean auth) {
        boolean isGranted = true;
        if (Build.VERSION.SDK_INT >= 23) {
            for (String permission : permissions) {
                if (activity.checkSelfPermission(permission) == 0) continue;
                isGranted = false;
            }
            if (!isGranted && auth) {
                activity.requestPermissions(permissions, requestCode);
            }
        }
        return isGranted;
    }

    @Deprecated
    public void downLoadBundle(String bundleUrl, UpdateBundleCallBack updateBundleCallBack) {
        if (TextUtils.isEmpty((CharSequence)bundleUrl)) {
            return;
        }
        this.mUpdateBundleCb = updateBundleCallBack;
        this.mBundleFileName = bundleUrl.substring(bundleUrl.lastIndexOf("/") + 1);
        String defaultSavePath = this.getApplication().getExternalCacheDir() + "/" + "finalbundle";
        this.mBundleZipFile = new File(defaultSavePath, this.mBundleFileName);
        if (this.mBundleZipFile.exists()) {
            RNBundleUtil.deleteDir(this.mBundleZipFile);
        }
        DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)bundleUrl));
        request.setDestinationUri(Uri.parse((String)("file://" + this.mBundleZipFile.getAbsolutePath())));
        request.setNotificationVisibility(0);
        request.setVisibleInDownloadsUi(true);
        this.mDownLoadManager = (DownloadManager)this.getApplication().getSystemService("download");
        this.mDownloadId = this.mDownLoadManager.enqueue(request);
        this.getApplication().registerReceiver(this.receiver, new IntentFilter("android.intent.action.DOWNLOAD_COMPLETE"));
    }

    private Application getApplication() {
        return RNBridge.getInstance().getApplication();
    }

    private void checkDownloadStatus() {
        DownloadManager.Query query = new DownloadManager.Query();
        query.setFilterById(new long[]{this.mDownloadId});
        Cursor c = this.mDownLoadManager.query(query);
        if (c.moveToFirst()) {
            int status = c.getInt(c.getColumnIndex("status"));
            switch (status) {
                case 4: {
                    System.out.println("\u4e0b\u8f7d\u6682\u505c");
                }
                case 1: {
                    System.out.println("\u4e0b\u8f7d\u5ef6\u8fdf");
                }
                case 2: {
                    System.out.println("\u6b63\u5728\u4e0b\u8f7d");
                    break;
                }
                case 8: {
                    System.out.println("\u4e0b\u8f7d\u6210\u529f");
                    this.replaceBundle();
                    break;
                }
                case 16: {
                    System.out.println("\u4e0b\u8f7d\u5931\u8d25");
                }
            }
        }
    }

    protected void replaceBundle() {
        String defaultSavePath = this.getApplication().getExternalCacheDir() + "/" + "finalbundle";
        File reactDir = new File(defaultSavePath);
        if (!reactDir.exists()) {
            reactDir.mkdirs();
        }
        if (this.mBundleZipFile == null || !this.mBundleZipFile.exists()) {
            this.sendMsgToCb(null);
            return;
        }
        boolean result = RNBundleUtil.unzip(this.mBundleZipFile);
        if (result) {
            if (!TextUtils.isEmpty((CharSequence)this.mBundleFileName) && this.mBundleFileName.contains(".")) {
                this.sendMsgToCb(defaultSavePath + "/" + this.mBundleFileName.substring(0, this.mBundleFileName.lastIndexOf(".")));
            } else {
                this.sendMsgToCb(defaultSavePath + "/" + this.mBundleFileName);
            }
        } else {
            this.sendMsgToCb(null);
            System.out.println("\u89e3\u538b\u5931\u8d25");
            File reactbundleDir = new File(defaultSavePath);
            RNBundleUtil.deleteDir(reactbundleDir);
        }
    }

    private void sendMsgToCb(String path) {
        if (this.mUpdateBundleCb != null) {
            this.mUpdateBundleCb.getUnZipBundlePath(path);
        }
    }

    public static interface UpdateBundleCallBack {
        public void getUnZipBundlePath(String var1);
    }
}

