/*
 * Decompiled with CFR 0.152.
 */
package com.cc.rnbridge.base;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Toast;
import com.cc.rnbridge.RNBridge;
import com.cc.rnbridge.entity.BundleConfig;
import com.cc.rnbridge.util.UrlUtil;
import com.facebook.react.ReactInstanceManager;
import com.facebook.react.ReactRootView;
import com.facebook.react.modules.core.DefaultHardwareBackBtnHandler;

public class ReactBridgeActivity
extends AppCompatActivity
implements DefaultHardwareBackBtnHandler {
    public static final String KEY_BUNDLE_CONFIG = "key_bundle_config";
    public static final String KEY_BUNDLE_ID = "bundleId";
    public static final String DEFAULT_RN_HOST = "rnbridge://app.native.com";
    protected BundleConfig mBundleConfig;
    private int mBundleId;
    private ReactRootView mReactRootView;

    public static void openRnUrl(Context mContext, String targetUrl, BundleConfig bundleConfig) {
        if (TextUtils.isEmpty((CharSequence)targetUrl)) {
            return;
        }
        if (bundleConfig == null) {
            bundleConfig = new BundleConfig.BundleConfigBuild().build();
        }
        if (targetUrl.startsWith("/")) {
            targetUrl = DEFAULT_RN_HOST + targetUrl;
        }
        UrlUtil.UrlEntity urlEntity = UrlUtil.toUrlBundle(targetUrl, bundleConfig.getAppProperties());
        targetUrl = urlEntity.baseUrl;
        Bundle appProperties = urlEntity.params;
        targetUrl = UrlUtil.toUrlParams(targetUrl, appProperties);
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)targetUrl));
        if (bundleConfig != null) {
            if (appProperties != null && appProperties.size() > 0) {
                bundleConfig.setAppProperties(appProperties);
            }
            intent.putExtra(KEY_BUNDLE_CONFIG, (Parcelable)bundleConfig);
        }
        mContext.startActivity(intent);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.initData();
        if (this.mBundleConfig != null && !this.isCustomRootView().booleanValue()) {
            this.mReactRootView = new ReactRootView((Context)this);
            this.setContentView((View)this.mReactRootView);
            RNBridge.getInstance().setRootView(this.mReactRootView, this.mBundleConfig);
        }
    }

    private void initData() {
        this.mBundleId = this.getBundleId();
        if (this.getBundleConfig() != null) {
            this.mBundleConfig = this.getBundleConfig();
        } else {
            this.mBundleConfig = this.getBundleConfig(this.mBundleId);
            if (this.mBundleConfig == null) {
                Toast.makeText((Context)this, (CharSequence)("\u672a\u67e5\u8be2\u5230" + this.mBundleId + "\u5bf9\u5e94\u7684bundle\u914d\u7f6e\u4fe1\u606f"), (int)0).show();
            }
        }
    }

    protected BundleConfig getBundleConfig(int bundleId) {
        return null;
    }

    private int getBundleId() {
        Uri uri = this.getIntent().getData();
        String idStr = null;
        if (uri != null) {
            idStr = uri.getQueryParameter(KEY_BUNDLE_ID);
        }
        if (!TextUtils.isEmpty(idStr)) {
            return Integer.valueOf(idStr);
        }
        return 0;
    }

    protected Boolean isCustomRootView() {
        return false;
    }

    protected ReactRootView getReactRootView() {
        return this.mReactRootView;
    }

    protected BundleConfig getBundleConfig() {
        if (this.getIntent() != null && this.getIntent().hasExtra(KEY_BUNDLE_CONFIG)) {
            return (BundleConfig)this.getIntent().getParcelableExtra(KEY_BUNDLE_CONFIG);
        }
        return null;
    }

    public int getCurrentBundleId() {
        if (this.getBundleConfig() != null) {
            return this.getBundleConfig().getBundleId();
        }
        return 0;
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == 82 && this.getReactInstanceManager() != null) {
            this.getReactInstanceManager().showDevOptionsDialog();
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    public void invokeDefaultOnBackPressed() {
        super.onBackPressed();
    }

    protected void onPause() {
        super.onPause();
        if (this.getReactInstanceManager() != null) {
            this.getReactInstanceManager().onHostPause((Activity)this);
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.getReactInstanceManager() != null) {
            this.getReactInstanceManager().onHostResume((Activity)this, (DefaultHardwareBackBtnHandler)this);
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.getReactInstanceManager() != null) {
            this.getReactInstanceManager().onHostDestroy();
        }
    }

    public void onBackPressed() {
        if (this.getReactInstanceManager() != null) {
            this.getReactInstanceManager().onBackPressed();
        } else {
            super.onBackPressed();
        }
    }

    private ReactInstanceManager getReactInstanceManager() {
        return RNBridge.getInstance().getReactInstanceManager(this.getCurrentBundleId());
    }
}

