/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.avd;

import com.android.sdklib.internal.avd.ConfigEnum;

public enum GpuMode implements ConfigEnum
{
    AUTO("auto"),
    HOST("host"),
    SWIFT("software"),
    OFF("off");

    private String mySetting;

    private GpuMode(String setting) {
        this.mySetting = setting;
    }

    public String toString() {
        switch (this) {
            case AUTO: {
                return "Automatic";
            }
            case HOST: {
                return "Hardware";
            }
        }
        return "Software";
    }

    public static GpuMode fromGpuSetting(String setting) {
        for (GpuMode mode : GpuMode.values()) {
            if (!mode.mySetting.equals(setting)) continue;
            return mode;
        }
        return OFF;
    }

    public String getGpuSetting() {
        return this.mySetting;
    }

    @Override
    public String getAsParameter() {
        return this.getGpuSetting();
    }
}

