/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.google.common.base.Strings;
import java.util.Locale;

public class SdkVersionInfo {
    public static final int HIGHEST_KNOWN_API = 34;
    public static final int HIGHEST_KNOWN_STABLE_API = 34;
    public static final int HIGHEST_SUPPORTED_API = 34;
    public static final int LOWEST_ACTIVE_API = 16;
    public static final int RECOMMENDED_MIN_SDK_VERSION = 24;
    public static final int HIGHEST_KNOWN_API_WEAR = 34;
    public static final int LOWEST_ACTIVE_API_WEAR = 28;
    public static final int HIGHEST_KNOWN_API_DESKTOP = 32;
    public static final int HIGHEST_KNOWN_API_TV = 34;
    public static final int HIGHEST_KNOWN_API_AUTO = 33;
    public static final int LOWEST_ACTIVE_API_TV = 21;
    public static final int LOWEST_COMPILE_SDK_VERSION = 22;
    public static final int LOWEST_PROFILE_GUIDED_OPTIMIZATIONS_SDK_VERSION = 24;
    public static final int CUR_DEVELOPMENT = 10000;

    public static String getReleaseVersionString(int api) {
        switch (api) {
            case 1: {
                return "1.0";
            }
            case 2: {
                return "1.1";
            }
            case 3: {
                return "1.5";
            }
            case 4: {
                return "1.6";
            }
            case 5: {
                return "2.0";
            }
            case 6: {
                return "2.0.1";
            }
            case 7: {
                return "2.1";
            }
            case 8: {
                return "2.2";
            }
            case 9: {
                return "2.3";
            }
            case 10: {
                return "2.3.3";
            }
            case 11: {
                return "3.0";
            }
            case 12: {
                return "3.1";
            }
            case 13: {
                return "3.2";
            }
            case 14: {
                return "4.0";
            }
            case 15: {
                return "4.0.3";
            }
            case 16: {
                return "4.1";
            }
            case 17: {
                return "4.2";
            }
            case 18: {
                return "4.3";
            }
            case 19: {
                return "4.4";
            }
            case 20: {
                return "4.4W";
            }
            case 21: {
                return "5.0";
            }
            case 22: {
                return "5.1";
            }
            case 23: {
                return "6.0";
            }
            case 24: {
                return "7.0";
            }
            case 25: {
                return "7.1.1";
            }
            case 26: {
                return "8.0";
            }
            case 27: {
                return "8.1";
            }
            case 28: {
                return "9.0";
            }
            case 29: {
                return "10.0";
            }
            case 30: {
                return "11.0";
            }
            case 31: {
                return "12.0";
            }
            case 32: {
                return "12L";
            }
            case 33: {
                return "13.0";
            }
            case 34: {
                return "14.0";
            }
        }
        return null;
    }

    public static String getVersionString(int api) {
        String releaseVersion = SdkVersionInfo.getReleaseVersionString(api);
        return releaseVersion != null ? releaseVersion : SdkVersionInfo.getCodeName(api);
    }

    public static String getCodeName(int api) {
        switch (api) {
            case 1: 
            case 2: {
                return null;
            }
            case 3: {
                return "Cupcake";
            }
            case 4: {
                return "Donut";
            }
            case 5: 
            case 6: 
            case 7: {
                return "Eclair";
            }
            case 8: {
                return "Froyo";
            }
            case 9: 
            case 10: {
                return "Gingerbread";
            }
            case 11: 
            case 12: 
            case 13: {
                return "Honeycomb";
            }
            case 14: 
            case 15: {
                return "IceCreamSandwich";
            }
            case 16: 
            case 17: 
            case 18: {
                return "Jelly Bean";
            }
            case 19: {
                return "KitKat";
            }
            case 20: {
                return "KitKat Wear";
            }
            case 21: 
            case 22: {
                return "Lollipop";
            }
            case 23: {
                return "Marshmallow";
            }
            case 24: 
            case 25: {
                return "Nougat";
            }
            case 26: 
            case 27: {
                return "Oreo";
            }
            case 28: {
                return "Pie";
            }
            case 29: {
                return "Q";
            }
            case 30: {
                return "R";
            }
            case 31: {
                return "S";
            }
            case 32: {
                return "Sv2";
            }
            case 33: {
                return "Tiramisu";
            }
            case 34: {
                return "UpsideDownCake";
            }
        }
        return null;
    }

    public static String getBuildCode(int api) {
        switch (api) {
            case 1: {
                return "BASE";
            }
            case 2: {
                return "BASE_1_1";
            }
            case 3: {
                return "CUPCAKE";
            }
            case 4: {
                return "DONUT";
            }
            case 5: {
                return "ECLAIR";
            }
            case 6: {
                return "ECLAIR_0_1";
            }
            case 7: {
                return "ECLAIR_MR1";
            }
            case 8: {
                return "FROYO";
            }
            case 9: {
                return "GINGERBREAD";
            }
            case 10: {
                return "GINGERBREAD_MR1";
            }
            case 11: {
                return "HONEYCOMB";
            }
            case 12: {
                return "HONEYCOMB_MR1";
            }
            case 13: {
                return "HONEYCOMB_MR2";
            }
            case 14: {
                return "ICE_CREAM_SANDWICH";
            }
            case 15: {
                return "ICE_CREAM_SANDWICH_MR1";
            }
            case 16: {
                return "JELLY_BEAN";
            }
            case 17: {
                return "JELLY_BEAN_MR1";
            }
            case 18: {
                return "JELLY_BEAN_MR2";
            }
            case 19: {
                return "KITKAT";
            }
            case 20: {
                return "KITKAT_WATCH";
            }
            case 21: {
                return "LOLLIPOP";
            }
            case 22: {
                return "LOLLIPOP_MR1";
            }
            case 23: {
                return "M";
            }
            case 24: {
                return "N";
            }
            case 25: {
                return "N_MR1";
            }
            case 26: {
                return "O";
            }
            case 27: {
                return "O_MR1";
            }
            case 28: {
                return "P";
            }
            case 29: {
                return "Q";
            }
            case 30: {
                return "R";
            }
            case 31: {
                return "S";
            }
            case 32: {
                return "S_V2";
            }
            case 33: {
                return "TIRAMISU";
            }
            case 34: {
                return "UPSIDE_DOWN_CAKE";
            }
        }
        return null;
    }

    public static int getApiByBuildCode(String buildCode, boolean recognizeUnknowns) {
        for (int api = 1; api <= 34; ++api) {
            String code = SdkVersionInfo.getBuildCode(api);
            if (code == null || !code.equalsIgnoreCase(buildCode)) continue;
            return api;
        }
        if (buildCode.equalsIgnoreCase("L")) {
            return 21;
        }
        return recognizeUnknowns ? 35 : -1;
    }

    public static int getApiByPreviewName(String previewName, boolean recognizeUnknowns) {
        int code;
        String codeName;
        String string = codeName = previewName.contains("_") ? previewName : SdkVersionInfo.camelCaseToUnderlines(previewName).toUpperCase(Locale.US);
        if (codeName.contains("KIT_KAT")) {
            codeName = codeName.replace("KIT_KAT", "KITKAT");
        }
        if ((code = SdkVersionInfo.getApiByBuildCode(codeName, false)) == -1) {
            for (int api = 1; api <= 34; ++api) {
                String c = SdkVersionInfo.getCodeName(api);
                if (c == null || !c.equalsIgnoreCase(codeName) && !c.equalsIgnoreCase(previewName)) continue;
                return api;
            }
            if (previewName.equalsIgnoreCase("KeyLimePie")) {
                return 19;
            }
            if (recognizeUnknowns) {
                code = SdkVersionInfo.getApiByBuildCode(codeName, true);
            }
        }
        return code;
    }

    public static String camelCaseToUnderlines(String string) {
        if (string.isEmpty()) {
            return string;
        }
        StringBuilder sb = new StringBuilder(2 * string.length());
        int n = string.length();
        boolean lastWasUpperCase = Character.isUpperCase(string.charAt(0));
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            boolean isUpperCase = Character.isUpperCase(c);
            if (isUpperCase && !lastWasUpperCase) {
                sb.append('_');
            }
            lastWasUpperCase = isUpperCase;
            c = Character.toLowerCase(c);
            sb.append(c);
        }
        return sb.toString();
    }

    public static String underlinesToCamelCase(String string) {
        StringBuilder sb = new StringBuilder(string.length());
        int n = string.length();
        boolean upcaseNext = true;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '_') {
                upcaseNext = true;
                continue;
            }
            if (upcaseNext) {
                c = Character.toUpperCase(c);
            }
            upcaseNext = false;
            sb.append(c);
        }
        return sb.toString();
    }

    public static AndroidVersion getVersion(String apiOrPreviewName, IAndroidTarget[] targets) {
        int api;
        if (Strings.isNullOrEmpty((String)apiOrPreviewName)) {
            return null;
        }
        if (Character.isDigit(apiOrPreviewName.charAt(0))) {
            try {
                int api2 = Integer.parseInt(apiOrPreviewName);
                if (api2 >= 1) {
                    return new AndroidVersion(api2, null);
                }
                return null;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (targets != null) {
            for (int i = targets.length - 1; i >= 0; --i) {
                AndroidVersion version;
                IAndroidTarget target = targets[i];
                if (!target.isPlatform() || !(version = target.getVersion()).isPreview() || !apiOrPreviewName.equalsIgnoreCase(version.getCodename())) continue;
                return new AndroidVersion(version.getApiLevel(), version.getCodename());
            }
        }
        if ((api = SdkVersionInfo.getApiByPreviewName(apiOrPreviewName, false)) != -1) {
            return new AndroidVersion(api - 1, apiOrPreviewName);
        }
        return new AndroidVersion(34, apiOrPreviewName);
    }
}

