/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.legacy;

import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.repository.legacy.remote.internal.ITaskMonitor;

class TaskMonitorProgressIndicatorAdapter
implements ITaskMonitor {
    private final ProgressIndicator myProgressIndicator;
    private int myProgressMax;
    private int myProgress;

    public TaskMonitorProgressIndicatorAdapter(ProgressIndicator progress) {
        this.myProgressIndicator = progress;
    }

    @Override
    public void setDescription(String format, Object ... args) {
        this.myProgressIndicator.setText(String.format(format, args));
    }

    @Override
    public void log(String format, Object ... args) {
        this.myProgressIndicator.logInfo(String.format(format, args));
    }

    @Override
    public void logError(String format, Object ... args) {
        this.myProgressIndicator.logError(String.format(format, args));
    }

    @Override
    public void logVerbose(String format, Object ... args) {
    }

    @Override
    public void setProgressMax(int max) {
        this.myProgressMax = max;
    }

    @Override
    public int getProgressMax() {
        return this.myProgressMax;
    }

    @Override
    public void incProgress(int delta) {
        this.myProgress += delta;
        this.myProgressIndicator.setFraction((double)((float)this.myProgress / (float)this.myProgressMax));
    }

    @Override
    public int getProgress() {
        return this.myProgress;
    }

    @Override
    public ITaskMonitor createSubMonitor(final int tickCount) {
        final TaskMonitorProgressIndicatorAdapter parent = this;
        return new TaskMonitorProgressIndicatorAdapter(this.myProgressIndicator){

            @Override
            public void incProgress(int delta) {
                TaskMonitorProgressIndicatorAdapter.this.myProgress = TaskMonitorProgressIndicatorAdapter.this.myProgress + delta;
                parent.incProgress((int)((float)delta * (float)tickCount / (float)TaskMonitorProgressIndicatorAdapter.this.myProgressMax));
            }
        };
    }

    public void error(Throwable t, String msgFormat, Object ... args) {
        this.myProgressIndicator.logError(msgFormat == null ? "" : String.format(msgFormat, args), t);
    }

    public void warning(String msgFormat, Object ... args) {
        this.myProgressIndicator.logWarning(String.format(msgFormat, args));
    }

    public void info(String msgFormat, Object ... args) {
        this.myProgressIndicator.logInfo(String.format(msgFormat, args));
    }

    public void verbose(String msgFormat, Object ... args) {
    }
}

