/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.logging.Level;
import java.util.logging.Logger;

class EllipseSolver {
    private static Logger logger = Logger.getLogger(EllipseSolver.class.getSimpleName());
    private float mMajorAxis = 0.0f;
    private float mMinorAxis = 0.0f;
    private float mRotationDegree = 0.0f;
    private boolean mDirectionChanged;
    private Point2D.Float mMajorAxisPoint;
    private Point2D.Float mMiddlePoint;
    private Point2D.Float mMinorAxisPoint;
    private Point2D.Float mDstMajorAxisPoint;
    private Point2D.Float mDstMiddlePoint;
    private Point2D.Float mDstMinorAxisPoint;

    private Point2D.Float rotatePoint2D(Point2D.Float inPoint, float radians) {
        Point2D.Float result = new Point2D.Float();
        float cosine = (float)Math.cos(radians);
        float sine = (float)Math.sin(radians);
        result.x = inPoint.x * cosine - inPoint.y * sine;
        result.y = inPoint.x * sine + inPoint.y * cosine;
        return result;
    }

    public EllipseSolver(AffineTransform totalTransform, float currentX, float currentY, float rx, float ry, float xAxisRotation, float largeArcFlag, float sweepFlag, float destX, float destY) {
        boolean largeArc = largeArcFlag != 0.0f;
        boolean sweep = sweepFlag != 0.0f;
        Point2D.Float originalCenter = this.computeOriginalCenter(currentX, currentY, rx, ry, xAxisRotation, largeArc, sweep, destX, destY);
        this.computeControlPoints(rx, ry, xAxisRotation, originalCenter.x, originalCenter.y);
        this.mDstMiddlePoint = (Point2D.Float)totalTransform.transform(this.mMiddlePoint, null);
        this.mDstMajorAxisPoint = (Point2D.Float)totalTransform.transform(this.mMajorAxisPoint, null);
        this.mDstMinorAxisPoint = (Point2D.Float)totalTransform.transform(this.mMinorAxisPoint, null);
        Point2D dstCenter = totalTransform.transform(originalCenter, null);
        float dstCenterX = (float)dstCenter.getX();
        float dstCenterY = (float)dstCenter.getY();
        float relativeDstMiddleX = this.mDstMiddlePoint.x - dstCenterX;
        float relativeDstMiddleY = this.mDstMiddlePoint.y - dstCenterY;
        float relativeDstMajorAxisPointX = this.mDstMajorAxisPoint.x - dstCenterX;
        float relativeDstMajorAxisPointY = this.mDstMajorAxisPoint.y - dstCenterY;
        float relativeDstMinorAxisPointX = this.mDstMinorAxisPoint.x - dstCenterX;
        float relativeDstMinorAxisPointY = this.mDstMinorAxisPoint.y - dstCenterY;
        this.mDirectionChanged = this.computeDirectionChange(this.mMiddlePoint, this.mMajorAxisPoint, this.mMinorAxisPoint, this.mDstMiddlePoint, this.mDstMajorAxisPoint, this.mDstMinorAxisPoint);
        if (this.computeABThetaFromControlPoints(relativeDstMiddleX, relativeDstMiddleY, relativeDstMajorAxisPointX, relativeDstMajorAxisPointY, relativeDstMinorAxisPointX, relativeDstMinorAxisPointY)) {
            logger.log(Level.WARNING, "Early return in the ellipse transformation computation!");
        }
    }

    private boolean computeDirectionChange(Point2D.Float middlePoint, Point2D.Float majorAxisPoint, Point2D.Float minorAxisPoint, Point2D.Float dstMiddlePoint, Point2D.Float dstMajorAxisPoint, Point2D.Float dstMinorAxisPoint) {
        float dstCrossProduct;
        float srcCrossProduct = this.getCrossProduct(middlePoint, majorAxisPoint, minorAxisPoint);
        return srcCrossProduct * (dstCrossProduct = this.getCrossProduct(dstMiddlePoint, dstMajorAxisPoint, dstMinorAxisPoint)) < 0.0f;
    }

    private float getCrossProduct(Point2D.Float middlePoint, Point2D.Float majorAxisPoint, Point2D.Float minorAxisPoint) {
        float majorMinusMiddleX = majorAxisPoint.x - middlePoint.x;
        float majorMinusMiddleY = majorAxisPoint.y - middlePoint.y;
        float minorMinusMiddleX = minorAxisPoint.x - middlePoint.x;
        float minorMinusMiddleY = minorAxisPoint.y - middlePoint.y;
        return majorMinusMiddleX * minorMinusMiddleY - majorMinusMiddleY * minorMinusMiddleX;
    }

    private boolean computeABThetaFromControlPoints(float relMiddleX, float relMiddleY, float relativeMajorAxisPointX, float relativeMajorAxisPointY, float relativeMinorAxisPointX, float relativeMinorAxisPointY) {
        float m13 = relMiddleY * relMiddleY;
        float m22 = relativeMajorAxisPointX * relativeMajorAxisPointY;
        float m31 = relativeMinorAxisPointX * relativeMinorAxisPointX;
        float m12 = relMiddleX * relMiddleY;
        float m23 = relativeMajorAxisPointY * relativeMajorAxisPointY;
        float m21 = relativeMajorAxisPointX * relativeMajorAxisPointX;
        float m32 = relativeMinorAxisPointX * relativeMinorAxisPointY;
        float m11 = relMiddleX * relMiddleX;
        float m33 = relativeMinorAxisPointY * relativeMinorAxisPointY;
        float det = -(m13 * m22 * m31 - m12 * m23 * m31 - m13 * m21 * m32 + m11 * m23 * m32 + m12 * m21 * m33 - m11 * m22 * m33);
        if (det == 0.0f) {
            return true;
        }
        float A = (-m13 * m22 + m12 * m23 + m13 * m32 - m23 * m32 - m12 * m33 + m22 * m33) / det;
        float B = (m13 * m21 - m11 * m23 - m13 * m31 + m23 * m31 + m11 * m33 - m21 * m33) / det;
        float C = (m12 * m21 - m11 * m22 - m12 * m31 + m22 * m31 + m11 * m32 - m21 * m32) / -det;
        if (A - C == 0.0f) {
            this.mMajorAxis = this.mMinorAxis = (float)Math.hypot(relativeMajorAxisPointX, relativeMajorAxisPointY);
            this.mRotationDegree = 0.0f;
            return false;
        }
        float doubleThetaInRadians = (float)Math.atan(B / (A - C));
        float thetaInRadians = doubleThetaInRadians / 2.0f;
        if (Math.sin(doubleThetaInRadians) == 0.0) {
            this.mMinorAxis = (float)Math.sqrt(1.0f / C);
            this.mMajorAxis = (float)Math.sqrt(1.0f / A);
            this.mRotationDegree = 0.0f;
            return false;
        }
        float bSqInv = (A + C + B / (float)Math.sin(doubleThetaInRadians)) / 2.0f;
        float aSqInv = A + C - bSqInv;
        if (bSqInv == 0.0f || aSqInv == 0.0f) {
            return true;
        }
        this.mMinorAxis = (float)Math.sqrt(1.0f / bSqInv);
        this.mMajorAxis = (float)Math.sqrt(1.0f / aSqInv);
        this.mRotationDegree = (float)Math.toDegrees(1.5707963267948966 + (double)thetaInRadians);
        return false;
    }

    private void computeControlPoints(float a, float b, float rot, float cx, float cy) {
        this.mMajorAxisPoint = new Point2D.Float(a, 0.0f);
        this.mMinorAxisPoint = new Point2D.Float(0.0f, b);
        this.mMajorAxisPoint = this.rotatePoint2D(this.mMajorAxisPoint, rot);
        this.mMinorAxisPoint = this.rotatePoint2D(this.mMinorAxisPoint, rot);
        this.mMajorAxisPoint.x += cx;
        this.mMajorAxisPoint.y += cy;
        this.mMinorAxisPoint.x += cx;
        this.mMinorAxisPoint.y += cy;
        float middleDegree = 45.0f;
        float middleRadians = (float)Math.toRadians(middleDegree);
        float middleR = a * b / (float)Math.hypot(b * (float)Math.cos(middleRadians), a * (float)Math.sin(middleRadians));
        this.mMiddlePoint = new Point2D.Float(middleR * (float)Math.cos(middleRadians), middleR * (float)Math.sin(middleRadians));
        this.mMiddlePoint = this.rotatePoint2D(this.mMiddlePoint, rot);
        this.mMiddlePoint.x += cx;
        this.mMiddlePoint.y += cy;
    }

    private Point2D.Float computeOriginalCenter(float x1, float y1, float rx, float ry, float phi, boolean largeArc, boolean sweep, float x2, float y2) {
        Point2D.Float result = new Point2D.Float();
        float cosPhi = (float)Math.cos(phi);
        float sinPhi = (float)Math.sin(phi);
        float xDelta = (x1 - x2) / 2.0f;
        float yDelta = (y1 - y2) / 2.0f;
        float tempX1 = cosPhi * xDelta + sinPhi * yDelta;
        float tempY1 = -sinPhi * xDelta + cosPhi * yDelta;
        float rxSq = rx * rx;
        float rySq = ry * ry;
        float tempX1Sq = tempX1 * tempX1;
        float tempY1Sq = tempY1 * tempY1;
        float tempCenterFactor = rxSq * rySq - rxSq * tempY1Sq - rySq * tempX1Sq;
        if ((tempCenterFactor /= rxSq * tempY1Sq + rySq * tempX1Sq) < 0.0f) {
            tempCenterFactor = 0.0f;
        }
        tempCenterFactor = (float)Math.sqrt(tempCenterFactor);
        if (largeArc == sweep) {
            tempCenterFactor = -tempCenterFactor;
        }
        float tempCx = tempCenterFactor * rx * tempY1 / ry;
        float tempCy = -tempCenterFactor * ry * tempX1 / rx;
        float xCenter = (x1 + x2) / 2.0f;
        float yCenter = (y1 + y2) / 2.0f;
        float cx = cosPhi * tempCx - sinPhi * tempCy + xCenter;
        float cy = sinPhi * tempCx + cosPhi * tempCy + yCenter;
        result.x = cx;
        result.y = cy;
        return result;
    }

    public float getMajorAxis() {
        return this.mMajorAxis;
    }

    public float getMinorAxis() {
        return this.mMinorAxis;
    }

    public float getRotationDegree() {
        return this.mRotationDegree;
    }

    public boolean getDirectionChanged() {
        return this.mDirectionChanged;
    }
}

