/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.res2;

import com.android.ide.common.blame.MergingLog;
import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.internal.PngException;
import com.android.ide.common.res2.AaptCompiler;
import com.android.ide.common.res2.DataFile;
import com.android.ide.common.res2.MergeConsumer;
import com.android.ide.common.res2.MergeWriter;
import com.android.ide.common.res2.MergingException;
import com.android.ide.common.res2.NodeUtils;
import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.res2.ResourcePreprocessor;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.utils.FileUtils;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MergedResourceWriter
extends MergeWriter<ResourceItem> {
    private final ResourcePreprocessor mPreprocessor;
    private final File mPublicFile;
    private MergingLog mMergingLog;
    private DocumentBuilderFactory mFactory;
    private final AaptCompiler mAaptCompiler;
    private ListMultimap<String, ResourceItem> mValuesResMap;
    private Set<String> mQualifierWithDeletedValues;
    private final ConcurrentLinkedDeque<Future<File>> mCompiling;
    private final File mTemporaryDirectory;

    public MergedResourceWriter(File rootFolder, File publicFile, File blameLogFolder, ResourcePreprocessor preprocessor, AaptCompiler aaptCompiler, File temporaryDirectory) {
        super(rootFolder);
        this.mAaptCompiler = aaptCompiler;
        this.mPublicFile = publicFile;
        this.mMergingLog = blameLogFolder != null ? new MergingLog(blameLogFolder) : null;
        this.mPreprocessor = preprocessor;
        this.mCompiling = new ConcurrentLinkedDeque();
        this.mTemporaryDirectory = temporaryDirectory;
    }

    public static MergedResourceWriter createWriterWithoutPngCruncher(File rootFolder, File publicFile, File blameLogFolder, ResourcePreprocessor preprocessor, File temporaryDirectory) {
        return new MergedResourceWriter(rootFolder, publicFile, blameLogFolder, preprocessor, (file, output) -> {
            SettableFuture future = SettableFuture.create();
            future.set(null);
            return future;
        }, temporaryDirectory);
    }

    @Override
    public void start(DocumentBuilderFactory factory) throws MergeConsumer.ConsumerException {
        super.start(factory);
        this.mValuesResMap = ArrayListMultimap.create();
        this.mQualifierWithDeletedValues = Sets.newHashSet();
        this.mFactory = factory;
    }

    @Override
    public void end() throws MergeConsumer.ConsumerException {
        super.end();
        try {
            Future<File> first;
            while ((first = this.mCompiling.pollFirst()) != null) {
                first.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new MergeConsumer.ConsumerException(e);
        }
        if (this.mMergingLog != null) {
            try {
                this.mMergingLog.write();
            }
            catch (IOException e) {
                throw new MergeConsumer.ConsumerException(e);
            }
            this.mMergingLog = null;
        }
        this.mValuesResMap = null;
        this.mQualifierWithDeletedValues = null;
        this.mFactory = null;
    }

    @Override
    public boolean ignoreItemInMerge(ResourceItem item) {
        return item.getIgnoredFromDiskMerge();
    }

    @Override
    public void addItem(ResourceItem item) throws MergeConsumer.ConsumerException {
        DataFile.FileType type = item.getSourceType();
        if (type == DataFile.FileType.XML_VALUES) {
            this.mValuesResMap.put((Object)item.getQualifiers(), (Object)item);
        } else {
            Preconditions.checkState((item.getSource() != null ? 1 : 0) != 0);
            if (item.isTouched()) {
                this.getExecutor().execute(() -> {
                    File file = item.getFile();
                    String filename = file.getName();
                    String folderName = MergedResourceWriter.getFolderName(item);
                    if (type == DataFile.FileType.GENERATED_FILES) {
                        try {
                            this.mPreprocessor.generateFile(file, ((ResourceFile)item.getSource()).getFile());
                        }
                        catch (Exception e) {
                            throw new MergeConsumer.ConsumerException((Throwable)e, ((ResourceFile)item.getSource()).getFile());
                        }
                    }
                    try {
                        ListenableFuture<File> result = this.mAaptCompiler.compile(file, this.getRootFolder());
                        this.mCompiling.add((Future<File>)result);
                        result.addListener(() -> {
                            try {
                                File outFile = (File)result.get();
                                if (outFile == null) {
                                    File typeFolder = new File(this.getRootFolder(), folderName);
                                    FileUtils.mkdirs((File)typeFolder);
                                    outFile = new File(typeFolder, filename);
                                    Files.copy((File)file, (File)outFile);
                                }
                                if (this.mMergingLog != null) {
                                    this.mMergingLog.logCopy(file, outFile);
                                }
                            }
                            catch (Exception e) {
                                SettableFuture failureSimulator = SettableFuture.create();
                                failureSimulator.setException((Throwable)e);
                                this.mCompiling.add((Future<File>)failureSimulator);
                            }
                        }, (Executor)MoreExecutors.sameThreadExecutor());
                    }
                    catch (PngException | IOException e) {
                        throw MergingException.wrapException(e).withFile(file).build();
                    }
                    return null;
                });
            }
        }
    }

    @Override
    public void removeItem(ResourceItem removedItem, ResourceItem replacedBy) throws MergeConsumer.ConsumerException {
        DataFile.FileType removedType = removedItem.getSourceType();
        DataFile.FileType replacedType = replacedBy != null ? replacedBy.getSourceType() : null;
        switch (removedType) {
            case SINGLE_FILE: 
            case GENERATED_FILES: {
                if (replacedType == DataFile.FileType.SINGLE_FILE || replacedType == DataFile.FileType.GENERATED_FILES) break;
                this.removeOutFile(removedItem);
                break;
            }
            case XML_VALUES: {
                this.mQualifierWithDeletedValues.add(removedItem.getQualifiers());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    protected void postWriteAction() throws MergeConsumer.ConsumerException {
        for (String key : this.mValuesResMap.keySet()) {
            boolean mustWriteFile = this.mQualifierWithDeletedValues.remove(key);
            List items = this.mValuesResMap.get((Object)key);
            if (!mustWriteFile) {
                for (ResourceItem item : items) {
                    if (!item.isTouched()) continue;
                    mustWriteFile = true;
                    break;
                }
            }
            if (!mustWriteFile) continue;
            try {
                boolean mkdirs;
                String content;
                File tmpDir = new File(this.mTemporaryDirectory, "merged.dir");
                FileUtils.deletePath((File)tmpDir);
                FileUtils.mkdirs((File)tmpDir);
                String folderName = key.isEmpty() ? ResourceFolderType.VALUES.getName() : ResourceFolderType.VALUES.getName() + "-" + key;
                File valuesFolder = new File(tmpDir, folderName);
                File outFile = new File(valuesFolder, folderName + ".xml");
                FileUtils.mkdirs((File)valuesFolder);
                DocumentBuilder builder = this.mFactory.newDocumentBuilder();
                Document document = builder.newDocument();
                String publicTag = ResourceType.PUBLIC.getName();
                ArrayList publicNodes = null;
                Element rootNode = document.createElement("resources");
                document.appendChild(rootNode);
                Collections.sort(items);
                for (ResourceItem item : items) {
                    Node nodeValue = item.getValue();
                    if (nodeValue != null && publicTag.equals(nodeValue.getNodeName())) {
                        if (publicNodes == null) {
                            publicNodes = Lists.newArrayList();
                        }
                        publicNodes.add(nodeValue);
                        continue;
                    }
                    rootNode.appendChild(document.createTextNode("\n    "));
                    ResourceFile source = (ResourceFile)item.getSource();
                    Node adoptedNode = NodeUtils.adoptNode(document, nodeValue);
                    if (source != null) {
                        XmlUtils.attachSourceFile((Node)adoptedNode, (SourceFile)new SourceFile(source.getFile()));
                    }
                    rootNode.appendChild(adoptedNode);
                }
                rootNode.appendChild(document.createTextNode("\n"));
                if (this.mMergingLog != null) {
                    LinkedHashMap blame = Maps.newLinkedHashMap();
                    content = XmlUtils.toXml((Node)document, (Map)blame);
                    this.mMergingLog.logSource(new SourceFile(outFile), blame);
                } else {
                    content = XmlUtils.toXml((Node)document);
                }
                Files.write((CharSequence)content, (File)outFile, (Charset)Charsets.UTF_8);
                ListenableFuture<File> f = this.mAaptCompiler.compile(outFile, this.getRootFolder());
                File result = (File)f.get();
                if (result == null) {
                    File copyFolder = new File(this.getRootFolder(), folderName);
                    FileUtils.mkdirs((File)copyFolder);
                    File copyOutput = new File(copyFolder, outFile.getName());
                    Files.copy((File)outFile, (File)copyOutput);
                }
                if (publicNodes == null || this.mPublicFile == null) continue;
                int size = publicNodes.size();
                StringBuilder sb = new StringBuilder(size * 80);
                for (Node node : publicNodes) {
                    if (node.getNodeType() != 1) continue;
                    Element element = (Element)node;
                    String name = element.getAttribute("name");
                    String type = element.getAttribute("type");
                    if (name.isEmpty() || type.isEmpty()) continue;
                    sb.append(type).append(' ').append(name).append('\n');
                }
                File parentFile = this.mPublicFile.getParentFile();
                if (!parentFile.exists() && !(mkdirs = parentFile.mkdirs())) {
                    throw new IOException("Could not create " + parentFile);
                }
                String text = sb.toString();
                Files.write((CharSequence)text, (File)this.mPublicFile, (Charset)Charsets.UTF_8);
            }
            catch (Exception e) {
                throw new MergeConsumer.ConsumerException(e);
            }
        }
        for (String key : this.mQualifierWithDeletedValues) {
            String folderName = key != null && !key.isEmpty() ? ResourceFolderType.VALUES.getName() + "-" + key : ResourceFolderType.VALUES.getName();
            this.removeOutFile(folderName, folderName + ".xml");
        }
    }

    private boolean removeOutFile(ResourceItem resourceItem) {
        return this.removeOutFile(MergedResourceWriter.getFolderName(resourceItem), resourceItem.getFile().getName());
    }

    private boolean removeOutFile(String folderName, String fileName) {
        File valuesFolder = new File(this.getRootFolder(), folderName);
        File outFile = new File(valuesFolder, fileName);
        if (this.mMergingLog != null) {
            this.mMergingLog.logRemove(new SourceFile(outFile));
        }
        return outFile.delete();
    }

    private static String getFolderName(ResourceItem resourceItem) {
        ResourceType itemType = resourceItem.getType();
        String folderName = itemType.getName();
        String qualifiers = resourceItem.getQualifiers();
        if (!qualifiers.isEmpty()) {
            folderName = folderName + "-" + qualifiers;
        }
        return folderName;
    }
}

