/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame.parser.aapt;

import com.android.annotations.NonNull;
import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.parser.ParsingFailedException;
import com.android.ide.common.blame.parser.aapt.AbstractAaptOutputParser;
import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Error4Parser
extends AbstractAaptOutputParser {
    private static final List<Pattern> MSG_PATTERNS = ImmutableList.of((Object)Pattern.compile("^Error\\s+parsing\\s+XML\\s+file\\s(.+)$"), (Object)Pattern.compile("^(.+)\\s+at\\s+line\\s+(\\d+)$"));

    Error4Parser() {
    }

    @Override
    public boolean parse(@NonNull String line, @NonNull OutputLineReader reader, @NonNull List<Message> messages, @NonNull ILogger logger) throws ParsingFailedException {
        Matcher m = MSG_PATTERNS.get(0).matcher(line);
        if (!m.matches()) {
            return false;
        }
        String sourcePath = m.group(1);
        m = this.getNextLineMatcher(reader, MSG_PATTERNS.get(1));
        if (m == null) {
            throw new ParsingFailedException();
        }
        String msgText = m.group(1);
        String lineNumber = m.group(2);
        Message msg = this.createMessage(Message.Kind.ERROR, msgText, sourcePath, lineNumber, "", logger);
        messages.add(msg);
        return true;
    }
}

