/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame.parser.aapt;

import com.android.annotations.NonNull;
import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.parser.ParsingFailedException;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.aapt.AbstractAaptOutputParser;
import com.android.ide.common.blame.parser.aapt.BadXmlBlockParser;
import com.android.ide.common.blame.parser.aapt.Error1Parser;
import com.android.ide.common.blame.parser.aapt.Error2Parser;
import com.android.ide.common.blame.parser.aapt.Error3Parser;
import com.android.ide.common.blame.parser.aapt.Error4Parser;
import com.android.ide.common.blame.parser.aapt.Error5Parser;
import com.android.ide.common.blame.parser.aapt.Error6Parser;
import com.android.ide.common.blame.parser.aapt.Error7Parser;
import com.android.ide.common.blame.parser.aapt.Error8Parser;
import com.android.ide.common.blame.parser.aapt.SkippingHiddenFileParser;
import com.android.ide.common.blame.parser.aapt.SkippingWarning1Parser;
import com.android.ide.common.blame.parser.aapt.SkippingWarning2Parser;
import com.android.ide.common.blame.parser.aapt.Warning1Parser;
import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.android.utils.ILogger;
import java.util.List;

public class AaptOutputParser
implements PatternAwareOutputParser {
    private static final AbstractAaptOutputParser[] PARSERS = new AbstractAaptOutputParser[]{new SkippingHiddenFileParser(), new Error1Parser(), new Error6Parser(), new Error2Parser(), new Error3Parser(), new Error4Parser(), new Warning1Parser(), new Error5Parser(), new Error7Parser(), new Error8Parser(), new SkippingWarning2Parser(), new SkippingWarning1Parser(), new BadXmlBlockParser()};

    @Override
    public boolean parse(@NonNull String line, @NonNull OutputLineReader reader, @NonNull List<Message> messages, @NonNull ILogger logger) {
        for (AbstractAaptOutputParser parser : PARSERS) {
            try {
                if (!parser.parse(line, reader, messages, logger)) continue;
                return true;
            }
            catch (ParsingFailedException e) {
                // empty catch block
            }
        }
        return false;
    }
}

