/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.installer;

import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.installer.AbstractUninstaller;
import com.android.repository.io.FileOp;
import java.io.File;

class BasicUninstaller
extends AbstractUninstaller {
    public BasicUninstaller(LocalPackage p, RepoManager mgr, FileOp fop) {
        super(p, mgr, fop);
    }

    @Override
    protected boolean doPrepare(File tempPath, ProgressIndicator progress) {
        return true;
    }

    @Override
    protected boolean doComplete(File tempPath, ProgressIndicator progress) {
        boolean successfullyDeleted;
        String path = this.getPackage().getPath();
        path = path.replace(';', File.separatorChar);
        File location = new File(this.getRepoManager().getLocalPath(), path);
        this.mFop.deleteFileOrFolder(location);
        this.getRepoManager().markLocalCacheInvalid();
        boolean bl = successfullyDeleted = !this.mFop.exists(location);
        if (!successfullyDeleted) {
            progress.logWarning(String.format("Failed to delete package location: %1$s", location));
        }
        return successfullyDeleted;
    }
}

