/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.installer;

import com.android.repository.api.Downloader;
import com.android.repository.api.Installer;
import com.android.repository.api.PackageOperation;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.installer.AbstractPackageOperation;
import com.android.repository.io.FileOp;
import com.android.repository.util.InstallerUtil;
import java.io.File;
import java.io.IOException;

public abstract class AbstractInstaller
extends AbstractPackageOperation
implements Installer {
    private final RemotePackage mPackage;
    private final Downloader mDownloader;

    public AbstractInstaller(RemotePackage p, RepoManager manager, Downloader downloader, FileOp fop) {
        super(manager, fop);
        this.mPackage = p;
        this.mDownloader = downloader;
        this.registerStateChangeListener((op, progress) -> {
            if (this.getInstallStatus() == PackageOperation.InstallStatus.COMPLETE) {
                try {
                    InstallerUtil.writePackageXml(this.getPackage(), this.getLocation(progress), this.getRepoManager(), this.mFop, progress);
                }
                catch (IOException e) {
                    progress.logWarning("Failed to update package.xml", e);
                    throw new PackageOperation.StatusChangeListenerException(e);
                }
            }
        });
    }

    @Override
    public RemotePackage getPackage() {
        return this.mPackage;
    }

    @Override
    public final File getLocation(ProgressIndicator progress) {
        return this.mPackage.getInstallDir(this.getRepoManager(), progress);
    }

    protected Downloader getDownloader() {
        return this.mDownloader;
    }

    @Override
    public String getName() {
        return "Install " + this.getPackage().getDisplayName();
    }
}

