/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.repository.AgpVersion;
import com.android.ide.common.repository.NetworkCache;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.util.PathString;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintFixPerformer;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.LintJavaUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.UImplicitCallExpression;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.BuildScriptUtil;
import com.android.utils.CharSequences;
import com.android.utils.DomExtensions;
import com.android.utils.PositionXmlParser;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteStreams;
import com.intellij.ide.util.JavaAnonymousClassesHelper;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForFacade;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.uast.UArrayAccessExpression;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UExpressionList;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.UastUtils;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u00b4\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0006\u0010\u0003\u001a\u00020\u0004\u001a)\u0010\u0005\u001a\u0004\u0018\u0001H\u0006\"\u0004\b\u0000\u0010\u00062\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00060\b\"\u0002H\u0006H\u0007\u00a2\u0006\u0002\u0010\t\u001a$\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\"\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00012\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u001a&\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004\u001a \u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u00012\b\b\u0002\u0010 \u001a\u00020\u0019\u001a\u0016\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00012\u0006\u0010#\u001a\u00020\u0001\u001a$\u0010$\u001a\u0004\u0018\u00010\u00012\u0006\u0010\"\u001a\u00020\u00012\b\u0010\u0013\u001a\u0004\u0018\u00010\u00012\b\u0010#\u001a\u0004\u0018\u00010\u0001\u001a\u001e\u0010%\u001a\u00020\u00012\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00010'2\b\b\u0002\u0010(\u001a\u00020\u0019\u001a2\u0010%\u001a\u00020\u00012\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00010'2\b\b\u0002\u0010(\u001a\u00020\u00192\b\b\u0002\u0010)\u001a\u00020\u00042\b\b\u0002\u0010*\u001a\u00020\u0004\u001a\u0010\u0010+\u001a\u0004\u0018\u00010\u00012\u0006\u0010,\u001a\u00020\u0001\u001a\u000e\u0010-\u001a\u00020\u00012\u0006\u0010.\u001a\u00020\u0001\u001a\u000e\u0010/\u001a\u00020\u00192\u0006\u00100\u001a\u000201\u001a\u0014\u00102\u001a\b\u0012\u0004\u0012\u0002030'2\u0006\u00100\u001a\u000201\u001a\u0018\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u0002052\u0006\u00107\u001a\u000205\u001a\u0016\u00104\u001a\u0004\u0018\u0001052\f\u00108\u001a\b\u0012\u0004\u0012\u0002050'\u001a\u001e\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u0002052\u0006\u0010>\u001a\u00020\u0004\u001a\u0018\u00109\u001a\u00020:2\b\u0010?\u001a\u0004\u0018\u00010@2\u0006\u0010>\u001a\u00020\u0004\u001a\u0016\u0010A\u001a\u00020\u00012\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020B\u001a\u0018\u0010A\u001a\u00020\u00012\b\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010=\u001a\u000205\u001a\u000e\u0010C\u001a\u00020\u00012\u0006\u0010=\u001a\u000205\u001a\u001c\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00010'2\u0006\u0010E\u001a\u00020\u00012\u0006\u0010F\u001a\u00020\u0001\u001a&\u0010G\u001a\n\u0012\u0004\u0012\u00020H\u0018\u00010'2\u0006\u0010I\u001a\u00020J2\u0006\u0010;\u001a\u00020<2\u0006\u0010K\u001a\u00020\u0001\u001a\u000e\u0010L\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0010\u0010M\u001a\u0004\u0018\u00010\u00012\u0006\u0010N\u001a\u00020O\u001a\u0016\u0010P\u001a\u00020Q2\u0006\u0010I\u001a\u00020J2\u0006\u0010R\u001a\u00020Q\u001a\u0016\u0010P\u001a\u00020Q2\u0006\u0010S\u001a\u00020T2\u0006\u0010R\u001a\u00020Q\u001a\u0016\u0010P\u001a\u00020Q2\u0006\u0010S\u001a\u00020U2\u0006\u0010R\u001a\u00020Q\u001a\u0010\u0010V\u001a\u0004\u0018\u00010W2\u0006\u0010X\u001a\u00020Y\u001a\u0010\u0010V\u001a\u0004\u0018\u00010W2\u0006\u0010Z\u001a\u00020\u0001\u001a\u0010\u0010[\u001a\u0004\u0018\u00010\u00012\u0006\u0010\\\u001a\u00020\u0001\u001a\u0010\u0010]\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0010\u0010^\u001a\u0004\u0018\u00010_2\u0006\u00100\u001a\u00020_\u001a\u000e\u0010`\u001a\u00020\u00192\u0006\u00100\u001a\u00020_\u001a\u0010\u0010a\u001a\u0004\u0018\u00010_2\u0006\u00100\u001a\u00020_\u001a\u000e\u0010b\u001a\u00020\u00192\u0006\u00100\u001a\u00020_\u001a\u0010\u0010c\u001a\u0004\u0018\u00010\u00012\u0006\u0010d\u001a\u00020\u0001\u001a@\u0010e\u001a\n\u0012\u0004\u0012\u00020f\u0018\u00010'2\u0006\u0010I\u001a\u00020J2\u0006\u0010;\u001a\u00020<2\u0006\u0010K\u001a\u00020\u00012\u0006\u0010g\u001a\u00020\u00012\u0006\u0010h\u001a\u00020\u00012\b\b\u0002\u0010i\u001a\u00020\u0004\u001a \u0010j\u001a\u00020k2\u0006\u0010;\u001a\u00020<2\u0006\u0010l\u001a\u0002052\b\u0010\"\u001a\u0004\u0018\u00010\u0001\u001a\u000e\u0010j\u001a\u00020k2\u0006\u0010I\u001a\u00020J\u001a \u0010m\u001a\u00020k2\u0006\u0010;\u001a\u00020<2\u0006\u0010n\u001a\u0002052\b\u0010\"\u001a\u0004\u0018\u00010\u0001\u001a\u0010\u0010o\u001a\u00020\u00042\b\u0010N\u001a\u0004\u0018\u00010O\u001a\u0010\u0010o\u001a\u00020\u00042\b\u0010p\u001a\u0004\u0018\u00010q\u001a\u001a\u0010r\u001a\u00020\u00042\b\u0010s\u001a\u0004\u0018\u00010\u00012\b\u0010t\u001a\u0004\u0018\u00010\u0001\u001a\u000e\u0010u\u001a\u00020\u00042\u0006\u0010v\u001a\u00020w\u001a\u000e\u0010x\u001a\u00020\u00042\u0006\u0010y\u001a\u00020\u0001\u001a\u001e\u0010z\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u00012\u0006\u0010 \u001a\u00020\u0019\u001a\u0016\u0010{\u001a\u00020\u00042\u0006\u0010X\u001a\u00020Y2\u0006\u0010|\u001a\u00020\u0004\u001a\u0010\u0010}\u001a\u00020\u00042\b\u0010S\u001a\u0004\u0018\u00010T\u001a\u000f\u0010~\u001a\u00020\u00042\u0007\u0010\u007f\u001a\u00030\u0080\u0001\u001a\u001b\u0010\u0081\u0001\u001a\u00020\u00042\b\u0010\u0082\u0001\u001a\u00030\u0083\u00012\b\u0010\u0084\u0001\u001a\u00030\u0085\u0001\u001a\u0011\u0010\u0086\u0001\u001a\u00020\u00042\b\u0010\u0087\u0001\u001a\u00030\u0088\u0001\u001a\u0013\u0010\u0086\u0001\u001a\u00020\u00042\b\u0010S\u001a\u0004\u0018\u00010TH\u0007\u001a\u0010\u0010\u0089\u0001\u001a\u00020\u00042\u0007\u0010\u008a\u0001\u001a\u00020\u0001\u001a\u0010\u0010\u008b\u0001\u001a\u00020\u00042\u0007\u0010\u008c\u0001\u001a\u000205\u001a\u0010\u0010\u008d\u0001\u001a\u00020\u00042\u0007\u0010\u008c\u0001\u001a\u000205\u001a\u0011\u0010\u008e\u0001\u001a\u00020\u00042\b\u0010\u0087\u0001\u001a\u00030\u0088\u0001\u001a\u0013\u0010\u008e\u0001\u001a\u00020\u00042\b\u0010S\u001a\u0004\u0018\u00010TH\u0007\u001a\u0010\u0010\u008f\u0001\u001a\u00020\u00042\u0007\u0010\u008a\u0001\u001a\u00020\u0001\u001a\u0010\u0010\u0090\u0001\u001a\u00020\u00042\u0007\u0010\u0091\u0001\u001a\u00020\u0001\u001a\u000f\u0010\u0090\u0001\u001a\u00020\u00042\u0006\u0010S\u001a\u000203\u001a\u0012\u0010\u0092\u0001\u001a\u00020\u00042\t\u0010\u0093\u0001\u001a\u0004\u0018\u000105\u001a\u000f\u0010\u0094\u0001\u001a\u00020\u00042\u0006\u0010y\u001a\u00020\u0001\u001a5\u0010\u0095\u0001\u001a\u00020\u00042\u0006\u0010I\u001a\u00020J2\u0007\u0010\u0096\u0001\u001a\u00020\u00192\u0007\u0010\u0097\u0001\u001a\u00020\u00192\u0007\u0010\u0098\u0001\u001a\u00020\u00192\t\b\u0002\u0010\u0099\u0001\u001a\u00020\u0004\u001a\u0011\u0010\u009a\u0001\u001a\u00020\u00042\b\u0010S\u001a\u0004\u0018\u00010T\u001a\u0011\u0010\u009b\u0001\u001a\u00020\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001\u001a%\u0010\u009c\u0001\u001a\u00020\u00042\t\u0010\u009d\u0001\u001a\u0004\u0018\u0001052\u0006\u0010=\u001a\u0002052\t\b\u0002\u0010\u009e\u0001\u001a\u00020\u0004\u001a\"\u0010\u009f\u0001\u001a\u00020\u00042\b\u0010S\u001a\u0004\u0018\u00010U\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\u0010\u0001(\u0000\u001a\u000f\u0010\u00a1\u0001\u001a\u00020\u00042\u0006\u0010S\u001a\u000203\u001a\u001b\u0010\u00a2\u0001\u001a\u00020\u00042\b\u00106\u001a\u0004\u0018\u0001052\b\u00107\u001a\u0004\u0018\u000105\u001a\u000f\u0010\u00a3\u0001\u001a\u00020\u00042\u0006\u0010v\u001a\u00020w\u001a\u0010\u0010\u00a4\u0001\u001a\u00020\u00042\u0007\u0010\u007f\u001a\u00030\u00a5\u0001\u001a\u0011\u0010\u00a6\u0001\u001a\u00020\u00042\b\u0010S\u001a\u0004\u0018\u00010T\u001a\u000f\u0010\u00a7\u0001\u001a\u00020\u00042\u0006\u0010=\u001a\u000205\u001a\u001b\u0010\u00a8\u0001\u001a\u0004\u0018\u0001032\u0006\u0010S\u001a\u0002032\b\u0010\u00a9\u0001\u001a\u00030\u00aa\u0001\u001a\u0013\u0010\u00ab\u0001\u001a\u0004\u0018\u00010T2\b\u0010S\u001a\u0004\u0018\u00010T\u001a\u001b\u0010\u00ac\u0001\u001a\u00020\u00012\u0007\u0010\u00ad\u0001\u001a\u00020\u00192\u0007\u0010\u00ae\u0001\u001a\u00020\u0001H\u0002\u001a\u0013\u0010\u00af\u0001\u001a\u0004\u0018\u00010T2\b\u0010S\u001a\u0004\u0018\u00010T\u001a#\u0010\u00b0\u0001\u001a\u0004\u0018\u00010@2\u0006\u0010;\u001a\u00020<2\u0007\u0010\u00b1\u0001\u001a\u00020\u00012\u0007\u0010\u00b2\u0001\u001a\u00020\u0019\u001a,\u0010\u00b0\u0001\u001a\u00030\u00b3\u00012\u0006\u0010;\u001a\u00020<2\u0007\u0010\u00b1\u0001\u001a\u00020\u00012\u0007\u0010\u00b2\u0001\u001a\u00020\u00192\b\u0010\u00b4\u0001\u001a\u00030\u00b5\u0001\u001a#\u0010\u00b6\u0001\u001a\u0004\u0018\u00010\u00012\u0006\u0010;\u001a\u00020<2\u0007\u0010\u00b1\u0001\u001a\u00020\u00012\u0007\u0010\u00b2\u0001\u001a\u00020\u0019\u001a\u0011\u0010\u00b7\u0001\u001a\u00020\u00012\u0006\u0010S\u001a\u000203H\u0007\u001a\u0019\u0010\u00b7\u0001\u001a\u00020\u00012\u0006\u0010S\u001a\u0002032\b\u0010I\u001a\u0004\u0018\u00010J\u001a\u001b\u0010\u00b8\u0001\u001a\u0004\u0018\u00010\u00012\b\u0010I\u001a\u0004\u0018\u00010J2\u0006\u0010\u0014\u001a\u00020\u0001\u001a3\u0010\u00b9\u0001\u001a\u00020\u00012\b\u0010I\u001a\u0004\u0018\u00010J2\u0007\u0010\u00ba\u0001\u001a\u00020\u00012\u0015\u0010\u00bb\u0001\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u000bH\u0007\u001aD\u0010\u00b9\u0001\u001a\u0004\u0018\u00010\u00012\b\u0010I\u001a\u0004\u0018\u00010J2\u0007\u0010\u00ba\u0001\u001a\u00020\u00012\u0017\b\u0002\u0010\u00bb\u0001\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u000b2\u000b\b\u0002\u0010\u00bc\u0001\u001a\u0004\u0018\u00010\u0001H\u0007\u001a+\u0010\u00bd\u0001\u001a\u0004\u0018\u0001032\r\u0010\u00be\u0001\u001a\b\u0012\u0004\u0012\u0002030'2\u0007\u0010\u00bf\u0001\u001a\u00020\u00192\u0006\u0010Z\u001a\u000203H\u0002\u001a\u0015\u0010\u00c0\u0001\u001a\u0004\u0018\u00010T2\b\u0010S\u001a\u0004\u0018\u00010TH\u0007\u001a\u0015\u0010\u00c0\u0001\u001a\u0004\u0018\u00010U2\b\u0010S\u001a\u0004\u0018\u00010UH\u0007\u001a\u0017\u0010\u00c1\u0001\u001a\t\u0012\u0004\u0012\u00020\u00010\u00c2\u00012\u0007\u0010\u00be\u0001\u001a\u00020\u0001\u001a \u0010\u00c3\u0001\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00012\u0007\u0010\u00c4\u0001\u001a\u00020\u0019\u001a\u0014\u0010\u00c5\u0001\u001a\u00020\u00012\t\u0010\u00c6\u0001\u001a\u0004\u0018\u00010\u0001H\u0007\u001a\u000e\u0010\u00c7\u0001\u001a\u0005\u0018\u00010\u00c8\u0001*\u00020\u0011\u001a\u0019\u0010\u00c9\u0001\u001a\u0004\u0018\u00010\u0011*\u00030\u00ca\u00012\t\b\u0002\u0010\u00cb\u0001\u001a\u00020\u0004\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00f2\u0001\u0005\n\u00030\u00a0\u0001\u00a8\u0006\u00cc\u0001"}, d2={"UTF_16", "", "UTF_16LE", "assertionsEnabled", "", "coalesce", "T", "ts", "", "([Ljava/lang/Object;)Ljava/lang/Object;", "computeKotlinArgumentMapping", "", "Lorg/jetbrains/uast/UExpression;", "Lcom/intellij/psi/PsiParameter;", "call", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "computeResourceName", "prefix", "name", "folderType", "Lcom/android/resources/ResourceFolderType;", "describeCounts", "errorCount", "", "warningCount", "comma", "capitalize", "editDistance", "s", "t", "max", "endsWith", "string", "suffix", "findSubstring", "formatList", "strings", "", "maxItems", "sort", "useConjunction", "getAutoBoxedType", "primitive", "getBaseName", "fileName", "getChildCount", "node", "Lorg/w3c/dom/Node;", "getChildren", "Lorg/w3c/dom/Element;", "getCommonParent", "Ljava/io/File;", "file1", "file2", "files", "getEncodedString", "", "client", "Lcom/android/tools/lint/client/api/LintClient;", "file", "createString", "data", "", "getFileNameWithParent", "Lcom/android/ide/common/util/PathString;", "getFileUri", "getFormattedParameters", "format", "errorMessage", "getInheritedStyles", "Lcom/android/ide/common/rendering/api/StyleResourceValue;", "project", "Lcom/android/tools/lint/detector/api/Project;", "styleUrl", "getInternalMethodName", "getInternalName", "psiClass", "Lcom/intellij/psi/PsiClass;", "getLanguageLevel", "Lcom/intellij/pom/java/LanguageLevel;", "defaultLevel", "element", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/uast/UElement;", "getLocale", "Lcom/android/ide/common/resources/configuration/LocaleQualifier;", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "parent", "getLocaleAndRegion", "folderName", "getMethodName", "getNextInstruction", "Lorg/objectweb/asm/tree/AbstractInsnNode;", "getNextOpcode", "getPrevInstruction", "getPrevOpcode", "getPrimitiveType", "autoBoxedType", "getStyleAttributes", "Lcom/android/ide/common/rendering/api/ResourceValue;", "namespaceUri", "attribute", "acceptMissing", "guessGradleLocation", "Lcom/android/tools/lint/detector/api/Location;", "projectDir", "guessGradleLocationForFile", "gradle", "hasImplicitDefaultConstructor", "uClass", "Lorg/jetbrains/uast/UClass;", "idReferencesMatch", "id1", "id2", "isAnonymousClass", "classNode", "Lorg/objectweb/asm/tree/ClassNode;", "isDataBindingExpression", "expression", "isEditableTo", "isEnglishResource", "assumeForBase", "isFalseLiteral", "isFileBasedResourceType", "type", "Lcom/android/resources/ResourceType;", "isInlined", "field", "Lcom/intellij/psi/PsiField;", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "isJava", "language", "Lcom/intellij/lang/Language;", "isJavaKeyword", "keyword", "isJdkFolder", "homePath", "isJreFolder", "isKotlin", "isKotlinHardKeyword", "isLayoutMarkerTag", "tagName", "isManifestFolder", "dir", "isManifestPlaceHolderExpression", "isModelOlderThan", "major", "minor", "micro", "defaultForNonGradleProjects", "isNullLiteral", "isNumberString", "isParent", "parentCandidate", "strict", "isPolyadicFromStringTemplate", "Lorg/jetbrains/uast/UPolyadicExpression;", "isRootElement", "isSameResourceFile", "isStaticInnerClass", "isString", "Lcom/intellij/psi/PsiType;", "isTrueLiteral", "isXmlFile", "matchXmlElement", "targetDocument", "Lorg/w3c/dom/Document;", "nextNonWhitespace", "pluralize", "count", "one", "prevNonWhitespace", "readUrlData", "query", "timeout", "Lcom/android/ide/common/repository/NetworkCache$ReadUrlDataResult;", "lastModified", "", "readUrlDataAsString", "resolveManifestName", "resolvePlaceHolder", "resolvePlaceHolders", "value", "substitutions", "defaultValue", "search", "path", "index", "skipParentheses", "splitPath", "", "startsWith", "offset", "stripIdPrefix", "id", "getUMethod", "Lorg/jetbrains/uast/UMethod;", "resolveOperator", "Lorg/jetbrains/uast/UArrayAccessExpression;", "skipOverloadedSetter", "lint-api"})
@JvmName(name="Lint")
@SourceDebugExtension(value={"SMAP\nLintUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintUtils.kt\ncom/android/tools/lint/detector/api/Lint\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,2966:1\n1#2:2967\n13374#3,2:2968\n13376#3:2972\n1855#4,2:2970\n2624#4,3:2973\n*S KotlinDebug\n*F\n+ 1 LintUtils.kt\ncom/android/tools/lint/detector/api/Lint\n*L\n2082#1:2968,2\n2082#1:2972\n2085#1:2970,2\n2215#1:2973,3\n*E\n"})
public final class Lint {
    @NotNull
    private static final String UTF_16 = "UTF_16";
    @NotNull
    private static final String UTF_16LE = "UTF_16LE";

    @Nullable
    public static final String getInternalName(@NotNull PsiClass psiClass) {
        PsiClass parent;
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        if (psiClass instanceof PsiAnonymousClass && (parent = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)psiClass), PsiClass.class)) != null) {
            String string = Lint.getInternalName(parent);
            if (string == null) {
                return null;
            }
            String internalName = string;
            String string2 = JavaAnonymousClassesHelper.getName((PsiAnonymousClass)((PsiAnonymousClass)psiClass));
            Intrinsics.checkNotNull((Object)string2);
            return internalName + string2;
        }
        String sig = ClassUtil.getJVMClassName((PsiClass)psiClass);
        if (sig == null) {
            String qualifiedName = psiClass.getQualifiedName();
            return qualifiedName != null ? ClassContext.Companion.getInternalName(qualifiedName) : null;
        }
        if (StringsKt.indexOf$default((CharSequence)sig, (char)'.', (int)0, (boolean)false, (int)6, null) != -1) {
            sig = ClassContext.Companion.getInternalName(sig);
        }
        return sig;
    }

    @NotNull
    public static final String getInternalMethodName(@NotNull PsiMethod method) {
        String string;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (method.isConstructor()) {
            string = "<init>";
        } else {
            String string2 = method.getName();
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        }
        return string;
    }

    @NotNull
    public static final String formatList(@NotNull List<String> strings, int maxItems) {
        Intrinsics.checkNotNullParameter(strings, (String)"strings");
        return Lint.formatList$default(strings, maxItems, true, false, 8, null);
    }

    public static /* synthetic */ String formatList$default(List list, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        return Lint.formatList(list, n);
    }

    @NotNull
    public static final String formatList(@NotNull List<String> strings, int maxItems, boolean sort, boolean useConjunction) {
        Intrinsics.checkNotNullParameter(strings, (String)"strings");
        List sortedStrings = strings;
        if (sort) {
            ArrayList sorted = new ArrayList(sortedStrings);
            CollectionsKt.sort((List)sorted);
            sortedStrings = sorted;
        }
        StringBuilder sb = new StringBuilder(20 * sortedStrings.size());
        int n = sortedStrings.size();
        for (int i = 0; i < n; ++i) {
            if (((CharSequence)sb).length() > 0) {
                if (useConjunction && i == n - 1) {
                    sb.append(" and ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append((String)sortedStrings.get(i));
            if (maxItems <= 0 || i != maxItems - 1 || n <= maxItems) continue;
            sb.append("... (" + (n - i - 1) + " more)");
            break;
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String formatList$default(List list, int n, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n2 & 4) != 0) {
            bl = true;
        }
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        return Lint.formatList(list, n, bl, bl2);
    }

    public static final boolean isFileBasedResourceType(@NotNull ResourceType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        List folderTypes = FolderTypeRelationship.getRelatedFolders((ResourceType)type);
        for (ResourceFolderType folderType : folderTypes) {
            if (folderType == ResourceFolderType.VALUES) continue;
            return type != ResourceType.ID;
        }
        return false;
    }

    public static final boolean isXmlFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return SdkUtils.endsWithIgnoreCase((String)file.getPath(), (String)".xml");
    }

    public static final boolean endsWith(@NotNull String string, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        return StringsKt.regionMatches((String)string, (int)(string.length() - suffix.length()), (String)suffix, (int)0, (int)suffix.length(), (boolean)true);
    }

    public static final boolean startsWith(@NotNull String string, @NotNull String prefix, int offset) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        return StringsKt.regionMatches((String)string, (int)offset, (String)prefix, (int)0, (int)prefix.length(), (boolean)true);
    }

    @NotNull
    public static final String getBaseName(@NotNull String fileName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        int extension = StringsKt.indexOf$default((CharSequence)fileName, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (extension > 0) {
            String string2 = fileName.substring(0, extension);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = fileName;
        }
        return string;
    }

    @NotNull
    public static final String describeCounts(int errorCount, int warningCount, boolean comma, boolean capitalize) {
        String string;
        if (errorCount == 0 && warningCount == 0) {
            return capitalize ? "No errors or warnings" : "no errors or warnings";
        }
        String errors = Lint.pluralize(errorCount, "error");
        String warnings = Lint.pluralize(warningCount, "warning");
        if (errorCount == 0) {
            string = warningCount + " " + warnings;
        } else if (warningCount == 0) {
            string = errorCount + " " + errors;
        } else {
            String conjunction = comma ? "," : " and";
            string = errorCount + " " + errors + conjunction + " " + warningCount + " " + warnings;
        }
        return string;
    }

    private static final String pluralize(int count, String one) {
        return count == 1 ? one : one + "s";
    }

    @NotNull
    public static final List<Element> getChildren(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        NodeList childNodes = node.getChildNodes();
        ArrayList<Element> children = new ArrayList<Element>(childNodes.getLength());
        int n = childNodes.getLength();
        for (int i = 0; i < n; ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() != 1) continue;
            Intrinsics.checkNotNull((Object)child, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
            children.add((Element)child);
        }
        return children;
    }

    public static final int getChildCount(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return XmlUtils.getSubTagCount((Node)node);
    }

    public static final boolean isRootElement(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element == element.getOwnerDocument().getDocumentElement();
    }

    @Deprecated(message="Use ResourceUrl for parsing @id and similar strings.", replaceWith=@ReplaceWith(expression="ResourceUrl.parse(id)?.name", imports={"com.android.resources.ResourceUrl"}))
    @NotNull
    public static final String stripIdPrefix(@Nullable String id) {
        String string;
        if (id == null) {
            string = "";
        } else if (StringsKt.startsWith$default((String)id, (String)"@+id/", (boolean)false, (int)2, null)) {
            String string2 = id.substring(5);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else if (StringsKt.startsWith$default((String)id, (String)"@id/", (boolean)false, (int)2, null)) {
            String string3 = id.substring(4);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        } else {
            string = id;
        }
        return string;
    }

    public static final boolean idReferencesMatch(@Nullable String id1, @Nullable String id2) {
        boolean bl;
        if (id1 == null || id2 == null || ((CharSequence)id1).length() == 0 || ((CharSequence)id2).length() == 0) {
            return false;
        }
        if (StringsKt.startsWith$default((String)id1, (String)"@+id/", (boolean)false, (int)2, null)) {
            boolean bl2;
            if (StringsKt.startsWith$default((String)id2, (String)"@+id/", (boolean)false, (int)2, null)) {
                bl2 = Intrinsics.areEqual((Object)id1, (Object)id2);
            } else {
                boolean bl3 = StringsKt.startsWith$default((String)id2, (String)"@id/", (boolean)false, (int)2, null);
                if (_Assertions.ENABLED && !bl3) {
                    boolean $i$a$-assert-Lint$idReferencesMatch$32 = false;
                    String $i$a$-assert-Lint$idReferencesMatch$32 = id2;
                    throw new AssertionError((Object)$i$a$-assert-Lint$idReferencesMatch$32);
                }
                bl2 = id1.length() - id2.length() == 1 && StringsKt.regionMatches$default((String)id1, (int)5, (String)id2, (int)4, (int)(id2.length() - 4), (boolean)false, (int)16, null);
            }
            return bl2;
        }
        boolean bl4 = StringsKt.startsWith$default((String)id1, (String)"@id/", (boolean)false, (int)2, null);
        if (_Assertions.ENABLED && !bl4) {
            boolean bl5 = false;
            String string = id1;
            throw new AssertionError((Object)string);
        }
        if (StringsKt.startsWith$default((String)id2, (String)"@id/", (boolean)false, (int)2, null)) {
            bl = Intrinsics.areEqual((Object)id1, (Object)id2);
        } else {
            bl4 = StringsKt.startsWith$default((String)id2, (String)"@+id/", (boolean)false, (int)2, null);
            if (_Assertions.ENABLED && !bl4) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            bl = id2.length() - id1.length() == 1 && StringsKt.regionMatches$default((String)id2, (int)5, (String)id1, (int)4, (int)(id1.length() - 4), (boolean)false, (int)16, null);
        }
        return bl;
    }

    @NotNull
    public static final String getFileNameWithParent(@Nullable LintClient client, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file.getParentFile().getName() + "/" + file.getName();
    }

    @NotNull
    public static final String getFileNameWithParent(@NotNull LintClient client, @NotNull PathString file) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PathString pathString = file.getParent();
        if (pathString == null) {
            throw new IllegalArgumentException();
        }
        PathString parent = pathString;
        return LintClient.getDisplayPath$default(client, new File(parent.getFileName(), file.getFileName()), null, null, 6, null);
    }

    public static final boolean isEditableTo(@NotNull String s, @NotNull String t, int max) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return Lint.editDistance(s, t, max) <= max;
    }

    public static final int editDistance(@NotNull String s, @NotNull String t, int max) {
        int j;
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        if (Intrinsics.areEqual((Object)s, (Object)t)) {
            return 0;
        }
        if (Math.abs(s.length() - t.length()) > max) {
            return Integer.MAX_VALUE;
        }
        int m = s.length();
        int n = t.length();
        int n2 = 0;
        int n3 = m + 1;
        int[][] nArrayArray = new int[n3][];
        while (n2 < n3) {
            int n4 = n2++;
            nArrayArray[n4] = new int[n + 1];
        }
        int[][] d = nArrayArray;
        int i = 0;
        if (i <= m) {
            while (true) {
                d[i][0] = i;
                if (i == m) break;
                ++i;
            }
        }
        if ((j = 0) <= n) {
            while (true) {
                d[0][j] = j;
                if (j == n) break;
                ++j;
            }
        }
        if ((j = 1) <= n) {
            while (true) {
                int i2;
                if ((i2 = 1) <= m) {
                    while (true) {
                        if (s.charAt(i2 - 1) == t.charAt(j - 1)) {
                            d[i2][j] = d[i2 - 1][j - 1];
                        } else {
                            int deletion = d[i2 - 1][j] + 1;
                            int insertion = d[i2][j - 1] + 1;
                            int substitution = d[i2 - 1][j - 1] + 1;
                            d[i2][j] = Math.min(deletion, Math.min(insertion, substitution));
                        }
                        if (i2 == m) break;
                        ++i2;
                    }
                }
                if (j == n) break;
                ++j;
            }
        }
        return d[m][n];
    }

    public static /* synthetic */ int editDistance$default(String string, String string2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = Integer.MAX_VALUE;
        }
        return Lint.editDistance(string, string2, n);
    }

    public static final boolean assertionsEnabled() {
        return LintJavaUtils.assertionsEnabled();
    }

    @Nullable
    public static final PsiMethod resolveOperator(@NotNull UArrayAccessExpression $this$resolveOperator, boolean skipOverloadedSetter) {
        UExpression receiver;
        Intrinsics.checkNotNullParameter((Object)$this$resolveOperator, (String)"<this>");
        if (skipOverloadedSetter && $this$resolveOperator.getUastParent() instanceof UBinaryExpression) {
            UElement uElement = $this$resolveOperator.getUastParent();
            Intrinsics.checkNotNull((Object)uElement, (String)"null cannot be cast to non-null type org.jetbrains.uast.UBinaryExpression");
            UBinaryExpression uastParentCapture = (UBinaryExpression)uElement;
            if (Intrinsics.areEqual((Object)uastParentCapture.getLeftOperand(), (Object)$this$resolveOperator) && Intrinsics.areEqual((Object)uastParentCapture.getOperator(), (Object)UastBinaryOperator.ASSIGN)) {
                return null;
            }
        }
        if (!((receiver = $this$resolveOperator.getReceiver()).getExpressionType() instanceof PsiClassType)) {
            return null;
        }
        PsiElement psiElement = $this$resolveOperator.resolve();
        return psiElement instanceof PsiMethod ? (PsiMethod)psiElement : null;
    }

    public static /* synthetic */ PsiMethod resolveOperator$default(UArrayAccessExpression uArrayAccessExpression, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return Lint.resolveOperator(uArrayAccessExpression, bl);
    }

    @NotNull
    public static final Iterable<String> splitPath(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        if (StringsKt.indexOf$default((CharSequence)path2, (char)';', (int)0, (boolean)false, (int)6, null) != -1) {
            Iterable iterable = Splitter.on((char)';').omitEmptyStrings().trimResults().split((CharSequence)path2);
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"split(...)");
            return iterable;
        }
        ArrayList<CallSite> combined = new ArrayList<CallSite>();
        Iterables.addAll((Collection)combined, (Iterable)Splitter.on((char)':').omitEmptyStrings().trimResults().split((CharSequence)path2));
        int n = combined.size();
        for (int i = 0; i < n; ++i) {
            Object e = combined.get(i);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            String p = (String)e;
            if (p.length() != 1 || i >= n - 1 || !Character.isLetter(p.charAt(0))) continue;
            Object e2 = combined.get(i + 1);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"get(...)");
            if (((CharSequence)e2).length() == 0 || ((String)combined.get(i + 1)).charAt(0) != '\\') continue;
            combined.set(i, (CallSite)((Object)(p + ":" + combined.get(i + 1))));
            combined.remove(i + 1);
            --n;
        }
        return combined;
    }

    @Nullable
    public static final File getCommonParent(@NotNull List<? extends File> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        int fileCount = files.size();
        switch (fileCount) {
            case 0: {
                return null;
            }
            case 1: {
                return files.get(0);
            }
            case 2: {
                return Lint.getCommonParent(files.get(0), files.get(1));
            }
        }
        File common = files.get(0);
        for (int i = 1; i < fileCount; ++i) {
            File file = common;
            Intrinsics.checkNotNull((Object)file);
            common = Lint.getCommonParent(file, files.get(i));
            if (common != null) continue;
            return null;
        }
        return common;
    }

    @Nullable
    public static final File getCommonParent(@NotNull File file1, @NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file1, (String)"file1");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file2");
        if (Intrinsics.areEqual((Object)file1, (Object)file2)) {
            return file1;
        }
        String string = file1.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String string2 = file2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        if (StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null)) {
            return file2;
        }
        String string3 = file2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
        String string4 = file1.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPath(...)");
        if (StringsKt.startsWith$default((String)string3, (String)string4, (boolean)false, (int)2, null)) {
            return file1;
        }
        for (File first = file1.getParentFile(); first != null; first = first.getParentFile()) {
            for (File second = file2.getParentFile(); second != null; second = second.getParentFile()) {
                if (!Intrinsics.areEqual((Object)first, (Object)second)) continue;
                return first;
            }
        }
        return null;
    }

    public static final boolean isParent(@Nullable File parentCandidate, @NotNull File file, boolean strict) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (parentCandidate == null) {
            return false;
        }
        String path2 = file.getPath();
        String parentPath = parentCandidate.getPath();
        int parentLength = parentPath.length();
        int pathLength = path2.length();
        if (pathLength <= parentLength) {
            if (pathLength == parentLength) {
                return strict ? false : Intrinsics.areEqual((Object)path2, (Object)parentPath);
            }
            return false;
        }
        Intrinsics.checkNotNull((Object)path2);
        Intrinsics.checkNotNull((Object)parentPath);
        if (!StringsKt.startsWith$default((String)path2, (String)parentPath, (boolean)false, (int)2, null)) {
            return false;
        }
        return path2.charAt(parentLength) == '/' || path2.charAt(parentLength) == '\\';
    }

    public static /* synthetic */ boolean isParent$default(File file, File file2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return Lint.isParent(file, file2, bl);
    }

    @NotNull
    public static final String getFileUri(@NotNull File file) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String it = file.toURI().toURL().toString();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        if (StringsKt.startsWith$default((String)it, (String)"file:", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)it, (String)"file://", (boolean)false, (int)2, null)) {
            String string = it.substring(5);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            object = "file://" + string;
        } else {
            object = it;
        }
        return object;
    }

    @NotNull
    public static final CharSequence getEncodedString(@NotNull LintClient client, @NotNull File file, boolean createString) throws IOException {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        byte[] bytes = client.readBytes(file);
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (Lint.endsWith(string, ".xml")) {
            String string2 = PositionXmlParser.getXmlString((byte[])bytes);
            Intrinsics.checkNotNull((Object)string2);
            charSequence = string2;
        } else {
            charSequence = Lint.getEncodedString(bytes, createString);
        }
        return charSequence;
    }

    public static final boolean isDataBindingExpression(@NotNull String expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return StringsKt.startsWith$default((String)expression, (String)"@{", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)expression, (String)"@={", (boolean)false, (int)2, null);
    }

    public static final boolean isManifestPlaceHolderExpression(@NotNull String expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return StringsKt.contains$default((CharSequence)expression, (CharSequence)"${", (boolean)false, (int)2, null);
    }

    @NotNull
    public static final CharSequence getEncodedString(@Nullable byte[] data, boolean createString) {
        if (data == null) {
            return "";
        }
        int offset = 0;
        String defaultCharset = "UTF-8";
        String charset = null;
        if (data.length > 4) {
            if (data[0] == -17 && data[1] == -69 && data[2] == -65) {
                defaultCharset = charset = "UTF-8";
                offset += 3;
            } else if (data[0] == -2 && data[1] == -1) {
                defaultCharset = charset = UTF_16;
                offset += 2;
            } else if (data[0] == 0 && data[1] == 0 && data[2] == -2 && data[3] == -1) {
                defaultCharset = charset = "UTF_32";
                offset += 4;
            } else if (data[0] == -1 && data[1] == -2 && data[2] == 0 && data[3] == 0) {
                defaultCharset = charset = "UTF_32LE";
                offset += 4;
            } else if (data[0] == -1 && data[1] == -2) {
                defaultCharset = charset = UTF_16LE;
                offset += 2;
            }
        }
        int length = data.length - offset;
        boolean seenOddZero = false;
        boolean seenEvenZero = false;
        int n = data.length;
        for (int lineEnd = offset; lineEnd < n; ++lineEnd) {
            if (data[lineEnd] == 0) {
                if ((lineEnd - offset) % 2 == 0) {
                    seenEvenZero = true;
                    continue;
                }
                seenOddZero = true;
                continue;
            }
            if (data[lineEnd] == 10 || data[lineEnd] == 13) break;
        }
        if (charset == null) {
            String string = seenOddZero ? UTF_16LE : (charset = seenEvenZero ? UTF_16 : "UTF-8");
        }
        if (!createString && Intrinsics.areEqual((Object)"UTF-8", (Object)charset)) {
            ByteBuffer bytes = ByteBuffer.wrap(data, offset, length);
            try {
                boolean bl;
                CharBuffer decode = Charsets.UTF_8.newDecoder().decode(bytes);
                decode.compact();
                int size = decode.position();
                boolean bl2 = bl = size <= decode.limit();
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                char[] array = decode.array();
                CharSequence charSequence = CharSequences.createSequence((char[])array, (int)0, (int)size);
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"createSequence(...)");
                return charSequence;
            }
            catch (CharacterCodingException decode) {
                // empty catch block
            }
        }
        CharSequence text = null;
        try {
            Charset charset2 = Charset.forName(charset);
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"forName(...)");
            text = new String(data, offset, length, charset2);
        }
        catch (UnsupportedEncodingException e) {
            try {
                if (!Intrinsics.areEqual((Object)charset, (Object)defaultCharset)) {
                    Charset charset3 = Charset.forName(defaultCharset);
                    Intrinsics.checkNotNullExpressionValue((Object)charset3, (String)"forName(...)");
                    text = new String(data, offset, length, charset3);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (text == null) {
            text = new String(data, offset, length, Charsets.UTF_8);
        }
        return text;
    }

    public static final boolean isStaticInnerClass(@NotNull ClassNode classNode) {
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        List fieldList = classNode.fields;
        for (FieldNode f : fieldList) {
            Intrinsics.checkNotNull((Object)f, (String)"null cannot be cast to non-null type org.objectweb.asm.tree.FieldNode");
            FieldNode field = f;
            String string = field.name;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
            if (!StringsKt.startsWith$default((String)string, (String)"this$", (boolean)false, (int)2, null) || (field.access & 0x1000) == 0) continue;
            return false;
        }
        return true;
    }

    public static final boolean isAnonymousClass(@NotNull ClassNode classNode) {
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        if (classNode.outerClass == null) {
            return false;
        }
        String name = classNode.name;
        Intrinsics.checkNotNull((Object)name);
        int index = StringsKt.lastIndexOf$default((CharSequence)name, (char)'$', (int)0, (boolean)false, (int)6, null);
        return index == -1 || index == name.length() - 1 ? false : Character.isDigit(name.charAt(index + 1));
    }

    public static final int getPrevOpcode(@NotNull AbstractInsnNode node) {
        AbstractInsnNode prev;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        AbstractInsnNode abstractInsnNode = prev = Lint.getPrevInstruction(node);
        return abstractInsnNode != null ? abstractInsnNode.getOpcode() : 0;
    }

    @Nullable
    public static final AbstractInsnNode getPrevInstruction(@NotNull AbstractInsnNode node) {
        int type;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        AbstractInsnNode prev = node;
        do {
            if ((prev = prev.getPrevious()) != null) continue;
            return null;
        } while ((type = prev.getType()) == 15 || type == 8 || type == 14);
        return prev;
    }

    public static final int getNextOpcode(@NotNull AbstractInsnNode node) {
        AbstractInsnNode next;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        AbstractInsnNode abstractInsnNode = next = Lint.getNextInstruction(node);
        return abstractInsnNode != null ? abstractInsnNode.getOpcode() : 0;
    }

    @Nullable
    public static final AbstractInsnNode getNextInstruction(@NotNull AbstractInsnNode node) {
        int type;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        AbstractInsnNode next = node;
        do {
            if ((next = next.getNext()) != null) continue;
            return null;
        } while ((type = next.getType()) == 15 || type == 8 || type == 14);
        return next;
    }

    public static final boolean isManifestFolder(@Nullable File dir) {
        File file = dir;
        if (file == null) {
            return false;
        }
        File current = file;
        boolean hasManifest = new File(current, "AndroidManifest.xml").exists();
        if (hasManifest && Intrinsics.areEqual((Object)current.getName(), (Object)"bin")) {
            File file2 = current.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getParentFile(...)");
            current = file2;
            if (Lint.isManifestFolder(current)) {
                return false;
            }
        }
        return hasManifest;
    }

    @Nullable
    public static final String getLocaleAndRegion(@NotNull String folderName) {
        Intrinsics.checkNotNullParameter((Object)folderName, (String)"folderName");
        if (StringsKt.indexOf$default((CharSequence)folderName, (char)'-', (int)0, (boolean)false, (int)6, null) == -1) {
            return null;
        }
        String locale = null;
        for (String qualifier : FolderConfiguration.QUALIFIER_SPLITTER.split((CharSequence)folderName)) {
            char second;
            char first;
            int qualifierLength = qualifier.length();
            if (qualifierLength == 2) {
                first = qualifier.charAt(0);
                second = qualifier.charAt(1);
                boolean bl = 'a' <= first ? first < '{' : false;
                if (!bl) continue;
                boolean bl2 = 'a' <= second ? second < '{' : false;
                if (!bl2) continue;
                locale = qualifier;
                continue;
            }
            if (qualifierLength == 3 && qualifier.charAt(0) == 'r' && locale != null) {
                first = qualifier.charAt(1);
                second = qualifier.charAt(2);
                boolean bl = 'A' <= first ? first < '[' : false;
                if (!bl) break;
                boolean bl3 = 'A' <= second ? second < '[' : false;
                if (!bl3) break;
                return locale + "-" + qualifier;
            }
            Intrinsics.checkNotNull((Object)qualifier);
            if (!StringsKt.startsWith$default((String)qualifier, (String)"b+", (boolean)false, (int)2, null)) continue;
            return qualifier;
        }
        return locale;
    }

    @Nullable
    public static final List<ResourceValue> getStyleAttributes(@NotNull Project project, @NotNull LintClient client, @NotNull String styleUrl, @NotNull String namespaceUri, @NotNull String attribute, boolean acceptMissing) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)styleUrl, (String)"styleUrl");
        Intrinsics.checkNotNullParameter((Object)namespaceUri, (String)"namespaceUri");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        ResourceRepository resources = client.getResources(project, ResourceRepositoryScope.ALL_DEPENDENCIES);
        ResourceUrl style = ResourceUrl.parse((String)styleUrl);
        if (style == null || style.isFramework()) {
            return null;
        }
        List result = new ArrayList();
        ArrayDeque<ResourceValueImpl> queue = new ArrayDeque<ResourceValueImpl>();
        queue.add(new ResourceValueImpl(ResourceNamespace.RES_AUTO, style.type, style.name, null));
        HashSet<String> seen = new HashSet<String>();
        for (int count = 0; count < 30 && !queue.isEmpty(); ++count) {
            ResourceValue front = (ResourceValue)queue.remove();
            String name = front.getName();
            seen.add(name);
            List items = resources.getResources(ResourceNamespace.TODO(), front.getResourceType(), name);
            if (!acceptMissing && items.isEmpty()) {
                return null;
            }
            for (ResourceItem item : items) {
                String parentName;
                ResourceUrl p;
                ResourceValue rv = item.getResourceValue();
                if (!(rv instanceof StyleResourceValue)) continue;
                StyleResourceValue srv = (StyleResourceValue)rv;
                ResourceNamespace namespace = (ResourceNamespace)MoreObjects.firstNonNull((Object)ResourceNamespace.fromNamespaceUri((String)namespaceUri), (Object)ResourceNamespace.TODO());
                String frameworkResource = !StringsKt.startsWith$default((String)attribute, (String)"android:", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)namespace, (Object)ResourceNamespace.ANDROID) ? "android:" + attribute : null;
                for (StyleItemResourceValue styleItem : srv.getDefinedItems()) {
                    if ((!Intrinsics.areEqual((Object)styleItem.getAttrName(), (Object)attribute) || !Intrinsics.areEqual((Object)styleItem.getNamespace(), (Object)namespace)) && !Intrinsics.areEqual((Object)styleItem.getAttrName(), (Object)frameworkResource) || result.contains(styleItem)) continue;
                    Intrinsics.checkNotNull((Object)styleItem);
                    result.add(styleItem);
                }
                String parent = srv.getParentStyleName();
                if (parent != null && !StringsKt.startsWith$default((String)parent, (String)"@android:", (boolean)false, (int)2, null) && (p = ResourceUrl.parse((String)parent)) != null) {
                    if (!acceptMissing && p.isFramework()) {
                        return null;
                    }
                    if (!p.isFramework() && !seen.contains(p.name)) {
                        seen.add(p.name);
                        queue.add(new ResourceValueImpl(ResourceNamespace.RES_AUTO, ResourceType.STYLE, p.name, null));
                    }
                }
                Intrinsics.checkNotNull((Object)name);
                int index = StringsKt.lastIndexOf$default((CharSequence)name, (char)'.', (int)0, (boolean)false, (int)6, null);
                if (parent != null || index <= 0) continue;
                Intrinsics.checkNotNullExpressionValue((Object)name.substring(0, index), (String)"substring(...)");
                if (seen.contains(parentName)) continue;
                seen.add(parentName);
                queue.add(new ResourceValueImpl(ResourceNamespace.RES_AUTO, ResourceType.STYLE, parentName, null));
            }
        }
        return result;
    }

    public static /* synthetic */ List getStyleAttributes$default(Project project, LintClient lintClient, String string, String string2, String string3, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        return Lint.getStyleAttributes(project, lintClient, string, string2, string3, bl);
    }

    @Nullable
    public static final List<StyleResourceValue> getInheritedStyles(@NotNull Project project, @NotNull LintClient client, @NotNull String styleUrl) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)styleUrl, (String)"styleUrl");
        ResourceRepository resources = client.getResources(project, ResourceRepositoryScope.ALL_DEPENDENCIES);
        ResourceUrl style = ResourceUrl.parse((String)styleUrl);
        if (style == null || style.isFramework()) {
            return null;
        }
        List result = null;
        ArrayDeque<ResourceValueImpl> queue = new ArrayDeque<ResourceValueImpl>();
        queue.add(new ResourceValueImpl(ResourceNamespace.RES_AUTO, style.type, style.name, null));
        HashSet<String> seen = new HashSet<String>();
        for (int count = 0; count < 30 && !queue.isEmpty(); ++count) {
            ResourceValue front = (ResourceValue)queue.remove();
            String name = front.getName();
            seen.add(name);
            List items = resources.getResources(ResourceNamespace.TODO(), front.getResourceType(), name);
            for (ResourceItem item : items) {
                String parentName;
                ResourceUrl p;
                ResourceValue rv = item.getResourceValue();
                if (!(rv instanceof StyleResourceValue)) continue;
                if (result == null) {
                    result = new ArrayList();
                }
                result.add(rv);
                String parent = ((StyleResourceValue)rv).getParentStyleName();
                if (!(parent == null || StringsKt.startsWith$default((String)parent, (String)"@android:", (boolean)false, (int)2, null) || (p = ResourceUrl.parse((String)parent)) == null || p.isFramework() || seen.contains(p.name))) {
                    seen.add(p.name);
                    queue.add(new ResourceValueImpl(ResourceNamespace.RES_AUTO, ResourceType.STYLE, p.name, null));
                }
                Intrinsics.checkNotNull((Object)name);
                int index = StringsKt.lastIndexOf$default((CharSequence)name, (char)'.', (int)0, (boolean)false, (int)6, null);
                if (index <= 0) continue;
                Intrinsics.checkNotNullExpressionValue((Object)name.substring(0, index), (String)"substring(...)");
                if (seen.contains(parentName)) continue;
                seen.add(parentName);
                queue.add(new ResourceValueImpl(ResourceNamespace.RES_AUTO, ResourceType.STYLE, parentName, null));
            }
        }
        return result;
    }

    public static final boolean isSameResourceFile(@Nullable File file1, @Nullable File file2) {
        if (file1 != null && file2 != null && Intrinsics.areEqual((Object)file1.getName(), (Object)file2.getName())) {
            File parent1 = file1.getParentFile();
            File parent2 = file2.getParentFile();
            if (parent1 != null && parent2 != null && Intrinsics.areEqual((Object)parent1.getName(), (Object)parent2.getName())) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static final String computeResourceName(@NotNull String prefix, @NotNull String name, @Nullable ResourceFolderType folderType) {
        Object object;
        String string;
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String newPrefix = prefix;
        String newName = name;
        if (((CharSequence)newPrefix).length() == 0) {
            return newName;
        }
        if (folderType != null && folderType != ResourceFolderType.VALUES) {
            String string2 = newName;
            Locale locale = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
            String string3 = string2.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            newName = string3;
            Object underlined = SdkVersionInfo.camelCaseToUnderlines((String)newPrefix);
            if (!Intrinsics.areEqual((Object)newPrefix, (Object)underlined)) {
                string = underlined;
                Intrinsics.checkNotNull((Object)string);
                if (!StringsKt.endsWith$default((String)string, (String)"_", (boolean)false, (int)2, null)) {
                    underlined = (String)underlined + "_";
                }
                string = underlined;
                Intrinsics.checkNotNull((Object)string);
                newPrefix = string;
            }
        }
        if (!(((CharSequence)newName).length() == 0) && Character.isUpperCase(newName.charAt(0))) {
            if (StringsKt.indexOf$default((CharSequence)newPrefix, (char)'_', (int)0, (boolean)false, (int)6, null) != -1) {
                String string4 = SdkVersionInfo.underlinesToCamelCase((String)newPrefix);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"underlinesToCamelCase(...)");
                newPrefix = string4;
            }
            char c = Character.toUpperCase(newPrefix.charAt(0));
            String string5 = newPrefix.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            string = string5;
            newPrefix = c + string;
            if (StringsKt.endsWith$default((String)newPrefix, (String)"_", (boolean)false, (int)2, null)) {
                String string6 = newPrefix.substring(0, newPrefix.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                newPrefix = string6;
            }
        }
        if (((CharSequence)newName).length() == 0) {
            object = newPrefix;
        } else if (StringsKt.endsWith$default((String)newPrefix, (String)"_", (boolean)false, (int)2, null)) {
            object = newPrefix + newName;
        } else {
            char c = Character.toUpperCase(newName.charAt(0));
            String string7 = newName.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
            object = newPrefix + c + string7;
        }
        return object;
    }

    public static /* synthetic */ String computeResourceName$default(String string, String string2, ResourceFolderType resourceFolderType, int n, Object object) {
        if ((n & 4) != 0) {
            resourceFolderType = null;
        }
        return Lint.computeResourceName(string, string2, resourceFolderType);
    }

    public static final boolean isModelOlderThan(@NotNull Project project, int major, int minor, int micro, boolean defaultForNonGradleProjects) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        AgpVersion agpVersion = project.getGradleModelVersion();
        if (agpVersion == null) {
            return defaultForNonGradleProjects;
        }
        AgpVersion version = agpVersion;
        if (version.getMajor() != major) {
            return version.getMajor() < major;
        }
        return version.getMinor() != minor ? version.getMinor() < minor : version.getMicro() < micro;
    }

    public static /* synthetic */ boolean isModelOlderThan$default(Project project, int n, int n2, int n3, boolean bl, int n4, Object object) {
        if ((n4 & 0x10) != 0) {
            bl = false;
        }
        return Lint.isModelOlderThan(project, n, n2, n3, bl);
    }

    @NotNull
    public static final LanguageLevel getLanguageLevel(@NotNull UElement element, @NotNull LanguageLevel defaultLevel) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)defaultLevel, (String)"defaultLevel");
        UFile uFile = UastUtils.getContainingUFile((UElement)element);
        if (uFile == null) {
            return defaultLevel;
        }
        UFile containingFile = uFile;
        return Lint.getLanguageLevel((PsiElement)containingFile.getPsi(), defaultLevel);
    }

    @NotNull
    public static final LanguageLevel getLanguageLevel(@NotNull PsiElement element, @NotNull LanguageLevel defaultLevel) {
        PsiFile containingFile;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)defaultLevel, (String)"defaultLevel");
        PsiFile psiFile = element instanceof PsiFile ? (PsiFile)element : null;
        if (psiFile == null) {
            psiFile = element.getContainingFile();
        }
        PsiJavaFile psiJavaFile = (containingFile = psiFile) instanceof PsiJavaFile ? (PsiJavaFile)containingFile : null;
        Object object = psiJavaFile != null ? psiJavaFile.getLanguageLevel() : null;
        if (object == null) {
            object = defaultLevel;
        }
        return object;
    }

    @NotNull
    public static final LanguageLevel getLanguageLevel(@NotNull Project project, @NotNull LanguageLevel defaultLevel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)defaultLevel, (String)"defaultLevel");
        com.intellij.openapi.project.Project project2 = project.getIdeaProject();
        if (project2 == null) {
            return defaultLevel;
        }
        com.intellij.openapi.project.Project p = project2;
        LanguageLevelProjectExtension languageLevelProjectExtension = LanguageLevelProjectExtension.getInstance((com.intellij.openapi.project.Project)p);
        if (languageLevelProjectExtension == null) {
            return defaultLevel;
        }
        LanguageLevelProjectExtension extension = languageLevelProjectExtension;
        LanguageLevel languageLevel = extension.getLanguageLevel();
        Intrinsics.checkNotNullExpressionValue((Object)languageLevel, (String)"getLanguageLevel(...)");
        return languageLevel;
    }

    @Nullable
    public static final String findSubstring(@NotNull String string, @Nullable String prefix, @Nullable String suffix) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        int start = 0;
        if (prefix != null) {
            start = StringsKt.indexOf$default((CharSequence)string, (String)prefix, (int)0, (boolean)false, (int)6, null);
            if (start == -1) {
                return null;
            }
            start += prefix.length();
        }
        if (suffix != null) {
            String string2;
            int end = StringsKt.indexOf$default((CharSequence)string, (String)suffix, (int)start, (boolean)false, (int)4, null);
            if (end == -1) {
                string2 = null;
            } else {
                String string3 = string.substring(start, end);
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            }
            return string2;
        }
        String string4 = string.substring(start);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        return string4;
    }

    @NotNull
    public static final List<String> getFormattedParameters(@NotNull String format, @NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        StringBuilder pattern = new StringBuilder(format.length());
        int parameter = 0;
        parameter = 1;
        boolean bl = false;
        int n = format.length();
        for (int i = 0; i < n; ++i) {
            char c = format.charAt(i);
            if (c == '%') {
                boolean bl2;
                boolean bl3 = bl2 = i < format.length() - 4;
                if (_Assertions.ENABLED && !bl2) {
                    boolean $i$a$-assert-Lint$getFormattedParameters$1$62 = false;
                    String $i$a$-assert-Lint$getFormattedParameters$1$62 = format;
                    throw new AssertionError((Object)$i$a$-assert-Lint$getFormattedParameters$1$62);
                }
                boolean bl4 = bl2 = format.charAt(i + 1) == 48 + parameter;
                if (_Assertions.ENABLED && !bl2) {
                    boolean $i$a$-assert-Lint$getFormattedParameters$1$72 = false;
                    String $i$a$-assert-Lint$getFormattedParameters$1$72 = format;
                    throw new AssertionError((Object)$i$a$-assert-Lint$getFormattedParameters$1$72);
                }
                bl2 = Character.isDigit(format.charAt(i + 1));
                if (_Assertions.ENABLED && !bl2) {
                    boolean $i$a$-assert-Lint$getFormattedParameters$1$82 = false;
                    String $i$a$-assert-Lint$getFormattedParameters$1$82 = format;
                    throw new AssertionError((Object)$i$a$-assert-Lint$getFormattedParameters$1$82);
                }
                boolean bl5 = bl2 = format.charAt(i + 2) == '$';
                if (_Assertions.ENABLED && !bl2) {
                    boolean $i$a$-assert-Lint$getFormattedParameters$1$92 = false;
                    String $i$a$-assert-Lint$getFormattedParameters$1$92 = format;
                    throw new AssertionError((Object)$i$a$-assert-Lint$getFormattedParameters$1$92);
                }
                boolean bl6 = bl2 = format.charAt(i + 3) == 's';
                if (_Assertions.ENABLED && !bl2) {
                    boolean bl7 = false;
                    String string = format;
                    throw new AssertionError((Object)string);
                }
                ++parameter;
                i += 3;
                pattern.append("(.*)");
                continue;
            }
            pattern.append(c);
        }
        try {
            Pattern compile = Pattern.compile(pattern.toString());
            Matcher matcher = compile.matcher(errorMessage);
            if (matcher.find()) {
                int groupCount = matcher.groupCount();
                ArrayList<String> parameters = new ArrayList<String>(groupCount);
                int i = 1;
                if (i <= groupCount) {
                    while (true) {
                        parameters.add(matcher.group(i));
                        if (i == groupCount) break;
                        ++i;
                    }
                }
                return parameters;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return CollectionsKt.emptyList();
    }

    @Nullable
    public static final LocaleQualifier getLocale(@NotNull String parent) {
        FolderConfiguration config;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        if (StringsKt.indexOf$default((CharSequence)parent, (char)'-', (int)0, (boolean)false, (int)6, null) != -1 && (config = FolderConfiguration.getConfigForFolder((String)parent)) != null) {
            return config.getLocaleQualifier();
        }
        return null;
    }

    @Nullable
    public static final LocaleQualifier getLocale(@NotNull XmlContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        String string = context2.file.getParentFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        LocaleQualifier localeQualifier = Lint.getLocale(string);
        if (localeQualifier != null) {
            LocaleQualifier it = localeQualifier;
            boolean bl = false;
            return it;
        }
        Element root = context2.document.getDocumentElement();
        if (root != null) {
            String locale = root.getAttributeNS("http://schemas.android.com/tools", "locale");
            Intrinsics.checkNotNull((Object)locale);
            if (((CharSequence)locale).length() > 0) {
                if (StringsKt.indexOf$default((CharSequence)locale, (char)'-', (int)0, (boolean)false, (int)6, null) == -1) {
                    return LocaleQualifier.getQualifier((String)locale);
                }
                FolderConfiguration config = FolderConfiguration.getConfigForQualifierString((String)locale);
                if (config != null) {
                    return config.getLocaleQualifier();
                }
            }
        }
        return null;
    }

    public static final boolean isEnglishResource(@NotNull XmlContext context2, boolean assumeForBase) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        LocaleQualifier locale = Lint.getLocale(context2);
        return locale == null ? assumeForBase : Intrinsics.areEqual((Object)"en", (Object)locale.getLanguage());
    }

    @NotNull
    public static final Location guessGradleLocation(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        File file = project.getDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getDir(...)");
        File dir = file;
        Location location2 = null;
        File topLevel = BuildScriptUtil.findGradleBuildFile((File)dir);
        location2 = topLevel.exists() ? Location.Companion.create(topLevel) : Location.Companion.create(dir);
        return location2;
    }

    @NotNull
    public static final Location guessGradleLocation(@NotNull LintClient client, @NotNull File projectDir, @Nullable String string) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        File gradle = BuildScriptUtil.findGradleBuildFile((File)projectDir);
        return Lint.guessGradleLocationForFile(client, gradle, string);
    }

    @NotNull
    public static final Location guessGradleLocationForFile(@NotNull LintClient client, @NotNull File gradle, @Nullable String string) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)gradle, (String)"gradle");
        if (gradle.isFile()) {
            if (string == null) {
                return Location.Companion.create(gradle);
            }
            String contents = ((Object)client.readFile(gradle)).toString();
            int match = StringsKt.indexOf$default((CharSequence)contents, (String)string, (int)0, (boolean)false, (int)6, null);
            if (match != -1) {
                int length = string.length();
                if (StringsKt.indexOf$default((CharSequence)contents, (String)string, (int)(match + length), (boolean)false, (int)4, null) == -1) {
                    return Location.Companion.create(gradle, contents, match, match + length);
                }
                int end = contents.length();
                char first = string.charAt(0);
                int offset = 0;
                while (offset < end - 1) {
                    int skipped;
                    char c = contents.charAt(offset);
                    if (c == '/' && (skipped = LintFixPerformer.Companion.skipCommentsAndWhitespace$default(LintFixPerformer.Companion, contents, offset, false, false, 8, null)) > offset) {
                        offset = skipped;
                        continue;
                    }
                    if (c == first && StringsKt.regionMatches$default((String)contents, (int)offset, (String)string, (int)0, (int)length, (boolean)false, (int)16, null)) {
                        return Location.Companion.create(gradle, contents, offset, offset + length);
                    }
                    ++offset;
                }
            }
        } else if (gradle.isDirectory()) {
            return Lint.guessGradleLocation(client, gradle, string);
        }
        return Location.Companion.create(gradle);
    }

    public static final boolean isNullLiteral(@Nullable PsiElement element) {
        return element instanceof PsiLiteral && Intrinsics.areEqual((Object)"null", (Object)((PsiLiteral)element).getText());
    }

    public static final boolean isTrueLiteral(@Nullable PsiElement element) {
        return element instanceof PsiLiteral && Intrinsics.areEqual((Object)"true", (Object)((PsiLiteral)element).getText());
    }

    public static final boolean isFalseLiteral(@Nullable PsiElement element) {
        return element instanceof PsiLiteral && Intrinsics.areEqual((Object)"false", (Object)((PsiLiteral)element).getText());
    }

    @Deprecated(message="This method is ambiguous. To move up/out in the AST, use skipParenthesizedExprUp instead (and from Java, import static method in UastUtils). To go inside the parentheses, instead use skipParenthesizedExprUp()", replaceWith=@ReplaceWith(expression="skipParenthesizedExprUp(element)", imports={"com.intellij.psi.util.PsiUtil.skipParenthesizedExprUp"}))
    @Nullable
    public static final PsiElement skipParentheses(@Nullable PsiElement element) {
        return PsiUtil.skipParenthesizedExprUp((PsiElement)element);
    }

    @Deprecated(message="This method is ambiguous. To move up/out in the AST, use skipParenthesizedExprUp instead (and from Java, import static method in UastUtils). If the element is not a UExpression there's no need to call this method. To go inside the parentheses, instead use skipParenthesizedExprUp()", replaceWith=@ReplaceWith(expression="skipParenthesizedExprUp(element)", imports={"org.jetbrains.uast.skipParenthesizedExprUp"}))
    @Nullable
    public static final UElement skipParentheses(@Nullable UElement element) {
        UElement current = element;
        while (current instanceof UParenthesizedExpression) {
            current = ((UParenthesizedExpression)current).getUastParent();
        }
        return current;
    }

    @Nullable
    public static final PsiElement nextNonWhitespace(@Nullable PsiElement element) {
        PsiElement current = element;
        if (current != null) {
            current = current.getNextSibling();
            while (current instanceof PsiWhiteSpace) {
                current = ((PsiWhiteSpace)current).getNextSibling();
            }
        }
        return current;
    }

    @Nullable
    public static final PsiElement prevNonWhitespace(@Nullable PsiElement element) {
        PsiElement current = element;
        if (current != null) {
            current = current.getPrevSibling();
            while (current instanceof PsiWhiteSpace) {
                current = ((PsiWhiteSpace)current).getPrevSibling();
            }
        }
        return current;
    }

    public static final boolean isString(@NotNull PsiType type) {
        String shortName;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (type instanceof PsiClassType && !Objects.equal((Object)(shortName = ((PsiClassType)type).getClassName()), (Object)"String")) {
            return false;
        }
        return Intrinsics.areEqual((Object)"java.lang.String", (Object)type.getCanonicalText());
    }

    public static final boolean isInlined(@NotNull PsiField field, @NotNull JavaEvaluator evaluator) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
        PsiType psiType = field.getType();
        Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getType(...)");
        PsiType type = psiType;
        return type instanceof PsiPrimitiveType || Lint.isString(type) ? evaluator.isStatic((PsiModifierListOwner)field) && evaluator.isFinal((PsiModifierListOwner)field) && PsiUtil.isConstantExpression((PsiExpression)field.getInitializer()) : false;
    }

    @Nullable
    public static final String getAutoBoxedType(@NotNull String primitive) {
        String string;
        Intrinsics.checkNotNullParameter((Object)primitive, (String)"primitive");
        switch (primitive) {
            case "int": {
                string = "java.lang.Integer";
                break;
            }
            case "long": {
                string = "java.lang.Long";
                break;
            }
            case "char": {
                string = "java.lang.Character";
                break;
            }
            case "float": {
                string = "java.lang.Float";
                break;
            }
            case "double": {
                string = "java.lang.Double";
                break;
            }
            case "boolean": {
                string = "java.lang.Boolean";
                break;
            }
            case "short": {
                string = "java.lang.Short";
                break;
            }
            case "byte": {
                string = "java.lang.Byte";
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    @Nullable
    public static final String getPrimitiveType(@NotNull String autoBoxedType) {
        Intrinsics.checkNotNullParameter((Object)autoBoxedType, (String)"autoBoxedType");
        return Intrinsics.areEqual((Object)"java.lang.Integer", (Object)autoBoxedType) ? "int" : (Intrinsics.areEqual((Object)"java.lang.Long", (Object)autoBoxedType) ? "long" : (Intrinsics.areEqual((Object)"java.lang.Character", (Object)autoBoxedType) ? "char" : (Intrinsics.areEqual((Object)"java.lang.Float", (Object)autoBoxedType) ? "float" : (Intrinsics.areEqual((Object)"java.lang.Double", (Object)autoBoxedType) ? "double" : (Intrinsics.areEqual((Object)"java.lang.Boolean", (Object)autoBoxedType) ? "boolean" : (Intrinsics.areEqual((Object)"java.lang.Short", (Object)autoBoxedType) ? "short" : (Intrinsics.areEqual((Object)"java.lang.Byte", (Object)autoBoxedType) ? "byte" : null)))))));
    }

    @Deprecated(message="Use the overload which also supplies a project, to help resolve relative references", replaceWith=@ReplaceWith(expression="resolveManifestName(element, context.project)", imports={}))
    @NotNull
    public static final String resolveManifestName(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return Lint.resolveManifestName(element, null);
    }

    @NotNull
    public static final String resolveManifestName(@NotNull Element element, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String className = null;
        String string = className = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element");
        String string2 = className = StringsKt.replace$default((String)string, (char)'$', (char)'.', (boolean)false, (int)4, null);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"element");
        if (StringsKt.startsWith$default((String)string2, (String)".", (boolean)false, (int)2, null)) {
            Object object;
            CharSequence charSequence = element.getOwnerDocument().getDocumentElement().getAttribute("package");
            if (charSequence.length() == 0) {
                boolean bl = false;
                object = project;
                if (object == null || (object = ((Project)object).getPackage()) == null) {
                    String string3 = className;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"element");
                    return string3;
                }
            } else {
                object = charSequence;
            }
            String pkg = (String)object;
            return pkg + className;
        }
        String string4 = className;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"element");
        if (StringsKt.indexOf$default((CharSequence)string4, (char)'.', (int)0, (boolean)false, (int)6, null) == -1) {
            Object object;
            CharSequence charSequence = element.getOwnerDocument().getDocumentElement().getAttribute("package");
            if (charSequence.length() == 0) {
                boolean bl = false;
                object = project;
                if (object == null || (object = ((Project)object).getPackage()) == null) {
                    String string5 = className;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"element");
                    return string5;
                }
            } else {
                object = charSequence;
            }
            String pkg = (String)object;
            return pkg + "." + className;
        }
        String string6 = className;
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"element");
        return string6;
    }

    @Deprecated(message="Supply defaultValue for missing variables", replaceWith=@ReplaceWith(expression="resolvePlaceHolders(project, value, substitutions, \"\"", imports={}))
    @NotNull
    public static final String resolvePlaceHolders(@Nullable Project project, @NotNull String value, @Nullable Map<String, String> substitutions) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = Lint.resolvePlaceHolders(project, value, substitutions, "");
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @Contract(value="_, !null, _, !null -> !null")
    @Nullable
    public static final String resolvePlaceHolders(@Nullable Project project, @NotNull String value, @Nullable Map<String, String> substitutions, @Nullable String defaultValue) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object s = value;
        int start;
        while ((start = StringsKt.indexOf$default((CharSequence)((CharSequence)s), (String)"${", (int)0, (boolean)false, (int)6, null)) != -1) {
            String name;
            int end = StringsKt.indexOf$default((CharSequence)((CharSequence)s), (String)"}", (int)(start + 1), (boolean)false, (int)4, null);
            if (end == -1) {
                return s;
            }
            Intrinsics.checkNotNullExpressionValue((Object)((String)s).substring(start + 2, end), (String)"substring(...)");
            String string = Lint.resolvePlaceHolder(project, name);
            if (string == null) {
                Map<String, String> map = substitutions;
                string = map != null ? map.get(name) : null;
                if (string == null && (string = defaultValue) == null) {
                    return null;
                }
            }
            String replacement = string;
            String string2 = ((String)s).substring(0, start);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String string3 = ((String)s).substring(end + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            s = string2 + replacement + string3;
        }
        return s;
    }

    public static /* synthetic */ String resolvePlaceHolders$default(Project project, String string, Map map, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            map = null;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        return Lint.resolvePlaceHolders(project, string, map, string2);
    }

    @Nullable
    public static final String resolvePlaceHolder(@Nullable Project project, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Project project2 = project;
        if (project2 == null || (project2 = project2.getBuildVariant()) == null) {
            return null;
        }
        Project variant = project2;
        Map placeHolders = variant.getManifestPlaceholders();
        return (String)placeHolders.get(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isJavaKeyword(@NotNull String keyword) {
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        String string = keyword;
        switch (string.hashCode()) {
            case -1466596076: {
                if (string.equals("synchronized")) return true;
                return false;
            }
            case 3211: {
                if (string.equals("do")) return true;
                return false;
            }
            case 97526364: {
                if (string.equals("float")) return true;
                return false;
            }
            case 113101617: {
                if (string.equals("while")) return true;
                return false;
            }
            case -608539730: {
                if (string.equals("protected")) return true;
                return false;
            }
            case -567202649: {
                if (string.equals("continue")) return true;
                return false;
            }
            case 3116345: {
                if (string.equals("else")) return true;
                return false;
            }
            case 94432955: {
                if (string.equals("catch")) return true;
                return false;
            }
            case 3357: {
                if (string.equals("if")) return true;
                return false;
            }
            case 3046192: {
                if (string.equals("case")) return true;
                return false;
            }
            case 108960: {
                if (string.equals("new")) return true;
                return false;
            }
            case -807062458: {
                if (string.equals("package")) return true;
                return false;
            }
            case -892481938: {
                if (string.equals("static")) return true;
                return false;
            }
            case 3625364: {
                if (string.equals("void")) return true;
                return false;
            }
            case 3039496: {
                if (string.equals("byte")) return true;
                return false;
            }
            case -1325958191: {
                if (string.equals("double")) return true;
                return false;
            }
            case -853259901: {
                if (string.equals("finally")) return true;
                return false;
            }
            case 3559070: {
                if (string.equals("this")) return true;
                return false;
            }
            case 1794694483: {
                if (string.equals("strictfp")) return true;
                return false;
            }
            case -874432947: {
                if (string.equals("throws")) return true;
                return false;
            }
            case 3118337: {
                if (string.equals("enum")) return true;
                return false;
            }
            case -1305664359: {
                if (string.equals("extends")) return true;
                return false;
            }
            case 3392903: {
                if (string.equals("null")) return true;
                return false;
            }
            case 1052746378: {
                if (string.equals("transient")) return true;
                return false;
            }
            case 97436022: {
                if (string.equals("final")) return true;
                return false;
            }
            case 3569038: {
                if (string.equals("true")) return true;
                return false;
            }
            case 115131: {
                if (string.equals("try")) return true;
                return false;
            }
            case -915384400: {
                if (string.equals("implements")) return true;
                return false;
            }
            case -314497661: {
                if (string.equals("private")) return true;
                return false;
            }
            case 94844771: {
                if (string.equals("const")) return true;
                return false;
            }
            case -1184795739: {
                if (string.equals("import")) return true;
                return false;
            }
            case 101577: {
                if (string.equals("for")) return true;
                return false;
            }
            case 502623545: {
                if (string.equals("interface")) return true;
                return false;
            }
            case 3327612: {
                if (string.equals("long")) return true;
                return false;
            }
            case -889473228: {
                if (string.equals("switch")) return true;
                return false;
            }
            case 1544803905: {
                if (string.equals("default")) return true;
                return false;
            }
            case 3178851: {
                if (string.equals("goto")) return true;
                return false;
            }
            case -977423767: {
                if (string.equals("public")) return true;
                return false;
            }
            case -1052618729: {
                if (string.equals("native")) return true;
                return false;
            }
            case -1408208058: {
                if (string.equals("assert")) return true;
                return false;
            }
            case 94742904: {
                if (string.equals("class")) return true;
                return false;
            }
            case 94001407: {
                if (string.equals("break")) return true;
                return false;
            }
            case 97196323: {
                if (string.equals("false")) return true;
                return false;
            }
            case -1888027236: {
                if (string.equals("volatile")) return true;
                return false;
            }
            case 1732898850: {
                if (string.equals("abstract")) return true;
                return false;
            }
            case 104431: {
                if (string.equals("int")) return true;
                return false;
            }
            case 902025516: {
                if (string.equals("instanceof")) return true;
                return false;
            }
            case 109801339: {
                if (string.equals("super")) return true;
                return false;
            }
            case 64711720: {
                if (string.equals("boolean")) return true;
                return false;
            }
            case 110339814: {
                if (string.equals("throw")) return true;
                return false;
            }
            case 3052374: {
                if (string.equals("char")) return true;
                return false;
            }
            case 109413500: {
                if (string.equals("short")) return true;
                return false;
            }
            case -934396624: {
                if (!string.equals("return")) return false;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isKotlinHardKeyword(@NotNull String keyword) {
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        String string = keyword;
        switch (string.hashCode()) {
            case 101577: {
                if (string.equals("for")) return true;
                return false;
            }
            case 3211: {
                if (string.equals("do")) return true;
                return false;
            }
            case 502623545: {
                if (string.equals("interface")) return true;
                return false;
            }
            case 113101617: {
                if (string.equals("while")) return true;
                return false;
            }
            case 3648314: {
                if (string.equals("when")) return true;
                return false;
            }
            case -567202649: {
                if (string.equals("continue")) return true;
                return false;
            }
            case 3116345: {
                if (string.equals("else")) return true;
                return false;
            }
            case 520977238: {
                if (string.equals("typealias")) return true;
                return false;
            }
            case 94742904: {
                if (string.equals("class")) return true;
                return false;
            }
            case 3357: {
                if (string.equals("if")) return true;
                return false;
            }
            case -858802543: {
                if (string.equals("typeof")) return true;
                return false;
            }
            case 116513: {
                if (string.equals("val")) return true;
                return false;
            }
            case -807062458: {
                if (string.equals("package")) return true;
                return false;
            }
            case 94001407: {
                if (string.equals("break")) return true;
                return false;
            }
            case 3365: {
                if (string.equals("in")) return true;
                return false;
            }
            case 116519: {
                if (string.equals("var")) return true;
                return false;
            }
            case 97196323: {
                if (string.equals("false")) return true;
                return false;
            }
            case 3559070: {
                if (string.equals("this")) return true;
                return false;
            }
            case 3370: {
                if (string.equals("is")) return true;
                return false;
            }
            case 109801339: {
                if (string.equals("super")) return true;
                return false;
            }
            case 3122: {
                if (string.equals("as")) return true;
                return false;
            }
            case 3392903: {
                if (string.equals("null")) return true;
                return false;
            }
            case 110339814: {
                if (string.equals("throw")) return true;
                return false;
            }
            case 3569038: {
                if (string.equals("true")) return true;
                return false;
            }
            case 115131: {
                if (string.equals("try")) return true;
                return false;
            }
            case 101759: {
                if (string.equals("fun")) return true;
                return false;
            }
            case -934396624: {
                if (string.equals("return")) return true;
                return false;
            }
            case -1023368385: {
                if (!string.equals("object")) return false;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final byte[] readUrlData(@NotNull LintClient client, @NotNull String query, int timeout) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        URL url = new URL(query);
        URLConnection uRLConnection = client.openConnection(url, timeout);
        if (uRLConnection == null) {
            return null;
        }
        URLConnection connection = uRLConnection;
        try {
            InputStream inputStream;
            if (connection.getInputStream() == null) {
                byte[] byArray2 = null;
                return byArray2;
            }
            InputStream is = inputStream;
            byArray = ByteStreams.toByteArray((InputStream)is);
        }
        finally {
            client.closeConnection(connection);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final NetworkCache.ReadUrlDataResult readUrlData(@NotNull LintClient client, @NotNull String query, int timeout, long lastModified) {
        NetworkCache.ReadUrlDataResult readUrlDataResult;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        URL url = new URL(query);
        NetworkCache.ReadUrlDataResult failure = new NetworkCache.ReadUrlDataResult(null, true);
        NetworkCache.ReadUrlDataResult cached = new NetworkCache.ReadUrlDataResult(null, false);
        URLConnection uRLConnection = client.openConnection(url, timeout);
        if (uRLConnection == null) {
            return failure;
        }
        URLConnection connection = uRLConnection;
        connection.setIfModifiedSince(lastModified);
        try {
            connection.connect();
            if (connection instanceof HttpURLConnection && ((HttpURLConnection)connection).getResponseCode() == 304) {
                NetworkCache.ReadUrlDataResult readUrlDataResult2 = cached;
                return readUrlDataResult2;
            }
            InputStream inputStream = connection.getInputStream();
            if (inputStream == null) {
                NetworkCache.ReadUrlDataResult readUrlDataResult3 = failure;
                return readUrlDataResult3;
            }
            InputStream is = inputStream;
            readUrlDataResult = new NetworkCache.ReadUrlDataResult(ByteStreams.toByteArray((InputStream)is), true);
        }
        finally {
            client.closeConnection(connection);
        }
        return readUrlDataResult;
    }

    @Nullable
    public static final String readUrlDataAsString(@NotNull LintClient client, @NotNull String query, int timeout) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        byte[] bytes = Lint.readUrlData(client, query, timeout);
        return bytes != null ? new String(bytes, Charsets.UTF_8) : null;
    }

    @SafeVarargs
    @Nullable
    public static final <T> T coalesce(T ... ts) {
        Intrinsics.checkNotNullParameter(ts, (String)"ts");
        for (T t : ts) {
            if (t == null) continue;
            return t;
        }
        return null;
    }

    @Nullable
    public static final String getMethodName(@NotNull UCallExpression call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        UIdentifier methodIdentifier = call.getMethodIdentifier();
        Object object = methodIdentifier;
        if (object == null || (object = object.getName()) == null) {
            object = call.getMethodName();
        }
        return object;
    }

    public static final boolean isLayoutMarkerTag(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String tagName = element.getLocalName();
        Intrinsics.checkNotNull((Object)tagName);
        if (Lint.isLayoutMarkerTag(tagName)) {
            return true;
        }
        return Intrinsics.areEqual((Object)tagName, (Object)"attr") && Intrinsics.areEqual((Object)element.getNamespaceURI(), (Object)"http://schemas.android.com/aapt");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isLayoutMarkerTag(@NotNull String tagName) {
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        String string = tagName;
        switch (string.hashCode()) {
            case -1109722326: {
                if (string.equals("layout")) return true;
                return false;
            }
            case 1280029577: {
                if (string.equals("requestFocus")) return true;
                return false;
            }
            case 3076010: {
                if (string.equals("data")) return true;
                return false;
            }
            case -1184795739: {
                if (string.equals("import")) return true;
                return false;
            }
            case -1249586564: {
                if (string.equals("variable")) return true;
                return false;
            }
            case 114586: {
                if (string.equals("tag")) return true;
                return false;
            }
            case 2018201991: {
                if (!string.equals("aapt:attr")) return false;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated(message="Prefer to check element's language directly", replaceWith=@ReplaceWith(expression="element != null && isKotlin(element.language)", imports={}))
    public static final boolean isKotlin(@Nullable PsiElement element) {
        if (element == null) return false;
        Language language = element.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        if (!Lint.isKotlin(language)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated(message="Prefer to check element's language directly", replaceWith=@ReplaceWith(expression="element != null && isJava(element.language)", imports={}))
    public static final boolean isJava(@Nullable PsiElement element) {
        if (element == null) return false;
        Language language = element.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        if (!Lint.isJava(language)) return false;
        return true;
    }

    public static final boolean isKotlin(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE);
    }

    public static final boolean isJava(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return Intrinsics.areEqual((Object)language, (Object)JavaLanguage.INSTANCE);
    }

    public static final boolean isNumberString(@Nullable String s) {
        if (s == null || ((CharSequence)s).length() == 0) {
            return false;
        }
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static final boolean isPolyadicFromStringTemplate(@Nullable UElement element) {
        return element instanceof UPolyadicExpression && ((UPolyadicExpression)element).getSourcePsi() instanceof KtStringTemplateExpression;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Map<UExpression, PsiParameter> computeKotlinArgumentMapping(@NotNull UCallExpression call, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (call instanceof UImplicitCallExpression) {
            return ((UImplicitCallExpression)call).getArgumentMapping();
        }
        if (method.getParameterList().getParametersCount() <= 1) {
            return null;
        }
        if (!(call.getPsi() instanceof KtElement)) {
            return null;
        }
        PsiParameter[] psiParameterArray = method.getParameterList().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
        PsiParameter[] parameters = psiParameterArray;
        if (!(parameters.length == 0)) {
            Map mapping = new LinkedHashMap();
            PsiParameter[] $this$forEachIndexed$iv = parameters;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (PsiParameter item$iv : $this$forEachIndexed$iv) {
                void psiParameter;
                UExpression argument;
                int n = index$iv++;
                PsiParameter psiParameter2 = item$iv;
                int index = n;
                boolean bl = false;
                if (call.getArgumentForParameter(index) == null) continue;
                boolean bl2 = false;
                if (argument instanceof UExpressionList) {
                    Iterable $this$forEach$iv = ((UExpressionList)argument).getExpressions();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        UExpression it = (UExpression)element$iv;
                        boolean bl3 = false;
                        Intrinsics.checkNotNull((Object)psiParameter);
                        mapping.put(it, psiParameter);
                    }
                    continue;
                }
                Intrinsics.checkNotNull((Object)psiParameter);
                mapping.put(argument, psiParameter);
            }
            if (!mapping.isEmpty()) {
                return mapping;
            }
        }
        return null;
    }

    @Nullable
    public static final UMethod getUMethod(@NotNull PsiMethod $this$getUMethod) {
        Intrinsics.checkNotNullParameter((Object)$this$getUMethod, (String)"<this>");
        UElement uElement = UastFacade.INSTANCE.convertElementWithParent((PsiElement)$this$getUMethod, UMethod.class);
        return uElement instanceof UMethod ? (UMethod)uElement : null;
    }

    public static final boolean isJreFolder(@NotNull File homePath) {
        Intrinsics.checkNotNullParameter((Object)homePath, (String)"homePath");
        return new File(homePath, "bin/java").isFile() || new File(homePath, "bin/java.exe").isFile();
    }

    public static final boolean isJdkFolder(@NotNull File homePath) {
        Intrinsics.checkNotNullParameter((Object)homePath, (String)"homePath");
        return new File(homePath, "bin/javac").isFile() || new File(homePath, "bin/javac.exe").isFile();
    }

    @Nullable
    public static final Element matchXmlElement(@NotNull Element element, @NotNull Document targetDocument) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)targetDocument, (String)"targetDocument");
        Element target = targetDocument.getDocumentElement();
        List path2 = new ArrayList();
        Element curr = element;
        while (true) {
            path2.add(curr);
            Node node = curr.getParentNode();
            if ((node instanceof Element ? (Element)node : null) == null) break;
            curr = curr;
        }
        if (path2.size() == 1 && Intrinsics.areEqual((Object)element.getTagName(), (Object)target.getTagName())) {
            return target;
        }
        CollectionsKt.reverse((List)path2);
        Element element2 = target;
        if (element2 == null) {
            return null;
        }
        Element start = element2;
        if (!Intrinsics.areEqual((Object)start.getTagName(), (Object)((Element)path2.get(0)).getTagName())) {
            return null;
        }
        return Lint.search(path2, 1, start);
    }

    private static final Element search(List<? extends Element> path2, int index, Element parent) {
        if (index == path2.size()) {
            return parent;
        }
        Element source = path2.get(index);
        if (source.hasAttribute("name")) {
            String name = source.getAttribute("name");
            Iterator iterator = DomExtensions.iterator((Element)parent);
            while (iterator.hasNext()) {
                Element child = (Element)iterator.next();
                if (!Intrinsics.areEqual((Object)child.getAttribute("name"), (Object)name)) continue;
                return Lint.search(path2, index + 1, child);
            }
        } else if (source.hasAttribute("id")) {
            String id = source.getAttribute("id");
            Iterator iterator = DomExtensions.iterator((Element)parent);
            while (iterator.hasNext()) {
                Element child = (Element)iterator.next();
                if (!Intrinsics.areEqual((Object)child.getAttribute("id"), (Object)id)) continue;
                return Lint.search(path2, index + 1, child);
            }
        } else {
            Node curr;
            String tag = source.getNodeName();
            int ordinal = 0;
            for (curr = (Node)source; curr != null; curr = curr.getPreviousSibling()) {
                if (curr.getNodeType() != 1 || !Intrinsics.areEqual((Object)curr.getNodeName(), (Object)tag)) continue;
                ++ordinal;
            }
            curr = parent.getFirstChild();
            while (curr != null) {
                if ((curr = curr.getNextSibling()).getNodeType() != 1 || !Intrinsics.areEqual((Object)curr.getNodeName(), (Object)tag) || --ordinal != 0) continue;
                Node node = curr;
                Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
                Element child = (Element)node;
                Element element = Lint.search(path2, index + 1, child);
                if (element == null) break;
                Element it = element;
                boolean bl = false;
                return it;
            }
            Iterator iterator = DomExtensions.iterator((Element)parent);
            while (iterator.hasNext()) {
                Element element;
                Element child = (Element)iterator.next();
                if (!Intrinsics.areEqual((Object)child.getTagName(), (Object)tag) || (element = Lint.search(path2, index + 1, child)) == null) continue;
                Element it = element;
                boolean bl = false;
                return it;
            }
        }
        return null;
    }

    public static final boolean hasImplicitDefaultConstructor(@Nullable UClass uClass) {
        boolean bl;
        block6: {
            UClass uClass2 = uClass;
            if (uClass2 == null || (uClass2 = uClass2.getSourcePsi()) == null) {
                return false;
            }
            UClass sourcePsi = uClass2;
            if (sourcePsi instanceof KtClass) {
                Iterable $this$none$iv = ((KtClass)sourcePsi).getDeclarations();
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        KtDeclaration it = (KtDeclaration)element$iv;
                        boolean bl2 = false;
                        if (!(it instanceof KtConstructor)) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            } else {
                bl = Lint.hasImplicitDefaultConstructor(sourcePsi instanceof PsiClass ? (PsiClass)sourcePsi : null);
            }
        }
        return bl;
    }

    public static final boolean hasImplicitDefaultConstructor(@Nullable PsiClass psiClass) {
        if (psiClass == null) {
            return false;
        }
        if (psiClass instanceof KtLightClassForFacade || psiClass instanceof UClass && ((UClass)psiClass).getSourcePsi() == null) {
            return false;
        }
        PsiMethod[] psiMethodArray = psiClass.getConstructors();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"getConstructors(...)");
        PsiMethod[] constructors = psiMethodArray;
        if (constructors.length == 0 && !psiClass.isInterface() && !psiClass.isAnnotationType() && !psiClass.isEnum()) {
            if (PsiUtil.hasDefaultConstructor((PsiClass)psiClass)) {
                return true;
            }
            if (psiClass.hasModifierProperty("final") && !psiClass.hasModifierProperty("abstract") && psiClass.hasModifierProperty("public")) {
                return true;
            }
        }
        return false;
    }
}

