/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintJarVerifier;
import com.android.tools.lint.client.api.LintJarVerifierKt;
import com.android.tools.lint.helpers.ZipStreamsKt;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0081\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u001d\u0018\u00002\u00020\u0001B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0013H\u0002J\u0018\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u0013H\u0002J \u0010'\u001a\u00020\"2\u0006\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u0013H\u0002J\u0018\u0010)\u001a\u00020\"2\u0006\u0010%\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\rH\u0002J\u0006\u0010+\u001a\u00020\u0013J\u0014\u0010,\u001a\u0006\u0012\u0002\b\u00030-2\u0006\u0010#\u001a\u00020\u0013H\u0002J\u0018\u0010.\u001a\u00020/2\u0006\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u0013H\u0002J \u00100\u001a\u0002012\u0006\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u0013H\u0002J\u0006\u00102\u001a\u00020\u0013J\b\u00103\u001a\u0004\u0018\u00010 J\u0010\u00104\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u0013H\u0002J\u0006\u00105\u001a\u00020\u0007J\u0006\u00106\u001a\u00020\u0007J\u0010\u00107\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u0013H\u0002J&\u00108\u001a\u00020\u00072\f\u0010\u0016\u001a\b\u0012\u0002\b\u0003\u0018\u00010-2\u0006\u00109\u001a\u00020\u00132\u0006\u0010:\u001a\u00020\u0015H\u0002J\u0010\u0010;\u001a\u00020\"2\u0006\u0010<\u001a\u00020\nH\u0002J\u001c\u0010;\u001a\u00020\"2\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\n0>H\u0002JK\u0010?\u001a\u00020\"2\u0006\u0010@\u001a\u00020\r2\u0006\u0010A\u001a\u00020\r2\u0006\u0010&\u001a\u00020\u00132\b\u0010B\u001a\u0004\u0018\u00010\u00132\b\u0010C\u001a\u0004\u0018\u00010\u00132\u0010\u0010D\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0013\u0018\u00010EH\u0016\u00a2\u0006\u0002\u0010FJE\u0010G\u001a\u00020H2\u0006\u0010A\u001a\u00020\r2\b\u0010&\u001a\u0004\u0018\u00010\u00132\b\u0010(\u001a\u0004\u0018\u00010\u00132\b\u0010B\u001a\u0004\u0018\u00010\u00132\u0010\u0010I\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0013\u0018\u00010EH\u0016\u00a2\u0006\u0002\u0010JR\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lcom/android/tools/lint/client/api/LintJarVerifier;", "Lorg/objectweb/asm/ClassVisitor;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "jarFile", "Ljava/io/File;", "skip", "", "(Lcom/android/tools/lint/client/api/LintClient;Ljava/io/File;Z)V", "bytes", "", "(Lcom/android/tools/lint/client/api/LintClient;Ljava/io/File;[BZ)V", "<set-?>", "", "apiCount", "getApiCount", "()I", "bundledClasses", "", "", "classLoader", "Ljava/lang/ClassLoader;", "currentClass", "currentClassFile", "currentSuperClass", "inaccessible", "incompatibleReference", "incompatibleReferencer", "methodVisitor", "com/android/tools/lint/client/api/LintJarVerifier$methodVisitor$1", "Lcom/android/tools/lint/client/api/LintJarVerifier$methodVisitor$1;", "verifyProblem", "", "checkClass", "", "internal", "checkField", "owner", "name", "checkMethod", "descriptor", "checkModifiers", "modifiers", "describeFirstIncompatibleReference", "getClass", "Ljava/lang/Class;", "getField", "Ljava/lang/reflect/Field;", "getMethod", "Ljava/lang/reflect/Executable;", "getReferenceClassFile", "getVerificationThrowable", "isCalledFromSubClass", "isCompatible", "isInaccessible", "isRelevantApi", "isSubClass", "target", "loader", "verify", "lintJarBytes", "classes", "", "visit", "version", "access", "signature", "superName", "interfaces", "", "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "visitMethod", "Lorg/objectweb/asm/MethodVisitor;", "exceptions", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lorg/objectweb/asm/MethodVisitor;", "lint-api"})
@SourceDebugExtension(value={"SMAP\nLintJarVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintJarVerifier.kt\ncom/android/tools/lint/client/api/LintJarVerifier\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,442:1\n215#2,2:443\n11065#3:445\n11400#3,3:446\n13309#3,2:452\n37#4,2:449\n1#5:451\n*S KotlinDebug\n*F\n+ 1 LintJarVerifier.kt\ncom/android/tools/lint/client/api/LintJarVerifier\n*L\n120#1:443,2\n353#1:445\n353#1:446,3\n394#1:452,2\n353#1:449,2\n*E\n"})
public final class LintJarVerifier
extends ClassVisitor {
    @NotNull
    private final LintClient client;
    @NotNull
    private final File jarFile;
    private final boolean skip;
    @Nullable
    private Throwable verifyProblem;
    @Nullable
    private String incompatibleReference;
    @NotNull
    private final Set<String> bundledClasses;
    @Nullable
    private String incompatibleReferencer;
    private boolean inaccessible;
    @NotNull
    private final methodVisitor.1 methodVisitor;
    private int apiCount;
    @Nullable
    private String currentClassFile;
    @Nullable
    private String currentClass;
    @Nullable
    private String currentSuperClass;
    @Nullable
    private ClassLoader classLoader;

    public LintJarVerifier(@NotNull LintClient client, @NotNull File jarFile, @NotNull byte[] bytes, boolean skip) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        super(589824);
        this.client = client;
        this.jarFile = jarFile;
        this.skip = skip;
        this.bundledClasses = new LinkedHashSet();
        this.methodVisitor = new MethodVisitor(this){
            final /* synthetic */ LintJarVerifier this$0;
            {
                this.this$0 = $receiver;
                super(589824);
            }

            public void visitMethodInsn(int opcode, @NotNull String owner, @NotNull String name, @NotNull String descriptor, boolean isInterface) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                LintJarVerifier.access$checkMethod(this.this$0, owner, name, descriptor);
                super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
            }

            public void visitFieldInsn(int opcode, @NotNull String owner, @NotNull String name, @Nullable String descriptor) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                LintJarVerifier.access$checkField(this.this$0, owner, name);
                super.visitFieldInsn(opcode, owner, name, descriptor);
            }
        };
        try {
            this.verify(bytes);
        }
        catch (Throwable throwable) {
            this.verifyProblem = throwable;
        }
    }

    public /* synthetic */ LintJarVerifier(LintClient lintClient, File file, byte[] byArray, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(lintClient, file, byArray, bl);
    }

    public LintJarVerifier(@NotNull LintClient client, @NotNull File jarFile, boolean skip) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        this(client, jarFile, FilesKt.readBytes((File)jarFile), skip);
    }

    public /* synthetic */ LintJarVerifier(LintClient lintClient, File file, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(lintClient, file, bl);
    }

    private final boolean isRelevantApi(String internal) {
        boolean relevant = StringsKt.startsWith$default((String)internal, (String)"com/android/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)internal, (String)"org/jetbrains/uast", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)internal, (String)"org/jetbrains/kotlin", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)internal, (String)"com/intellij", (boolean)false, (int)2, null);
        return relevant && !this.bundledClasses.contains(internal);
    }

    public final boolean isCompatible() {
        return this.incompatibleReference == null;
    }

    public final boolean isInaccessible() {
        return this.inaccessible;
    }

    @Nullable
    public final Throwable getVerificationThrowable() {
        return this.verifyProblem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void verify(byte[] lintJarBytes) {
        if (this.skip) {
            return;
        }
        Map classes = new LinkedHashMap();
        Closeable closeable = new JarInputStream(new ByteArrayInputStream(lintJarBytes));
        Throwable throwable = null;
        try {
            JarInputStream jar = (JarInputStream)closeable;
            boolean bl = false;
            ZipEntry entry = jar.getNextEntry();
            while (entry != null) {
                boolean directory = entry.isDirectory();
                String name = entry.getName();
                if (!directory) {
                    Intrinsics.checkNotNull((Object)name);
                    if (StringsKt.endsWith$default((String)name, (String)".class", (boolean)false, (int)2, null)) {
                        Map map = classes;
                        String string = name;
                        byte[] byArray = ZipStreamsKt.readAllBytes(jar, entry);
                        map.put(string, byArray);
                    }
                }
                entry = jar.getNextEntry();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        this.verify(classes);
    }

    private final void verify(Map<String, byte[]> classes) {
        block2: {
            ClassLoader classLoader;
            Map<String, byte[]> $this$forEach$iv = classes;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, byte[]>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, byte[]> element$iv;
                Map.Entry<String, byte[]> entry = element$iv = iterator.next();
                boolean bl = false;
                String name = entry.getKey();
                this.bundledClasses.add(StringsKt.removeSuffix((String)name, (CharSequence)".class"));
            }
            for (Map.Entry<String, byte[]> entry : classes.entrySet()) {
                String name = entry.getKey();
                byte[] bytes = entry.getValue();
                this.currentClassFile = name;
                ClassReader reader = new ClassReader(bytes);
                reader.accept((ClassVisitor)this, 6);
                if (this.incompatibleReference == null) continue;
            }
            URLClassLoader uRLClassLoader = (classLoader = this.classLoader) instanceof URLClassLoader ? (URLClassLoader)classLoader : null;
            if (uRLClassLoader == null) break block2;
            uRLClassLoader.close();
        }
    }

    @NotNull
    public final String describeFirstIncompatibleReference() {
        String string = this.incompatibleReference;
        if (string == null) {
            return "Compatible";
        }
        String reference = string;
        int index = StringsKt.indexOf$default((CharSequence)reference, (char)'#', (int)0, (boolean)false, (int)6, null);
        if (index == -1) {
            String string2 = Type.getObjectType((String)reference).getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getClassName(...)");
            return StringsKt.replace$default((String)string2, (char)'$', (char)'.', (boolean)false, (int)4, null);
        }
        String string3 = reference.substring(0, index);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String string4 = Type.getObjectType((String)string3).getClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getClassName(...)");
        String className = StringsKt.replace$default((String)string4, (char)'$', (char)'.', (boolean)false, (int)4, null);
        int paren = StringsKt.indexOf$default((CharSequence)reference, (char)'(', (int)0, (boolean)false, (int)6, null);
        if (paren == -1) {
            String string5 = reference.substring(index + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            return className + "#" + string5;
        }
        StringBuilder sb = new StringBuilder(className).append(": ");
        String string6 = reference.substring(paren);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
        String descriptor = string6;
        CharSequence name = reference.subSequence(index + 1, paren);
        Object[] arguments = Type.getArgumentTypes((String)descriptor);
        if (Intrinsics.areEqual((Object)name, (Object)"<init>")) {
            String string7 = className.substring(StringsKt.lastIndexOf$default((CharSequence)className, (char)'.', (int)0, (boolean)false, (int)6, null) + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
            sb.append(string7);
        } else {
            String returnType = Type.getReturnType((String)descriptor).getClassName();
            sb.append(returnType).append(' ');
            sb.append(name);
        }
        sb.append('(');
        Intrinsics.checkNotNull((Object)arguments);
        sb.append(ArraysKt.joinToString$default((Object[])arguments, (CharSequence)",", null, null, (int)0, null, (Function1)describeFirstIncompatibleReference.1.INSTANCE, (int)30, null));
        sb.append(')');
        String string8 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toString(...)");
        return string8;
    }

    @NotNull
    public final String getReferenceClassFile() {
        String string = this.incompatibleReferencer;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    private final void checkClass(String internal) {
        if (this.isRelevantApi(internal)) {
            try {
                this.getClass(internal);
            }
            catch (Throwable e) {
                this.incompatibleReference = internal;
                this.incompatibleReferencer = this.currentClassFile;
            }
        }
    }

    public final int getApiCount() {
        return this.apiCount;
    }

    private final void checkMethod(String owner, String name, String descriptor) {
        if (this.isRelevantApi(owner)) {
            try {
                int n = this.apiCount;
                this.apiCount = n + 1;
                Executable method = this.getMethod(owner, name, descriptor);
                this.checkModifiers(owner, method.getModifiers());
            }
            catch (Throwable e) {
                this.incompatibleReference = owner + "#" + name + descriptor;
                this.incompatibleReferencer = this.currentClassFile;
            }
        }
    }

    private final void checkField(String owner, String name) {
        if (this.isRelevantApi(owner)) {
            try {
                int n = this.apiCount;
                this.apiCount = n + 1;
                Field field = this.getField(owner, name);
                this.checkModifiers(owner, field.getModifiers());
            }
            catch (Throwable e) {
                this.incompatibleReference = owner + "#" + name;
                this.incompatibleReferencer = this.currentClassFile;
            }
        }
    }

    private final void checkModifiers(String owner, int modifiers) {
        if ((modifiers & 1) != 0 || (modifiers & 4) != 0 && this.isCalledFromSubClass(owner)) {
            return;
        }
        this.inaccessible = true;
        throw new IllegalAccessException(owner);
    }

    private final boolean isCalledFromSubClass(String owner) {
        if (Intrinsics.areEqual((Object)this.currentSuperClass, (Object)owner)) {
            return true;
        }
        try {
            ClassLoader classLoader = this.classLoader;
            if (classLoader == null) {
                ClassLoader classLoader2;
                List list = CollectionsKt.listOf((Object)this.jarFile);
                ClassLoader classLoader3 = ((Object)((Object)this)).getClass().getClassLoader();
                Intrinsics.checkNotNullExpressionValue((Object)classLoader3, (String)"getClassLoader(...)");
                ClassLoader it = classLoader2 = this.client.createUrlClassLoader(list, classLoader3);
                boolean bl = false;
                this.classLoader = it;
                classLoader = classLoader2;
            }
            ClassLoader loader = classLoader;
            String string = this.currentClass;
            if (string == null) {
                return false;
            }
            String currentClass = string;
            Class<?> cls = Class.forName(StringsKt.replace$default((String)currentClass, (char)'/', (char)'.', (boolean)false, (int)4, null), false, loader);
            return this.isSubClass(cls, StringsKt.replace$default((String)owner, (char)'/', (char)'.', (boolean)false, (int)4, null), loader);
        }
        catch (Throwable ignore) {
            return true;
        }
    }

    private final boolean isSubClass(Class<?> currentClass, String target, ClassLoader loader) {
        if (currentClass == null) {
            return false;
        }
        if (Intrinsics.areEqual((Object)currentClass.getName(), (Object)target)) {
            return true;
        }
        Class<?> superClass = currentClass.getSuperclass();
        if (this.isSubClass(superClass, target, loader)) {
            return true;
        }
        Class<?>[] classArray = currentClass.getInterfaces();
        Intrinsics.checkNotNullExpressionValue(classArray, (String)"getInterfaces(...)");
        for (Class<?> itf : classArray) {
            if (!this.isSubClass(itf, target, loader)) continue;
            return true;
        }
        return false;
    }

    private final Class<?> getClass(String internal) {
        int n = this.apiCount;
        this.apiCount = n + 1;
        String className = Type.getObjectType((String)internal).getClassName();
        Class<?> clazz = Class.forName(className, false, ((Object)((Object)this)).getClass().getClassLoader());
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"forName(...)");
        return clazz;
    }

    /*
     * WARNING - void declaration
     */
    private final Executable getMethod(String owner, String name, String descriptor) {
        Executable executable;
        Executable executable2;
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Class<?> clz = this.getClass(owner);
        Type[] typeArray = Type.getArgumentTypes((String)descriptor);
        Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"getArgumentTypes(...)");
        Object $this$map$iv = typeArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((Object[])$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void type;
            Type type2 = (Type)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)type);
            collection.add(LintJarVerifierKt.access$toTypeClass((Type)type));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Class[] argumentTypes = thisCollection$iv.toArray(new Class[0]);
        if (Intrinsics.areEqual((Object)name, (Object)"<init>")) {
            Constructor<?> constructor;
            try {
                constructor = clz.getDeclaredConstructor(Arrays.copyOf(argumentTypes, argumentTypes.length));
            }
            catch (Throwable e) {
                constructor = clz.getConstructor(Arrays.copyOf(argumentTypes, argumentTypes.length));
            }
            executable2 = constructor;
            Intrinsics.checkNotNull(executable2);
            executable = executable2;
        } else {
            Method method;
            try {
                method = clz.getDeclaredMethod(name, Arrays.copyOf(argumentTypes, argumentTypes.length));
            }
            catch (Throwable e) {
                method = clz.getMethod(name, Arrays.copyOf(argumentTypes, argumentTypes.length));
            }
            executable2 = method;
            Intrinsics.checkNotNull(executable2);
            executable = executable2;
        }
        return executable;
    }

    private final Field getField(String owner, String name) {
        Field field;
        Class<?> clz = this.getClass(owner);
        try {
            field = clz.getDeclaredField(name);
            Intrinsics.checkNotNull((Object)field);
        }
        catch (Throwable e) {
            Field field2 = clz.getField(name);
            Intrinsics.checkNotNull((Object)field2);
            field = field2;
        }
        return field;
    }

    public void visit(int version, int access, @NotNull String name, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
        String[] it;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.currentClass = name;
        this.currentSuperClass = superName;
        if (superName != null) {
            it = superName;
            boolean bl = false;
            this.checkClass((String)it);
        }
        if (interfaces != null) {
            it = interfaces;
            boolean bl = false;
            String[] $this$forEach$iv = it;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String internal = element$iv = $this$forEach$iv[i];
                boolean bl2 = false;
                this.checkClass(internal);
            }
        }
        super.visit(version, access, name, signature, (String)superName, interfaces);
    }

    @NotNull
    public MethodVisitor visitMethod(int access, @Nullable String name, @Nullable String descriptor, @Nullable String signature, @Nullable String[] exceptions) {
        return this.methodVisitor;
    }

    public static final /* synthetic */ void access$checkMethod(LintJarVerifier $this, String owner, String name, String descriptor) {
        $this.checkMethod(owner, name, descriptor);
    }

    public static final /* synthetic */ void access$checkField(LintJarVerifier $this, String owner, String name) {
        $this.checkField(owner, name);
    }
}

