/*
 * Copyright (C) 2011 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.android.resources;

/**
 * Resource constants.
 */
public class ResourceConstants {
    /** Default anim resource folder name, i.e. "anim". */
    public static final String FD_RES_ANIM = "anim";
    /** Default animator resource folder name, i.e. "animator". */
    public static final String FD_RES_ANIMATOR = "animator";
    /** Default color resource folder name, i.e. "color". */
    public static final String FD_RES_COLOR = "color";
    /** Default drawable resource folder name, i.e. "drawable". */
    public static final String FD_RES_DRAWABLE = "drawable";
    /** Default font resource folder name, i.e. "font". */
    public static final String FD_RES_FONT = "font";
    /** Default interpolator resource folder name, i.e. "interpolator". */
    public static final String FD_RES_INTERPOLATOR = "interpolator";
    /** Default layout resource folder name, i.e. "layout". */
    public static final String FD_RES_LAYOUT = "layout";
    /** Default menu resource folder name, i.e. "menu". */
    public static final String FD_RES_MENU = "menu";
    /** Default menu resource folder name, i.e. "mipmap". */
    public static final String FD_RES_MIPMAP = "mipmap";
    /** Default values resource folder name, i.e. "values". */
    public static final String FD_RES_VALUES = "values";
    /** Default xml resource folder name, i.e. "xml". */
    public static final String FD_RES_XML = "xml";
    /** Default raw resource folder name, i.e. "raw". */
    public static final String FD_RES_RAW = "raw";
    /** Default transition resource folder name, i.e. "transition". */
    public static final String FD_RES_TRANSITION = "transition";
    /** Default navigation resource folder name, i.e. "nav". */
    public static final String FD_NAVIGATION = "navigation";

    /** Separator between the resource folder qualifiers. */
    public static final char RES_QUALIFIER_SEP = '-';
}
