/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AdbHelper;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.InstallException;
import com.android.ddmlib.InstallReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.SplitApkInstallerBase;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class RemoteSplitApkInstaller
extends SplitApkInstallerBase {
    private static final String LOG_TAG = "RemoteSplitApkInstaller";
    private final List<String> mRemoteApkPaths;

    private RemoteSplitApkInstaller(IDevice device, List<String> remoteApks, String options) {
        super(device, options);
        this.mRemoteApkPaths = remoteApks;
    }

    public void install(long timeout, TimeUnit unit) throws InstallException {
        try {
            String sessionId = this.createMultiInstallSession(this.getOptions(), timeout, unit);
            boolean allWriteSucceeded = true;
            for (String apkPath : this.mRemoteApkPaths) {
                Log.d(LOG_TAG, String.format("Add apk %s to install session %s", apkPath, sessionId));
                allWriteSucceeded = this.writeRemoteApk(sessionId, apkPath, timeout, unit);
                if (allWriteSucceeded) continue;
                Log.e(LOG_TAG, String.format("Failed to write install session %s with %s", sessionId, apkPath));
                break;
            }
            if (!allWriteSucceeded) {
                this.installAbandon(sessionId, timeout, unit);
                throw new InstallException("Failed to install-write all apks");
            }
            this.installCommit(sessionId, timeout, unit);
            Log.d(LOG_TAG, "Successfully install apks: " + this.mRemoteApkPaths.toString());
        }
        catch (InstallException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InstallException(e);
        }
    }

    protected boolean writeRemoteApk(String sessionId, String filePath, long timeout, TimeUnit unit) {
        String baseName = filePath.lastIndexOf(47) != -1 ? filePath.substring(filePath.lastIndexOf(47), filePath.length()) : filePath;
        baseName = UNSAFE_PM_INSTALL_SESSION_SPLIT_NAME_CHARS.replaceFrom((CharSequence)baseName, '_');
        String command = String.format(this.getPrefix() + " install-write %s %s %s", sessionId, baseName, filePath);
        Log.d(LOG_TAG, String.format("Executing : %s", command));
        try {
            InstallReceiver receiver = new InstallReceiver();
            AdbHelper.executeRemoteCommand(AndroidDebugBridge.getSocketAddress(), this.getServiceWrite(), command, this.mDevice, receiver, 0L, timeout, unit, null);
            if (receiver.isSuccessfullyCompleted()) {
                Log.d(LOG_TAG, String.format("Successfully add %s to install session %s", filePath, sessionId));
            } else if (receiver.getErrorMessage() != null) {
                Log.e(LOG_TAG, String.format("Error install-write %s to session %s by command %s: %s", filePath, sessionId, command, receiver.getErrorMessage()));
            } else {
                Log.e(LOG_TAG, String.format("Failed to install-write session %s with %s by command %s", sessionId, filePath, command));
            }
            return receiver.isSuccessfullyCompleted();
        }
        catch (Exception e) {
            Log.e(LOG_TAG, String.format("%s failed with error %s", command, e));
            return false;
        }
    }

    private static void validateArguments(IDevice device, List<String> apks) {
        RemoteSplitApkInstaller.validateApiLevel(device);
        if (apks.isEmpty()) {
            throw new IllegalArgumentException("List of APKs is empty: the main APK must be specified.");
        }
    }

    public static RemoteSplitApkInstaller create(IDevice device, List<String> remoteApks, boolean reInstall, List<String> installOptions) {
        RemoteSplitApkInstaller.validateArguments(device, remoteApks);
        return new RemoteSplitApkInstaller(device, remoteApks, RemoteSplitApkInstaller.getOptions(reInstall, installOptions));
    }

    public static RemoteSplitApkInstaller create(IDevice device, String applicationId, List<String> remoteApks, boolean reInstall, List<String> installOptions) {
        RemoteSplitApkInstaller.validateArguments(device, remoteApks);
        return new RemoteSplitApkInstaller(device, remoteApks, RemoteSplitApkInstaller.getOptions(reInstall, true, applicationId, installOptions));
    }
}

