/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.utils.concurrency;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import shadow.bundletool.com.android.utils.JvmWideVariable;

public final class ReadWriteThreadLock {
    private final Lock readLock = new ReadLock();
    private final Lock writeLock = new WriteLock();
    private final Object lockObject;
    private final ReentrantReadWriteLock lock;

    public ReadWriteThreadLock(Object lockObject) {
        Class lockObjectClass = JvmWideVariable.getJvmWideObjectPerKey(ReadWriteThreadLock.class, "lockObjectClass", TypeToken.of(String.class), TypeToken.of(Class.class), lockObject.getClass().getName(), lockObject::getClass);
        Preconditions.checkArgument((lockObject.getClass() == lockObjectClass ? 1 : 0) != 0, (Object)String.format("Lock object's class %1$s must be loaded once but is loaded twice", lockObject.getClass().getName()));
        this.lockObject = lockObject;
        this.lock = JvmWideVariable.getJvmWideObjectPerKey(ReadWriteThreadLock.class, "lock", TypeToken.of(Object.class), TypeToken.of(ReentrantReadWriteLock.class), lockObject, ReentrantReadWriteLock::new);
    }

    public Lock readLock() {
        return this.readLock;
    }

    public Lock writeLock() {
        return this.writeLock;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("lockObject", this.lockObject).toString();
    }

    private final class WriteLock
    implements Lock {
        private WriteLock() {
        }

        @Override
        public void lock() {
            ReadWriteThreadLock.this.lock.writeLock().lock();
        }

        @Override
        public boolean tryLock(long timeout, TimeUnit timeUnit) {
            try {
                return ReadWriteThreadLock.this.lock.writeLock().tryLock(timeout, timeUnit);
            }
            catch (InterruptedException e5) {
                throw new RuntimeException(e5);
            }
        }

        @Override
        public void unlock() {
            ReadWriteThreadLock.this.lock.writeLock().unlock();
        }
    }

    private final class ReadLock
    implements Lock {
        private ReadLock() {
        }

        @Override
        public void lock() {
            ReadWriteThreadLock.this.lock.readLock().lock();
        }

        @Override
        public boolean tryLock(long timeout, TimeUnit timeUnit) {
            try {
                return ReadWriteThreadLock.this.lock.readLock().tryLock(timeout, timeUnit);
            }
            catch (InterruptedException e5) {
                throw new RuntimeException(e5);
            }
        }

        @Override
        public void unlock() {
            ReadWriteThreadLock.this.lock.readLock().unlock();
        }
    }

    public static interface Lock {
        public void lock();

        public boolean tryLock(long var1, TimeUnit var3);

        public void unlock();
    }
}

