/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.tools.build.bundletool.model.SdkBundle;
import com.android.tools.build.bundletool.validation.BundleFilesValidator;
import com.android.tools.build.bundletool.validation.BundleZipValidator;
import com.android.tools.build.bundletool.validation.DexFilesValidator;
import com.android.tools.build.bundletool.validation.MandatoryFilesPresenceValidator;
import com.android.tools.build.bundletool.validation.ResourceTableValidator;
import com.android.tools.build.bundletool.validation.SdkAndroidManifestValidator;
import com.android.tools.build.bundletool.validation.SdkBundleHasOneModuleValidator;
import com.android.tools.build.bundletool.validation.SdkBundleModuleNameValidator;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.android.tools.build.bundletool.validation.ValidatorRunner;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.zip.ZipFile;

public class SdkBundleValidator {
    @VisibleForTesting
    static final ImmutableList<SubValidator> DEFAULT_BUNDLE_FILE_SUB_VALIDATORS = ImmutableList.of((Object)new BundleZipValidator(), (Object)new MandatoryFilesPresenceValidator(SdkBundle.NON_MODULE_DIRECTORIES), (Object)new SdkBundleHasOneModuleValidator());
    @VisibleForTesting
    static final ImmutableList<SubValidator> DEFAULT_BUNDLE_SUB_VALIDATORS = ImmutableList.of((Object)new BundleFilesValidator(), (Object)new SdkBundleModuleNameValidator(), (Object)new DexFilesValidator(), (Object)new SdkAndroidManifestValidator(), (Object)new ResourceTableValidator());
    private final ImmutableList<SubValidator> allBundleFileSubValidators;
    private final ImmutableList<SubValidator> allBundleSubValidators;

    private SdkBundleValidator(ImmutableList<SubValidator> allBundleSubValidators, ImmutableList<SubValidator> allBundleFileSubValidators) {
        this.allBundleSubValidators = allBundleSubValidators;
        this.allBundleFileSubValidators = allBundleFileSubValidators;
    }

    public static SdkBundleValidator create() {
        return SdkBundleValidator.create((ImmutableList<SubValidator>)ImmutableList.of());
    }

    public static SdkBundleValidator create(ImmutableList<SubValidator> extraSubValidators) {
        return new SdkBundleValidator((ImmutableList<SubValidator>)ImmutableList.builder().addAll(DEFAULT_BUNDLE_SUB_VALIDATORS).addAll(extraSubValidators).build(), (ImmutableList<SubValidator>)ImmutableList.builder().addAll(DEFAULT_BUNDLE_FILE_SUB_VALIDATORS).addAll(extraSubValidators).build());
    }

    public void validateFile(ZipFile bundleFile) {
        new ValidatorRunner(this.allBundleFileSubValidators).validateBundleZipFile(bundleFile);
    }

    public void validate(SdkBundle bundle) {
        new ValidatorRunner(this.allBundleSubValidators).validateSdkBundle(bundle);
    }
}

