/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.transparency;

import com.android.tools.build.bundletool.commands.CheckTransparencyCommand;
import com.android.tools.build.bundletool.device.AdbRunner;
import com.android.tools.build.bundletool.device.AdbServer;
import com.android.tools.build.bundletool.device.AdbShellCommandTask;
import com.android.tools.build.bundletool.device.Device;
import com.android.tools.build.bundletool.device.DeviceAnalyzer;
import com.android.tools.build.bundletool.io.TempDirectory;
import com.android.tools.build.bundletool.model.exceptions.InvalidCommandException;
import com.android.tools.build.bundletool.transparency.ApkTransparencyCheckUtils;
import com.android.tools.build.bundletool.transparency.TransparencyCheckResult;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.concurrent.TimeoutException;

public final class ConnectedDeviceModeTransparencyChecker {
    private static final String APK_PATH_ON_DEVICE_PREFIX = "package:/";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TransparencyCheckResult checkTransparency(CheckTransparencyCommand command) {
        command.getAdbServer().get().init(command.getAdbPath().get());
        AdbRunner adbRunner = new AdbRunner(command.getAdbServer().get());
        Device adbDevice = ConnectedDeviceModeTransparencyChecker.getDevice(command.getAdbServer().get(), command.getDeviceId());
        AdbShellCommandTask adbShellCommandTask = new AdbShellCommandTask(adbDevice, "pm path " + command.getPackageName().get());
        ImmutableList pathsToApksOnDevice = (ImmutableList)adbShellCommandTask.execute().stream().filter(path -> path.startsWith(APK_PATH_ON_DEVICE_PREFIX)).map(path -> path.substring(APK_PATH_ON_DEVICE_PREFIX.length())).collect(ImmutableList.toImmutableList());
        if (pathsToApksOnDevice.isEmpty()) {
            throw InvalidCommandException.builder().withInternalMessage("No files found for package " + command.getPackageName().get()).build();
        }
        try (TempDirectory tempDir = new TempDirectory("connected-device-transparency-check");){
            Path apksExtractedSubDirectory = tempDir.getPath().resolve("extracted");
            Files.createDirectory(apksExtractedSubDirectory, new FileAttribute[0]);
            ImmutableList<Device.FilePullParams> pullParams = ConnectedDeviceModeTransparencyChecker.createPullParams((ImmutableList<String>)pathsToApksOnDevice, apksExtractedSubDirectory);
            if (command.getDeviceId().isPresent()) {
                adbRunner.run(device -> device.pull(pullParams), command.getDeviceId().get());
            } else {
                adbRunner.run(device -> device.pull(pullParams));
            }
            TransparencyCheckResult transparencyCheckResult = ApkTransparencyCheckUtils.checkTransparency((ImmutableList<Path>)((ImmutableList)pullParams.stream().map(Device.FilePullParams::getDestinationPath).collect(ImmutableList.toImmutableList())));
            return transparencyCheckResult;
        }
        catch (IOException e5) {
            throw new UncheckedIOException(e5);
        }
    }

    private static Device getDevice(AdbServer adbServer, Optional<String> deviceId) {
        Device device;
        DeviceAnalyzer deviceAnalyzer = new DeviceAnalyzer(adbServer);
        try {
            device = deviceAnalyzer.getAndValidateDevice(deviceId);
        }
        catch (TimeoutException e5) {
            throw new UncheckedTimeoutException((Throwable)e5);
        }
        return device;
    }

    private static ImmutableList<Device.FilePullParams> createPullParams(ImmutableList<String> pathsToApksOnDevice, Path apksExtractedSubDirectory) {
        return (ImmutableList)pathsToApksOnDevice.stream().map(pathOnDevice -> Device.FilePullParams.builder().setPathOnDevice((String)pathOnDevice).setDestinationPath(apksExtractedSubDirectory.resolve(Paths.get(pathOnDevice, new String[0]).getFileName())).build()).collect(ImmutableList.toImmutableList());
    }

    private ConnectedDeviceModeTransparencyChecker() {
    }
}

