/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.aapt.Resources;
import com.android.tools.build.bundletool.model.AutoValue_AndroidManifest;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ManifestDeliveryElement;
import com.android.tools.build.bundletool.model.ManifestEditor;
import com.android.tools.build.bundletool.model.ManifestMutator;
import com.android.tools.build.bundletool.model.ModuleDeliveryType;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoAttribute;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoElement;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoElementBuilder;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoNode;
import com.android.tools.build.bundletool.model.version.BundleToolVersion;
import com.android.tools.build.bundletool.model.version.Version;
import com.android.tools.build.bundletool.model.version.VersionGuardedFeature;
import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import com.google.common.collect.Streams;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

@Immutable
@AutoValue
@AutoValue.CopyAnnotations
public abstract class AndroidManifest {
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',');
    public static final String ANDROID_NAMESPACE_URI = "http://schemas.android.com/apk/res/android";
    public static final String DISTRIBUTION_NAMESPACE_URI = "http://schemas.android.com/apk/distribution";
    public static final String NO_NAMESPACE_URI = "";
    public static final String APPLICATION_ELEMENT_NAME = "application";
    public static final String META_DATA_ELEMENT_NAME = "meta-data";
    public static final String USES_SDK_ELEMENT_NAME = "uses-sdk";
    public static final String ACTIVITY_ELEMENT_NAME = "activity";
    public static final String ACTIVITY_ALIAS_ELEMENT_NAME = "activity-alias";
    public static final String INTENT_FILTER_ELEMENT_NAME = "intent-filder";
    public static final String SERVICE_ELEMENT_NAME = "service";
    public static final String RECEIVER_ELEMENT_NAME = "receiver";
    public static final String PROVIDER_ELEMENT_NAME = "provider";
    public static final String SUPPORTS_GL_TEXTURE_ELEMENT_NAME = "supports-gl-texture";
    public static final String ACTION_ELEMENT_NAME = "action";
    public static final String PERMISSION_ELEMENT_NAME = "permission";
    public static final String PERMISSION_GROUP_ELEMENT_NAME = "permission-group";
    public static final String PERMISSION_TREE_ELEMENT_NAME = "permission-tree";
    public static final String DEBUGGABLE_ATTRIBUTE_NAME = "debuggable";
    public static final String EXTRACT_NATIVE_LIBS_ATTRIBUTE_NAME = "extractNativeLibs";
    public static final String ICON_ATTRIBUTE_NAME = "icon";
    public static final String MAX_SDK_VERSION_ATTRIBUTE_NAME = "maxSdkVersion";
    public static final String MIN_SDK_VERSION_ATTRIBUTE_NAME = "minSdkVersion";
    public static final String TARGET_SDK_VERSION_ATTRIBUTE_NAME = "targetSdkVersion";
    public static final String NAME_ATTRIBUTE_NAME = "name";
    public static final String VALUE_ATTRIBUTE_NAME = "value";
    public static final String CODE_ATTRIBUTE_NAME = "code";
    public static final String EXCLUDE_ATTRIBUTE_NAME = "exclude";
    public static final String THEME_ATTRIBUTE_NAME = "theme";
    public static final String COUNTRY_ELEMENT_NAME = "country";
    public static final String CONDITION_DEVICE_FEATURE_NAME = "device-feature";
    public static final String CONDITION_MIN_SDK_VERSION_NAME = "min-sdk";
    public static final String CONDITION_MAX_SDK_VERSION_NAME = "max-sdk";
    public static final String CONDITION_USER_COUNTRIES_NAME = "user-countries";
    public static final String CONDITION_DEVICE_GROUPS_NAME = "device-groups";
    public static final String DEVICE_GROUP_ELEMENT_NAME = "device-group";
    public static final String SPLIT_NAME_ATTRIBUTE_NAME = "splitName";
    public static final String VERSION_NAME_ATTRIBUTE_NAME = "versionName";
    public static final String INSTALL_LOCATION_ATTRIBUTE_NAME = "installLocation";
    public static final String IS_SPLIT_REQUIRED_ATTRIBUTE_NAME = "isSplitRequired";
    public static final String SHARED_USER_ID_ATTRIBUTE_NAME = "sharedUserId";
    public static final String SHARED_USER_LABEL_ATTRIBUTE_NAME = "sharedUserLabel";
    public static final String DESCRIPTION_ATTRIBUTE_NAME = "description";
    public static final String HAS_FRAGILE_USER_DATA_ATTRIBUTE_NAME = "hasFragileUserData";
    public static final String IS_GAME_ATTRIBUTE_NAME = "isGame";
    public static final String LABEL_ATTRIBUTE_NAME = "label";
    public static final String ALLOW_BACKUP_ATTRIBUTE_NAME = "allowBackup";
    public static final String FULL_BACKUP_CONTENT_ATTRIBUTE_NAME = "fullBackupContent";
    public static final String FULL_BACKUP_ONLY_ATTRIBUTE_NAME = "fullBackupOnly";
    public static final String BACKUP_AGENT_ATTRIBUTE_NAME = "backupAgent";
    public static final String DATA_EXTRACTION_RULES_ATTRIBUTE_NAME = "dataExtractionRules";
    public static final String EXPORTED_ATTRIBUTE_NAME = "exported";
    public static final String LOCALE_CONFIG_ATTRIBUTE_NAME = "localeConfig";
    public static final String SDK_LIBRARY_ELEMENT_NAME = "sdk-library";
    public static final String SDK_MAJOR_VERSION_ATTRIBUTE_NAME = "versionMajor";
    public static final String SDK_PATCH_VERSION_ATTRIBUTE_NAME = "shadow.bundletool.com.android.vending.sdkPatchVersion";
    public static final Integer SDK_SANDBOX_MIN_VERSION = 32;
    public static final String MODULE_TYPE_FEATURE_VALUE = "feature";
    public static final String MODULE_TYPE_ASSET_VALUE = "asset-pack";
    public static final String MODULE_TYPE_ML_VALUE = "ml-pack";
    public static final String NATIVE_ACTIVITY_LIB_NAME = "android.app.lib_name";
    public static final int DEBUGGABLE_RESOURCE_ID = 0x101000F;
    public static final int EXTRACT_NATIVE_LIBS_RESOURCE_ID = 16844010;
    public static final int HAS_CODE_RESOURCE_ID = 0x101000C;
    public static final int ICON_RESOURCE_ID = 0x1010002;
    public static final int MAX_SDK_VERSION_RESOURCE_ID = 16843377;
    public static final int MIN_SDK_VERSION_RESOURCE_ID = 16843276;
    public static final int TARGET_SDK_VERSION_RESOURCE_ID = 16843376;
    public static final int NAME_RESOURCE_ID = 0x1010003;
    public static final int VALUE_RESOURCE_ID = 16842788;
    public static final int RESOURCE_RESOURCE_ID = 16842789;
    public static final int VERSION_CODE_RESOURCE_ID = 16843291;
    public static final int VERSION_CODE_MAJOR_RESOURCE_ID = 16844150;
    public static final int VERSION_NAME_RESOURCE_ID = 16843292;
    public static final int IS_FEATURE_SPLIT_RESOURCE_ID = 16844123;
    public static final int TARGET_SANDBOX_VERSION_RESOURCE_ID = 16844108;
    public static final int SPLIT_NAME_RESOURCE_ID = 16844105;
    public static final int INSTALL_LOCATION_RESOURCE_ID = 16843447;
    public static final int IS_SPLIT_REQUIRED_RESOURCE_ID = 16844177;
    public static final int THEME_RESOURCE_ID = 0x1010000;
    public static final int ISOLATED_SPLITS_ID = 16844107;
    public static final int SHARED_USER_ID_RESOURCE_ID = 0x101000B;
    public static final int SHARED_USER_LABEL_RESOURCE_ID = 16843361;
    public static final int DESCRIPTION_RESOURCE_ID = 0x1010020;
    public static final int HAS_FRAGILE_USER_DATA_RESOURCE_ID = 16844186;
    public static final int IS_GAME_RESOURCE_ID = 16843764;
    public static final int LABEL_RESOURCE_ID = 0x1010001;
    public static final int ALLOW_BACKUP_RESOURCE_ID = 16843392;
    public static final int FULL_BACKUP_CONTENT_RESOURCE_ID = 16844011;
    public static final int FULL_BACKUP_ONLY_RESOURCE_ID = 16843891;
    public static final int BACKUP_AGENT_RESOURCE_ID = 16843391;
    public static final int DATA_EXTRACTION_RULES_RESOURCE_ID = 16844350;
    public static final int EXPORTED_RESOURCE_ID = 0x1010010;
    public static final int LOCALE_CONFIG_RESOURCE_ID = 31391753;
    public static final int DEVELOPMENT_SDK_VERSION = 10000;
    public static final String META_DATA_KEY_FUSED_MODULE_NAMES = "com.android.dynamic.apk.fused.modules";
    public static final String META_DATA_KEY_SPLITS_REQUIRED = "com.android.vending.splits.required";

    public abstract XmlProtoNode getManifestRoot();

    abstract Version getBundleToolVersion();

    XmlProtoElement getManifestElement() {
        return (XmlProtoElement)this.getManifestRoot().getElement();
    }

    public Optional<ManifestDeliveryElement> getManifestDeliveryElement() {
        return ManifestDeliveryElement.fromManifestElement(this.getManifestElement(), this.getModuleType().equals((Object)BundleModule.ModuleType.ASSET_MODULE));
    }

    public Optional<ManifestDeliveryElement> getInstantManifestDeliveryElement() {
        return ManifestDeliveryElement.instantFromManifestElement(this.getManifestElement(), this.getModuleType().equals((Object)BundleModule.ModuleType.ASSET_MODULE));
    }

    public static AndroidManifest create(XmlProtoNode manifestRoot, Version bundleToolVersion) {
        return new AutoValue_AndroidManifest(manifestRoot, bundleToolVersion);
    }

    public static AndroidManifest create(Resources.XmlNode manifestRoot, Version bundleToolVersion) {
        return AndroidManifest.create(new XmlProtoNode(manifestRoot), bundleToolVersion);
    }

    @VisibleForTesting
    public static AndroidManifest create(Resources.XmlNode manifestRoot) {
        return AndroidManifest.create(manifestRoot, BundleToolVersion.getCurrentVersion());
    }

    public static AndroidManifest createForConfigSplit(String packageName, Optional<Integer> versionCode, String splitId, String featureSplitId, Optional<Boolean> extractNativeLibs) {
        Preconditions.checkNotNull((Object)splitId);
        Preconditions.checkArgument((!splitId.isEmpty() ? 1 : 0) != 0, (Object)"Split Id cannot be empty for config split.");
        Preconditions.checkNotNull((Object)featureSplitId);
        Preconditions.checkNotNull((Object)packageName);
        ManifestEditor editor = new ManifestEditor(AndroidManifest.createMinimalManifestTag(), BundleToolVersion.getCurrentVersion()).setPackage(packageName).setSplitId(splitId).setHasCode(false);
        if (!featureSplitId.isEmpty()) {
            editor.setConfigForSplit(featureSplitId);
        }
        versionCode.ifPresent(editor::setVersionCode);
        extractNativeLibs.ifPresent(editor::setExtractNativeLibsValue);
        return editor.save();
    }

    private static XmlProtoNode createMinimalManifestTag() {
        return XmlProtoNode.createElementNode(XmlProtoElementBuilder.create("manifest").addNamespaceDeclaration("android", ANDROID_NAMESPACE_URI).build());
    }

    public boolean getEffectiveApplicationDebuggable() {
        return this.getApplicationDebuggable().orElse(false);
    }

    @CheckReturnValue
    public AndroidManifest applyMutators(ImmutableList<ManifestMutator> manifestMutators) {
        ManifestEditor manifestEditor = this.toEditor();
        for (ManifestMutator manifestMutator : manifestMutators) {
            manifestMutator.accept(manifestEditor);
        }
        return manifestEditor.save();
    }

    public Optional<Boolean> getApplicationDebuggable() {
        return this.getApplicationAttributeAsBoolean(0x101000F);
    }

    public ImmutableMap<String, XmlProtoElement> getActivitiesByName() {
        return (ImmutableMap)Streams.stream(this.getManifestElement().getOptionalChildElement(APPLICATION_ELEMENT_NAME)).flatMap(app -> app.getChildrenElements(ACTIVITY_ELEMENT_NAME)).filter(activity -> activity.getAndroidAttribute(0x1010003).isPresent()).collect(ImmutableMap.toImmutableMap(activity -> ((XmlProtoAttribute)activity.getAndroidAttribute(0x1010003).get()).getValueAsString(), Function.identity()));
    }

    public Optional<Integer> getMinSdkVersion() {
        return this.getUsesSdkAttribute(16843276);
    }

    public int getEffectiveMinSdkVersion() {
        return this.getMinSdkVersion().orElse(1);
    }

    public Optional<Integer> getMaxSdkVersion() {
        return this.getUsesSdkAttribute(16843377);
    }

    public Optional<Integer> getTargetSdkVersion() {
        return this.getUsesSdkAttribute(16843376);
    }

    public Range<Integer> getSdkRange() {
        Optional<Integer> maxSdkVersion = this.getMaxSdkVersion();
        if (maxSdkVersion.isPresent()) {
            return Range.closed((Comparable)Integer.valueOf(this.getEffectiveMinSdkVersion()), (Comparable)maxSdkVersion.get());
        }
        return Range.atLeast((Comparable)Integer.valueOf(this.getEffectiveMinSdkVersion()));
    }

    public Optional<Integer> getTargetSandboxVersion() {
        return this.getManifestElement().getAndroidAttribute(16844108).map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsDecimalInteger());
    }

    private Optional<Integer> getUsesSdkAttribute(int attributeResId) {
        return this.getManifestElement().getOptionalChildElement(USES_SDK_ELEMENT_NAME).flatMap(usesSdk -> usesSdk.getAndroidAttribute(attributeResId)).map(attribute -> AndroidManifest.isSdkCodename(attribute.getValueAsString()) ? 10000 : attribute.getValueAsDecimalInteger());
    }

    public ImmutableList<String> getSupportsGlTextures() {
        return (ImmutableList)this.getManifestElement().getChildrenElements(SUPPORTS_GL_TEXTURE_ELEMENT_NAME).map(supportsGlTextures -> (XmlProtoAttribute)supportsGlTextures.getAndroidAttribute(0x1010003).orElseThrow(() -> InvalidBundleException.createWithUserMessage("<supports-gl-texture> element is missing the 'android:name' attribute."))).map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsString()).collect(ImmutableList.toImmutableList());
    }

    private static boolean isSdkCodename(String sdkVersion) {
        if (sdkVersion.isEmpty()) {
            return false;
        }
        int dotIndex = sdkVersion.indexOf(46);
        String codename = dotIndex != -1 ? sdkVersion.substring(0, dotIndex) : sdkVersion;
        return Ints.tryParse((String)codename) == null;
    }

    public boolean hasApplicationElement() {
        return this.getManifestElement().getOptionalChildElement(APPLICATION_ELEMENT_NAME).isPresent();
    }

    public Optional<Boolean> getHasCode() {
        return this.getApplicationAttributeAsBoolean(0x101000C);
    }

    public boolean getEffectiveHasCode() {
        return this.getHasCode().orElse(true);
    }

    public Optional<Boolean> getIsFeatureSplit() {
        return this.getManifestElement().getAndroidAttribute(16844123).map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsBoolean());
    }

    private static BundleModule.ModuleType getModuleTypeFromAttributeValue(String value) {
        switch (value) {
            case "feature": {
                return BundleModule.ModuleType.FEATURE_MODULE;
            }
            case "asset-pack": {
                return BundleModule.ModuleType.ASSET_MODULE;
            }
            case "ml-pack": {
                return BundleModule.ModuleType.ML_MODULE;
            }
        }
        throw InvalidBundleException.builder().withUserMessage("Found invalid type attribute %s for <module> element.", value).build();
    }

    public Optional<BundleModule.ModuleType> getOptionalModuleType() {
        Optional<String> typeAttributeValue = this.getManifestElement().getOptionalChildElement(DISTRIBUTION_NAMESPACE_URI, "module").flatMap(module -> module.getAttribute(DISTRIBUTION_NAMESPACE_URI, "type")).map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsString());
        return typeAttributeValue.map(AndroidManifest::getModuleTypeFromAttributeValue);
    }

    public BundleModule.ModuleType getModuleType() {
        return this.getOptionalModuleType().orElse(BundleModule.ModuleType.FEATURE_MODULE);
    }

    public Optional<Boolean> getIsModuleIncludedInFusing() {
        return this.getManifestElement().getOptionalChildElement(DISTRIBUTION_NAMESPACE_URI, "module").flatMap(module -> module.getOptionalChildElement(DISTRIBUTION_NAMESPACE_URI, "fusing")).map(fusing -> {
            if (VersionGuardedFeature.NAMESPACE_ON_INCLUDE_ATTRIBUTE_REQUIRED.enabledForVersion(this.getBundleToolVersion())) {
                return (XmlProtoAttribute)fusing.getAttribute(DISTRIBUTION_NAMESPACE_URI, "include").orElseThrow(this::createFusingMissingIncludeAttributeException);
            }
            return (XmlProtoAttribute)fusing.getAttributeIgnoringNamespace("include").orElseThrow(this::createFusingMissingIncludeAttributeException);
        }).map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsBoolean());
    }

    public Optional<String> getConfigForSplit() {
        return this.getManifestElement().getAttribute("configForSplit").map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsString());
    }

    public String getPackageName() {
        return ((XmlProtoAttribute)this.getManifestElement().getAttribute("package").orElseThrow(() -> InvalidBundleException.createWithUserMessage("Package name not found in the manifest."))).getValueAsString();
    }

    public Optional<Integer> getVersionCode() {
        return this.getManifestElement().getAndroidAttribute(16843291).map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsDecimalInteger());
    }

    public Optional<String> getVersionName() {
        return this.getManifestElement().getAndroidAttribute(16843292).map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsString());
    }

    public Optional<Boolean> getIsolatedSplits() {
        return this.getManifestElement().getAndroidAttribute(16844107).map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsBoolean());
    }

    public Optional<String> getSplitId() {
        return this.getManifestElement().getAttribute("split").map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsString());
    }

    public Optional<Integer> getTitleRefId() {
        return this.getManifestElement().getOptionalChildElement(DISTRIBUTION_NAMESPACE_URI, "module").flatMap(module -> module.getAttribute(DISTRIBUTION_NAMESPACE_URI, "title")).map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsRefId());
    }

    public ImmutableList<String> getUsesSplits() {
        return (ImmutableList)this.getManifestElement().getChildrenElements("uses-split").map(usesSplit -> (XmlProtoAttribute)usesSplit.getAndroidAttribute(0x1010003).orElseThrow(() -> InvalidBundleException.createWithUserMessage("<uses-split> element is missing the 'android:name' attribute."))).map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsString()).collect(ImmutableList.toImmutableList());
    }

    public Optional<XmlProtoAttribute> getOnDemandAttribute() {
        return this.getManifestElement().getOptionalChildElement(DISTRIBUTION_NAMESPACE_URI, "module").flatMap(module -> {
            if (VersionGuardedFeature.NAMESPACE_ON_INCLUDE_ATTRIBUTE_REQUIRED.enabledForVersion(this.getBundleToolVersion())) {
                return module.getAttribute(DISTRIBUTION_NAMESPACE_URI, "onDemand");
            }
            return module.getAttributeIgnoringNamespace("onDemand");
        });
    }

    public Optional<String> getSharedUserId() {
        return this.getManifestElement().getAndroidAttribute(0x101000B).map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsString());
    }

    public Optional<Integer> getSharedUserLabel() {
        return this.getManifestElement().getAndroidAttribute(16843361).map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsRefId());
    }

    public boolean isDeliveryTypeDeclared() {
        if (this.getManifestDeliveryElement().isPresent()) {
            return this.getManifestDeliveryElement().get().isWellFormed();
        }
        return this.getOnDemandAttribute().isPresent();
    }

    public Optional<Boolean> isInstantModule() {
        if (this.getInstantManifestDeliveryElement().isPresent()) {
            if (!this.getModuleType().equals((Object)BundleModule.ModuleType.ASSET_MODULE)) {
                throw InvalidBundleException.builder().withUserMessage("Instant-delivery element is only supported for asset packs.").build();
            }
            return this.getInstantManifestDeliveryElement().map(ManifestDeliveryElement::isWellFormed);
        }
        return this.getInstantAttribute();
    }

    public Optional<Boolean> getInstantAttribute() {
        return this.getManifestElement().getOptionalChildElement(DISTRIBUTION_NAMESPACE_URI, "module").flatMap(module -> module.getAttribute(DISTRIBUTION_NAMESPACE_URI, "instant")).map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsBoolean());
    }

    public Optional<Boolean> getExtractNativeLibsValue() {
        return this.getApplicationAttributeAsBoolean(16844010);
    }

    public Optional<String> getInstallLocationValue() {
        return this.getManifestElement().getAndroidAttribute(16843447).map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsString());
    }

    public boolean hasExplicitlyDefinedNativeActivities() {
        return Streams.stream(this.getManifestElement().getOptionalChildElement(APPLICATION_ELEMENT_NAME)).flatMap(app -> app.getChildrenElements(ACTIVITY_ELEMENT_NAME)).flatMap(activity -> activity.getChildrenElements(META_DATA_ELEMENT_NAME)).anyMatch(meta -> meta.getAndroidAttribute(0x1010003).filter(name -> NATIVE_ACTIVITY_LIB_NAME.equals(name.getValueAsString())).isPresent());
    }

    public Optional<Integer> getDescription() {
        return this.getApplicationAttributeAsRefId(0x1010020);
    }

    public Optional<Boolean> getHasFragileUserData() {
        return this.getApplicationAttributeAsBoolean(16844186);
    }

    public Optional<Boolean> getIsGame() {
        return this.getApplicationAttributeAsBoolean(16843764);
    }

    public boolean hasLabelString() {
        return this.hasApplicationAttributeAsString(0x1010001);
    }

    public boolean hasLabelRefId() {
        return this.hasApplicationAttributeAsRefId(0x1010001);
    }

    public boolean hasLocaleConfig() {
        return this.getManifestElement().getOptionalChildElement(APPLICATION_ELEMENT_NAME).flatMap(app -> app.getAndroidAttribute(31391753)).isPresent();
    }

    public Optional<String> getLabelString() {
        return this.getApplicationAttribute(0x1010001);
    }

    public Optional<Integer> getLabelRefId() {
        return this.getApplicationAttributeAsRefId(0x1010001);
    }

    public Optional<Integer> getIcon() {
        return this.getApplicationAttributeAsRefId(0x1010002);
    }

    public Optional<Boolean> getAllowBackup() {
        return this.getApplicationAttributeAsBoolean(16843392);
    }

    public Optional<Integer> getFullBackupContent() {
        return this.getApplicationAttributeAsRefId(16844011);
    }

    public Optional<Integer> getDataExtractionRules() {
        return this.getApplicationAttributeAsRefId(16844350);
    }

    public Optional<Boolean> getFullBackupOnly() {
        return this.getApplicationAttributeAsBoolean(16843891);
    }

    public boolean hasBackupAgent() {
        return this.hasApplicationAttributeAsString(16843391);
    }

    public ImmutableList<String> getFusedModuleNames() {
        return this.getMetadataValue(META_DATA_KEY_FUSED_MODULE_NAMES).map(rawValue -> ImmutableList.copyOf((Iterable)COMMA_SPLITTER.split((CharSequence)rawValue))).orElse(ImmutableList.of());
    }

    public Optional<String> getMetadataValue(String metadataName) {
        return this.getMetadataAttributeWithName(metadataName).map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsString());
    }

    public Optional<Integer> getMetadataValueAsInteger(String metadataName) {
        return this.getMetadataAttributeWithName(metadataName).map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsDecimalInteger());
    }

    public Optional<Boolean> getMetadataValueAsBoolean(String metadataName) {
        return this.getMetadataAttributeWithName(metadataName).map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsBoolean());
    }

    private Optional<XmlProtoAttribute> getMetadataAttributeWithName(String metadataName) {
        return this.getMetadataElement(metadataName).map(metadataElement -> (XmlProtoAttribute)metadataElement.getAndroidAttribute(16842788).orElseThrow(() -> InvalidBundleException.builder().withUserMessage("Missing expected attribute 'android:value' for <meta-data> element '%s'.", metadataName).build()));
    }

    public Optional<Integer> getMetadataResourceId(String metadataName) {
        return this.getMetadataElement(metadataName).map(metadataElement -> (XmlProtoAttribute)metadataElement.getAndroidAttribute(16842789).orElseThrow(() -> InvalidBundleException.builder().withUserMessage("Missing expected attribute 'android:resource' for <meta-data> element '%s'.", metadataName).build())).map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsRefId());
    }

    private Optional<XmlProtoElement> getMetadataElement(String name) {
        ImmutableList metadataElements = (ImmutableList)this.getMetadataElements().filter(metadataElement -> metadataElement.getAndroidAttribute(0x1010003).map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsString()).orElse(NO_NAMESPACE_URI).equals(name)).collect(ImmutableList.toImmutableList());
        switch (metadataElements.size()) {
            case 0: {
                return Optional.empty();
            }
            case 1: {
                return Optional.of(metadataElements.get(0));
            }
        }
        throw InvalidBundleException.builder().withUserMessage("Found multiple <meta-data> elements for key '%s', expected at most one.", name).build();
    }

    public ModuleDeliveryType getModuleDeliveryType() {
        if (this.getManifestDeliveryElement().isPresent()) {
            ManifestDeliveryElement manifestDeliveryElement = this.getManifestDeliveryElement().get();
            if (manifestDeliveryElement.hasInstallTimeElement()) {
                return manifestDeliveryElement.hasModuleConditions() ? ModuleDeliveryType.CONDITIONAL_INITIAL_INSTALL : ModuleDeliveryType.ALWAYS_INITIAL_INSTALL;
            }
            return ModuleDeliveryType.NO_INITIAL_INSTALL;
        }
        if (this.getOnDemandAttribute().map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsBoolean()).orElse(false).booleanValue()) {
            return ModuleDeliveryType.NO_INITIAL_INSTALL;
        }
        return ModuleDeliveryType.ALWAYS_INITIAL_INSTALL;
    }

    public ModuleDeliveryType getInstantModuleDeliveryType() {
        if (this.getInstantManifestDeliveryElement().isPresent()) {
            ManifestDeliveryElement instantManifestDeliveryElement = this.getInstantManifestDeliveryElement().get();
            if (instantManifestDeliveryElement.hasInstallTimeElement()) {
                return instantManifestDeliveryElement.hasModuleConditions() ? ModuleDeliveryType.CONDITIONAL_INITIAL_INSTALL : ModuleDeliveryType.ALWAYS_INITIAL_INSTALL;
            }
            return ModuleDeliveryType.NO_INITIAL_INSTALL;
        }
        return ModuleDeliveryType.NO_INITIAL_INSTALL;
    }

    public ImmutableList<XmlProtoElement> getPermissions() {
        return (ImmutableList)this.getManifestElement().getChildrenElements(PERMISSION_ELEMENT_NAME).collect(ImmutableList.toImmutableList());
    }

    public ImmutableList<XmlProtoElement> getPermissionGroups() {
        return (ImmutableList)this.getManifestElement().getChildrenElements(PERMISSION_GROUP_ELEMENT_NAME).collect(ImmutableList.toImmutableList());
    }

    public ImmutableList<XmlProtoElement> getPermissionTrees() {
        return (ImmutableList)this.getManifestElement().getChildrenElements(PERMISSION_TREE_ELEMENT_NAME).collect(ImmutableList.toImmutableList());
    }

    private Stream<XmlProtoElement> getMetadataElements() {
        return this.getManifestElement().getOptionalChildElement(APPLICATION_ELEMENT_NAME).map(applicationElement -> applicationElement.getChildrenElements(META_DATA_ELEMENT_NAME)).orElse(Stream.of(new XmlProtoElement[0]));
    }

    private InvalidBundleException createFusingMissingIncludeAttributeException() {
        return InvalidBundleException.builder().withUserMessage("<fusing> element is missing the 'include' attribute%s.", this.getSplitId().map(id -> " (split: '" + id + "')").orElse("base")).build();
    }

    public ManifestEditor toEditor() {
        return new ManifestEditor(this.getManifestRoot(), this.getBundleToolVersion());
    }

    public boolean hasSharedUserId() {
        return this.getManifestElement().getAttribute(ANDROID_NAMESPACE_URI, SHARED_USER_ID_ATTRIBUTE_NAME).isPresent();
    }

    private Optional<String> getApplicationAttribute(int resourceId) {
        return this.getManifestElement().getOptionalChildElement(APPLICATION_ELEMENT_NAME).flatMap(app -> app.getAndroidAttribute(resourceId)).map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsString());
    }

    private Optional<Boolean> getApplicationAttributeAsBoolean(int resourceId) {
        return this.getManifestElement().getOptionalChildElement(APPLICATION_ELEMENT_NAME).flatMap(app -> app.getAndroidAttribute(resourceId)).map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsBoolean());
    }

    private Optional<Integer> getApplicationAttributeAsRefId(int resourceId) {
        return this.getManifestElement().getOptionalChildElement(APPLICATION_ELEMENT_NAME).flatMap(app -> app.getAndroidAttribute(resourceId)).map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsRefId());
    }

    private boolean hasApplicationAttributeAsString(int resourceId) {
        return this.getManifestElement().getOptionalChildElement(APPLICATION_ELEMENT_NAME).flatMap(app -> app.getAndroidAttribute(resourceId)).map(rec$ -> ((XmlProtoAttribute)rec$).hasStringValue()).orElse(false);
    }

    public ImmutableList<XmlProtoElement> getSdkLibraryElements() {
        return (ImmutableList)((XmlProtoElement)((XmlProtoElement)this.getManifestRoot().getElement()).getChildElement(APPLICATION_ELEMENT_NAME)).getChildrenElements().filter(elem -> elem.getName().equals(SDK_LIBRARY_ELEMENT_NAME)).collect(ImmutableList.toImmutableList());
    }

    private boolean hasApplicationAttributeAsRefId(int resourceId) {
        return this.getManifestElement().getOptionalChildElement(APPLICATION_ELEMENT_NAME).flatMap(app -> app.getAndroidAttribute(resourceId)).map(rec$ -> ((XmlProtoAttribute)rec$).hasRefIdValue()).orElse(false);
    }

    public boolean hasComponents() {
        ImmutableSet componentNames = ImmutableSet.of((Object)ACTIVITY_ELEMENT_NAME, (Object)SERVICE_ELEMENT_NAME, (Object)PROVIDER_ELEMENT_NAME, (Object)RECEIVER_ELEMENT_NAME);
        return Streams.stream(this.getManifestElement().getOptionalChildElement(APPLICATION_ELEMENT_NAME)).flatMap(app -> app.getChildrenElements()).anyMatch(component -> componentNames.contains((Object)component.getName()));
    }
}

