/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.tools.build.bundletool.io.TempDirectory;
import com.android.tools.build.bundletool.io.ZipReader;
import com.android.tools.build.bundletool.model.CompressionLevel;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.utils.SystemEnvironmentProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.google.errorprone.annotations.MustBeClosed;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.Deflater;
import java.util.zip.DeflaterInputStream;
import shadow.bundletool.com.android.zipflinger.Entry;
import shadow.bundletool.com.android.zipflinger.Location;
import shadow.bundletool.com.android.zipflinger.Source;
import shadow.bundletool.com.android.zipflinger.ZipWriter;

public final class ZipEntrySource
extends Source {
    @VisibleForTesting
    static final int STORE_ON_DISK_THRESHOLD_BYTES = SystemEnvironmentProvider.DEFAULT_PROVIDER.getProperty("bundletool.compression.ondisk.entrysize").map(Integer::parseInt).orElse(0x100000);
    private final Entry entry;
    private final Payload payload;
    private final CompressionLevel compressionLevel;

    private ZipEntrySource(Entry entry, ZipPath newEntryName, Payload payload, CompressionLevel compressionLevel) {
        super(newEntryName.toString());
        this.entry = (Entry)Preconditions.checkNotNull((Object)entry);
        this.payload = (Payload)Preconditions.checkNotNull((Object)payload);
        this.crc = entry.getCrc();
        this.uncompressedSize = entry.getUncompressedSize();
        this.compressedSize = payload.size();
        this.compressionLevel = compressionLevel;
        this.compressionFlag = (short)(compressionLevel.isCompressed() || compressionLevel.equals((Object)CompressionLevel.SAME_AS_SOURCE) && entry.isCompressed() ? 8 : 0);
    }

    public static ZipEntrySource create(ZipReader zipReader, Entry entry, CompressionLevel compressionLevel, TempDirectory tempDirectory) throws IOException {
        return ZipEntrySource.create(zipReader, entry, ZipPath.create(entry.getName()), compressionLevel, tempDirectory);
    }

    public static ZipEntrySource create(ZipReader zipReader, Entry entry, ZipPath newEntryName, CompressionLevel compressionLevel, TempDirectory tempDirectory) throws IOException {
        Payload payload = ZipEntrySource.buildPayload(zipReader, entry, compressionLevel, tempDirectory);
        return new ZipEntrySource(entry, newEntryName, payload, compressionLevel);
    }

    private static Payload buildPayload(ZipReader zipReader, Entry entry, CompressionLevel compressionLevel, TempDirectory tempDirectory) throws IOException {
        switch (compressionLevel) {
            case SAME_AS_SOURCE: {
                return new FromZipPayload(zipReader, entry);
            }
            case NO_COMPRESSION: {
                return entry.isCompressed() ? new UncompressedPayload(zipReader, entry) : new FromZipPayload(zipReader, entry);
            }
            case DEFAULT_COMPRESSION: 
            case BEST_COMPRESSION: {
                if (entry.getUncompressedSize() <= (long)STORE_ON_DISK_THRESHOLD_BYTES) {
                    ByteBuffer buffer = ZipEntrySource.extractPayloadToByteBuffer(zipReader, entry, compressionLevel);
                    return new InMemoryPayload(buffer);
                }
                Path file = ZipEntrySource.extractPayloadToFile(zipReader, entry, compressionLevel, tempDirectory);
                return new OnDiskPayload(file);
            }
        }
        throw new AssertionError((Object)"Unreachable statement.");
    }

    private static Path extractPayloadToFile(ZipReader zipReader, Entry entry, CompressionLevel compressionLevel, TempDirectory tempDirectory) throws IOException {
        Path payloadFile = Files.createTempFile(tempDirectory.getPath(), "entry", ".payload", new FileAttribute[0]);
        try (InputStream in = ZipEntrySource.recompressedPayloadInputStream(zipReader, entry, compressionLevel);){
            Files.copy(in, payloadFile, StandardCopyOption.REPLACE_EXISTING);
        }
        return payloadFile;
    }

    private static ByteBuffer extractPayloadToByteBuffer(ZipReader zipReader, Entry entry, CompressionLevel compressionLevel) throws IOException {
        byte[] payloadBytes;
        try (InputStream in = ZipEntrySource.recompressedPayloadInputStream(zipReader, entry, compressionLevel);){
            payloadBytes = ByteStreams.toByteArray((InputStream)in);
        }
        return ByteBuffer.wrap(payloadBytes);
    }

    @MustBeClosed
    private static InputStream recompressedPayloadInputStream(ZipReader zipReader, Entry entry, CompressionLevel compressionLevel) {
        Preconditions.checkArgument((boolean)compressionLevel.isCompressed());
        Deflater deflater = new Deflater(compressionLevel.getValue(), true);
        InputStream contentStream = zipReader.getUncompressedPayload(entry.getName());
        return new DeflaterInputStream(contentStream, deflater);
    }

    @Override
    public void prepare() {
    }

    @Override
    public long writeTo(ZipWriter writer) throws IOException {
        return this.payload.writeTo(writer);
    }

    public Entry getEntry() {
        return this.entry;
    }

    public String getEntryName() {
        return this.entry.getName();
    }

    @Override
    public long getCompressedSize() {
        return this.compressedSize;
    }

    @Override
    public long getUncompressedSize() {
        return this.uncompressedSize;
    }

    public CompressionLevel getCompressionLevel() {
        return this.compressionLevel;
    }

    public ZipEntrySource setAlignment(long alignment) {
        super.align(alignment);
        return this;
    }

    private static final class UncompressedPayload
    extends Payload {
        private final ZipReader zipReader;
        private final Entry entry;

        UncompressedPayload(ZipReader zipReader, Entry entry) {
            this.zipReader = zipReader;
            this.entry = entry;
        }

        @Override
        public long writeTo(ZipWriter writer) throws IOException {
            ByteBuffer buffer = ByteBuffer.allocate(8192);
            int totalBytes = 0;
            try (InputStream in = this.zipReader.getUncompressedPayload(this.entry.getName());){
                int read;
                while ((read = UncompressedPayload.copy(in, buffer)) > 0 || buffer.position() != 0) {
                    buffer.flip();
                    totalBytes += writer.write(buffer);
                    buffer.compact();
                }
            }
            Preconditions.checkState(((long)totalBytes == this.entry.getUncompressedSize() ? 1 : 0) != 0, (Object)"Fewer bytes written than expected.");
            return totalBytes;
        }

        private static int copy(InputStream in, ByteBuffer buffer) throws IOException {
            int read = in.read(buffer.array(), buffer.position(), buffer.remaining());
            if (read > 0) {
                buffer.position(buffer.position() + read);
            }
            return read;
        }

        @Override
        public long size() {
            return this.entry.getUncompressedSize();
        }
    }

    private static final class FromZipPayload
    extends Payload {
        private final ZipReader zipReader;
        private final Entry entry;

        FromZipPayload(ZipReader zipReader, Entry entry) {
            this.zipReader = zipReader;
            this.entry = entry;
        }

        @Override
        public long writeTo(ZipWriter writer) {
            Location payloadLocation = this.entry.getPayloadLocation();
            this.zipReader.transferTo(writer, this.entry.getName());
            return payloadLocation.size();
        }

        @Override
        public long size() {
            return this.entry.getCompressedSize();
        }
    }

    private static final class OnDiskPayload
    extends Payload {
        private final Path payloadPath;
        private final long payloadSize;

        OnDiskPayload(Path payloadPath) throws IOException {
            this.payloadPath = payloadPath;
            this.payloadSize = Files.size(payloadPath);
        }

        @Override
        public long writeTo(ZipWriter writer) throws IOException {
            try (FileChannel channel = FileChannel.open(this.payloadPath, StandardOpenOption.READ);){
                writer.transferFrom(channel, 0L, this.payloadSize);
            }
            Files.delete(this.payloadPath);
            return this.payloadSize;
        }

        @Override
        public long size() {
            return this.payloadSize;
        }
    }

    private static final class InMemoryPayload
    extends Payload {
        private final ByteBuffer payloadBytes;

        InMemoryPayload(ByteBuffer payloadBytes) {
            this.payloadBytes = payloadBytes;
        }

        @Override
        public long writeTo(ZipWriter writer) throws IOException {
            return writer.write(this.payloadBytes);
        }

        @Override
        public long size() {
            return this.payloadBytes.limit();
        }
    }

    private static abstract class Payload {
        private Payload() {
        }

        public abstract long writeTo(ZipWriter var1) throws IOException;

        public abstract long size();
    }
}

