/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.archive;

import com.android.aapt.Resources;
import com.android.tools.build.bundletool.archive.ArchivedAndroidManifestUtils;
import com.android.tools.build.bundletool.io.TempDirectory;
import com.android.tools.build.bundletool.model.AndroidManifest;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.ResourceId;
import com.android.tools.build.bundletool.model.ResourceTableEntry;
import com.android.tools.build.bundletool.model.exceptions.InvalidCommandException;
import com.android.tools.build.bundletool.model.utils.ResourcesUtils;
import com.android.tools.build.bundletool.model.version.BundleToolVersion;
import com.android.tools.build.bundletool.model.version.VersionGuardedFeature;
import com.android.tools.build.bundletool.splitters.ResourceAnalyzer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import javax.inject.Inject;

public final class ArchivedApksGenerator {
    private static final String ARCHIVED_CLASSES_DEX_PATH = "dex/classes.dex";
    private final TempDirectory globalTempDir;

    @Inject
    ArchivedApksGenerator(TempDirectory globalTempDir) {
        this.globalTempDir = globalTempDir;
    }

    public ModuleSplit generateArchivedApk(AppBundle appBundle) throws IOException {
        this.validateRequest(appBundle);
        BundleModule baseModule = appBundle.getBaseModule();
        AndroidManifest archivedManifest = ArchivedAndroidManifestUtils.createArchivedManifest(baseModule.getAndroidManifest());
        Optional<Resources.ResourceTable> archivedResourceTable = this.getArchivedResourceTable(appBundle, baseModule, archivedManifest);
        Path archivedClassesDexFile = this.getArchivedClassesDexFile();
        return ModuleSplit.forArchive(baseModule, archivedManifest, archivedResourceTable, archivedClassesDexFile);
    }

    private void validateRequest(AppBundle appBundle) {
        Preconditions.checkNotNull((Object)appBundle);
        if (!VersionGuardedFeature.ARCHIVED_APK_GENERATION.enabledForVersion(BundleToolVersion.getVersionFromBundleConfig(appBundle.getBundleConfig()))) {
            throw InvalidCommandException.builder().withInternalMessage(String.format("Archived APK can only be generated for bundles built with version %s or higher.", VersionGuardedFeature.ARCHIVED_APK_GENERATION.getEnabledSinceVersion())).build();
        }
        if (!appBundle.storeArchiveEnabled()) {
            throw InvalidCommandException.builder().withInternalMessage("Archived APK cannot be generated when Store Archive configuration is disabled.").build();
        }
    }

    private Optional<Resources.ResourceTable> getArchivedResourceTable(AppBundle appBundle, BundleModule bundleModule, AndroidManifest archivedManifest) throws IOException {
        if (!bundleModule.getResourceTable().isPresent()) {
            return Optional.empty();
        }
        ImmutableSet<ResourceId> referredResources = new ResourceAnalyzer(appBundle).findAllAppResourcesReachableFromManifest(archivedManifest);
        Resources.ResourceTable archivedResourceTable = ResourcesUtils.filterResourceTable(bundleModule.getResourceTable().get(), entry -> !referredResources.contains((Object)entry.getResourceId()), ResourceTableEntry::getEntry);
        return Optional.of(archivedResourceTable);
    }

    private Path getArchivedClassesDexFile() throws IOException {
        Path archivedDexFilePath = Files.createTempFile(this.globalTempDir.getPath(), "classes", ".dex", new FileAttribute[0]);
        try (InputStream inputStream = ArchivedApksGenerator.readArchivedClassesDexFile();){
            Files.copy(inputStream, archivedDexFilePath, StandardCopyOption.REPLACE_EXISTING);
        }
        return archivedDexFilePath;
    }

    private static InputStream readArchivedClassesDexFile() {
        return ArchivedApksGenerator.class.getResourceAsStream(ARCHIVED_CLASSES_DEX_PATH);
    }
}

