/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.tools.build.bundletool.model.AutoValue_ZipPath;
import com.google.auto.value.AutoValue;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Comparators;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import java.util.Collection;
import java.util.Comparator;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

@Immutable
@AutoValue
@AutoValue.CopyAnnotations
public abstract class ZipPath
implements Comparable<ZipPath> {
    private static final String SEPARATOR = "/";
    private static final Splitter SPLITTER = Splitter.on((String)"/").omitEmptyStrings();
    private static final Joiner JOINER = Joiner.on((String)"/");
    private static final ImmutableSet<String> FORBIDDEN_NAMES = ImmutableSet.of((Object)"", (Object)".", (Object)"..");
    public static final ZipPath ROOT = ZipPath.create("");

    ZipPath() {
    }

    public abstract ImmutableList<String> getNames();

    public static ZipPath create(String path) {
        Preconditions.checkNotNull((Object)path, (Object)"Path cannot be null.");
        return ZipPath.create((ImmutableList<String>)ImmutableList.copyOf((Collection)SPLITTER.splitToList((CharSequence)path)));
    }

    public static ZipPath create(ImmutableList<String> names) {
        names.forEach(name -> {
            Preconditions.checkArgument((!name.contains(SEPARATOR) ? 1 : 0) != 0, (String)"Name '%s' contains a forward slash and cannot be used in a path.", (Object)name);
            Preconditions.checkArgument((!FORBIDDEN_NAMES.contains(name) ? 1 : 0) != 0, (String)"Name '%s' is not supported inside path.", (Object)name);
        });
        return new AutoValue_ZipPath(names);
    }

    @CheckReturnValue
    public ZipPath resolve(ZipPath p4) {
        Preconditions.checkNotNull((Object)p4, (Object)"Path cannot be null.");
        return ZipPath.create((ImmutableList<String>)ImmutableList.builder().addAll(this.getNames()).addAll(p4.getNames()).build());
    }

    @CheckReturnValue
    public ZipPath resolve(String path) {
        return this.resolve(ZipPath.create(path));
    }

    @CheckReturnValue
    public ZipPath resolveSibling(ZipPath path) {
        Preconditions.checkNotNull((Object)path, (Object)"Path cannot be null.");
        Preconditions.checkState((!this.getNames().isEmpty() ? 1 : 0) != 0, (Object)"Root has not sibling.");
        return this.getParent().resolve(path);
    }

    @CheckReturnValue
    public ZipPath resolveSibling(String path) {
        return this.resolveSibling(ZipPath.create(path));
    }

    @CheckReturnValue
    public ZipPath subpath(int from, int to) {
        Preconditions.checkArgument((from >= 0 && from < this.getNames().size() ? 1 : 0) != 0);
        Preconditions.checkArgument((to >= 0 && to <= this.getNames().size() ? 1 : 0) != 0);
        Preconditions.checkArgument((from < to ? 1 : 0) != 0);
        return ZipPath.create((ImmutableList<String>)this.getNames().subList(from, to));
    }

    @Nullable
    @CheckReturnValue
    public ZipPath getParent() {
        if (this.getNames().isEmpty()) {
            return null;
        }
        return ZipPath.create((ImmutableList<String>)this.getNames().subList(0, this.getNames().size() - 1));
    }

    public int getNameCount() {
        return this.getNames().size();
    }

    public ZipPath getRoot() {
        return ROOT;
    }

    public ZipPath getName(int index) {
        Preconditions.checkArgument((index >= 0 && index < this.getNames().size() ? 1 : 0) != 0);
        return ZipPath.create((String)this.getNames().get(index));
    }

    public boolean startsWith(ZipPath p4) {
        if (p4.getNameCount() > this.getNameCount()) {
            return false;
        }
        ImmutableList<String> names = this.getNames();
        ImmutableList<String> otherNames = p4.getNames();
        for (int i4 = 0; i4 < p4.getNameCount(); ++i4) {
            if (((String)otherNames.get(i4)).equals(names.get(i4))) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String p4) {
        return this.startsWith(ZipPath.create(p4));
    }

    public boolean endsWith(ZipPath p4) {
        if (p4.getNameCount() > this.getNameCount()) {
            return false;
        }
        ImmutableList<String> names = this.getNames();
        ImmutableList<String> otherNames = p4.getNames();
        for (int i4 = 0; i4 < p4.getNameCount(); ++i4) {
            if (((String)otherNames.get(otherNames.size() - i4 - 1)).equals(names.get(names.size() - i4 - 1))) continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(String p4) {
        return this.endsWith(ZipPath.create(p4));
    }

    @Override
    public final int compareTo(ZipPath other) {
        return Comparators.lexicographical(Comparator.naturalOrder()).compare(this.getNames(), other.getNames());
    }

    public String toString() {
        return JOINER.join(this.getNames());
    }

    public ZipPath getFileName() {
        Preconditions.checkArgument((this.getNameCount() > 0 ? 1 : 0) != 0, (Object)"Root does not have a file name.");
        return this.getName(this.getNameCount() - 1);
    }
}

