/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.tools.build.bundletool.commands.BuildApksModule;
import com.android.tools.build.bundletool.io.ApkSerializerHelper;
import com.android.tools.build.bundletool.io.TempDirectory;
import com.android.tools.build.bundletool.model.ApksigSigningConfiguration;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.SignerConfig;
import com.android.tools.build.bundletool.model.SigningConfiguration;
import com.android.tools.build.bundletool.model.SigningConfigurationProvider;
import com.android.tools.build.bundletool.model.WearApkLocator;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CheckReturnValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import shadow.bundletool.com.android.apksig.ApkSigner;
import shadow.bundletool.com.android.apksig.apk.ApkFormatException;

class ApkSigner {
    private static final String SIGNER_CONFIG_NAME = "BNDLTOOL";
    private final Optional<SigningConfigurationProvider> signingConfigProvider;
    private final Optional<SigningConfiguration> sourceStampSigningConfig;
    private final TempDirectory tempDirectory;

    @Inject
    ApkSigner(@BuildApksModule.ApkSigningConfigProvider Optional<SigningConfigurationProvider> signingConfigProvider, @BuildApksModule.StampSigningConfig Optional<SigningConfiguration> sourceStampSigningConfig, TempDirectory tempDirectory) {
        this.signingConfigProvider = signingConfigProvider;
        this.sourceStampSigningConfig = sourceStampSigningConfig;
        this.tempDirectory = tempDirectory;
    }

    public void signApk(Path apkPath, ModuleSplit split) {
        if (!this.signingConfigProvider.isPresent()) {
            return;
        }
        ApksigSigningConfiguration signingConfig = this.signingConfigProvider.get().getSigningConfiguration(SigningConfigurationProvider.ApkDescription.fromModuleSplit(split));
        try (TempDirectory tempDirectory = new TempDirectory(this.getClass().getSimpleName());){
            Path signedApkPath = tempDirectory.getPath().resolve("signed.apk");
            ApkSigner.Builder apkSigner = new ApkSigner.Builder((List)signingConfig.getSignerConfigs().stream().map(ApkSigner::convertToApksigSignerConfig).collect(ImmutableList.toImmutableList())).setInputApk(apkPath.toFile()).setOutputApk(signedApkPath.toFile()).setV1SigningEnabled(signingConfig.getV1SigningEnabled()).setV2SigningEnabled(signingConfig.getV2SigningEnabled()).setV3SigningEnabled(signingConfig.getV3SigningEnabled()).setOtherSignersSignaturesPreserved(false).setMinSdkVersion(split.getAndroidManifest().getEffectiveMinSdkVersion());
            signingConfig.getSigningCertificateLineage().ifPresent(apkSigner::setSigningCertificateLineage);
            this.sourceStampSigningConfig.map(SigningConfiguration::getSignerConfig).map(ApkSigner::convertToApksigSignerConfig).ifPresent(apkSigner::setSourceStampSignerConfig);
            apkSigner.build().sign();
            Files.move(signedApkPath, apkPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | SignatureException | ApkFormatException e5) {
            throw CommandExecutionException.builder().withCause(e5).withInternalMessage("Unable to sign APK.").build();
        }
    }

    @CheckReturnValue
    public ModuleSplit signEmbeddedApks(ModuleSplit split) {
        ImmutableSet wear1ApkPaths = ImmutableSet.copyOf(WearApkLocator.findEmbeddedWearApkPaths(split));
        ImmutableList.Builder newEntries = ImmutableList.builder();
        for (ModuleEntry entry : split.getEntries()) {
            ZipPath pathInApk = ApkSerializerHelper.toApkEntryPath(entry.getPath());
            if (entry.getShouldSign() || wear1ApkPaths.contains((Object)pathInApk)) {
                newEntries.add((Object)this.signModuleEntry(split, entry));
                continue;
            }
            newEntries.add((Object)entry);
        }
        return split.toBuilder().setEntries((List<ModuleEntry>)newEntries.build()).build();
    }

    private ModuleEntry signModuleEntry(ModuleSplit split, ModuleEntry entry) {
        try {
            Path tempDir = Files.createTempDirectory(this.tempDirectory.getPath(), this.getClass().getSimpleName(), new FileAttribute[0]);
            Path embeddedApk = tempDir.resolve("embedded.apk");
            try (InputStream entryContent = entry.getContent().openStream();){
                Files.copy(entryContent, embeddedApk, new CopyOption[0]);
            }
            this.signApk(embeddedApk, split);
            return entry.toBuilder().setContent(embeddedApk).setShouldSign(false).build();
        }
        catch (IOException e5) {
            throw new UncheckedIOException(e5);
        }
    }

    private static ApkSigner.SignerConfig convertToApksigSignerConfig(SignerConfig signerConfig) {
        return new ApkSigner.SignerConfig.Builder(SIGNER_CONFIG_NAME, signerConfig.getPrivateKey(), (List<X509Certificate>)signerConfig.getCertificates()).build();
    }
}

