/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.zipflinger;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import shadow.bundletool.com.android.zipflinger.Archive;
import shadow.bundletool.com.android.zipflinger.Source;
import shadow.bundletool.com.android.zipflinger.ZipSource;

public class StableArchive
implements Archive {
    private final Archive archive;
    private final ArrayList<Source> sources;
    private final ArrayList<ZipSource> zipSources;
    private final ArrayList<String> deletedEntries;

    public StableArchive(Archive archive) {
        this.archive = archive;
        this.sources = new ArrayList();
        this.zipSources = new ArrayList();
        this.deletedEntries = new ArrayList();
    }

    @Override
    public void add(Source source) {
        this.sources.add(source);
    }

    @Override
    public void add(ZipSource sources) {
        this.zipSources.add(sources);
    }

    @Override
    public void delete(String name) {
        this.deletedEntries.add(name);
    }

    @Override
    public void close() throws IOException {
        this.sources.sort(Comparator.comparing(Source::getName));
        this.zipSources.sort(Comparator.comparing(ZipSource::getName));
        for (ZipSource zipSource : this.zipSources) {
            zipSource.getSelectedEntries().sort(Comparator.comparing(Source::getName));
        }
        this.deletedEntries.sort(Comparator.naturalOrder());
        try (Archive arch = this.archive;){
            for (String toDelete : this.deletedEntries) {
                arch.delete(toDelete);
            }
            for (Source source : this.sources) {
                arch.add(source);
            }
            for (ZipSource zipSource : this.zipSources) {
                arch.add(zipSource);
            }
        }
    }
}

