/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.shards;

import com.android.bundle.Files;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.AbiName;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CheckReturnValue;
import java.util.Collection;
import java.util.Optional;
import javax.inject.Inject;

public class BundleModule64BitNativeLibrariesRemover {
    @Inject
    public BundleModule64BitNativeLibrariesRemover() {
    }

    @CheckReturnValue
    public BundleModule strip64BitLibraries(BundleModule module) {
        Optional<Files.NativeLibraries> nativeConfig = module.getNativeConfig();
        if (!nativeConfig.isPresent()) {
            return module;
        }
        ImmutableSet<Files.TargetedNativeDirectory> dirsToRemove = BundleModule64BitNativeLibrariesRemover.get64BitTargetedNativeDirectories(nativeConfig.get());
        if (dirsToRemove.isEmpty()) {
            return module;
        }
        if (dirsToRemove.size() == nativeConfig.get().getDirectoryCount()) {
            throw InvalidBundleException.builder().withUserMessage("Usage of 64-bit native libraries is disabled, but App Bundle contains only 64-bit native libraries.").build();
        }
        return module.toBuilder().setRawEntries((Collection<ModuleEntry>)BundleModule64BitNativeLibrariesRemover.filterEntries(module.getEntries(), dirsToRemove)).setNativeConfig(BundleModule64BitNativeLibrariesRemover.filterTargeting(nativeConfig.get(), dirsToRemove)).build();
    }

    private static ImmutableCollection<ModuleEntry> filterEntries(ImmutableCollection<ModuleEntry> entries, ImmutableCollection<Files.TargetedNativeDirectory> targeted64BitNativeDirectories) {
        return (ImmutableCollection)entries.stream().filter(entry -> BundleModule64BitNativeLibrariesRemover.shouldIncludeEntry(entry, targeted64BitNativeDirectories)).collect(ImmutableList.toImmutableList());
    }

    private static boolean shouldIncludeEntry(ModuleEntry entry, ImmutableCollection<Files.TargetedNativeDirectory> targeted64BitNativeDirectories) {
        return targeted64BitNativeDirectories.stream().noneMatch(targetedNativeDirectory -> entry.getPath().startsWith(targetedNativeDirectory.getPath()));
    }

    private static ImmutableSet<Files.TargetedNativeDirectory> get64BitTargetedNativeDirectories(Files.NativeLibraries nativeLibraries) {
        return (ImmutableSet)nativeLibraries.getDirectoryList().stream().filter(BundleModule64BitNativeLibrariesRemover::targets64BitAbi).collect(ImmutableSet.toImmutableSet());
    }

    private static boolean targets64BitAbi(Files.TargetedNativeDirectory targetedNativeDirectory) {
        return targetedNativeDirectory.getTargeting().hasAbi() && BundleModule64BitNativeLibrariesRemover.is64Bit(targetedNativeDirectory.getTargeting().getAbi());
    }

    private static boolean is64Bit(Targeting.Abi abi) {
        return AbiName.fromProto(abi.getAlias()).getBitSize() == 64;
    }

    private static Files.NativeLibraries filterTargeting(Files.NativeLibraries nativeConfig, ImmutableSet<Files.TargetedNativeDirectory> dirsToRemove) {
        return nativeConfig.toBuilder().clearDirectory().addAllDirectory((Iterable)nativeConfig.getDirectoryList().stream().filter(Predicates.not(arg_0 -> dirsToRemove.contains(arg_0))).collect(ImmutableList.toImmutableList())).build();
    }
}

