/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.zipflinger;

import java.text.NumberFormat;

public class Location
implements Comparable<Location> {
    public static final Location INVALID = new Location(Long.MAX_VALUE, Long.MAX_VALUE);
    public final long first;
    public final long last;

    public Location(long first, long size) {
        this.first = first;
        this.last = first + size - 1L;
    }

    public long size() {
        return this.last - this.first + 1L;
    }

    public boolean isValid() {
        return !this.equals(INVALID);
    }

    public String toString() {
        return "(offset=" + NumberFormat.getInstance().format(this.first) + ", size=" + NumberFormat.getInstance().format(this.size()) + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Location)) {
            return false;
        }
        Location other = (Location)obj;
        return this.first == other.first && this.last == other.last;
    }

    public int hashCode() {
        return Long.hashCode(this.first);
    }

    @Override
    public int compareTo(Location o4) {
        return Math.toIntExact(this.first - o4.first);
    }
}

