/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.utils;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shadow.bundletool.com.android.SdkConstants;
import shadow.bundletool.com.android.utils.TokenizedCommandLineKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\n\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0014\n\u0002\u0010 \n\u0002\b\u0006\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0017\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0006\u0010\u0019\u001a\u00020\u0007J\b\u0010\u001a\u001a\u00020\u0018H\u0002J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007H\u0007J\u000e\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0003J\u0006\u0010\"\u001a\u00020\u0007J\u0010\u0010#\u001a\u0004\u0018\u00010\u00032\u0006\u0010$\u001a\u00020\u0007J,\u0010%\u001a\u0004\u0018\u00010\u00032\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u00072\b\b\u0002\u0010(\u001a\u00020\u00052\b\b\u0002\u0010)\u001a\u00020\u0005J\b\u0010*\u001a\u00020\u0003H\u0016J\u000e\u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u0003J\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00030-J \u0010.\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u0005H\u0007J\u0010\u0010/\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u0007H\u0002J\u0010\u00101\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u00102\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lshadow/bundletool/com/android/utils/TokenizedCommandLine;", "", "commandLine", "", "raw", "", "platform", "", "indexes", "", "(Ljava/lang/String;ZI[I)V", "getCommandLine", "()Ljava/lang/String;", "generation", "getPlatform", "()I", "getRaw", "()Z", "toStringValue", "charAt", "", "i", "(I)Ljava/lang/Character;", "checkGeneration", "", "computeNormalizedCommandLineHashCode", "invalidate", "isEndOfCommand", "isEndOfToken", "isStartOfToken", "nextTokenAfter", "offset", "normalizedCommandLineEquals", "other", "normalizedCommandLineLength", "removeNth", "n", "removeTokenGroup", "token", "extra", "matchPrefix", "returnFirstExtra", "toString", "separator", "toTokenList", "", "tokenMatches", "tokenStartingAt", "start", "zeroAllocTokenizePOSIX", "zeroAllocTokenizeWindows", "common"})
public final class TokenizedCommandLine {
    @NotNull
    private final String commandLine;
    private final boolean raw;
    private final int platform;
    @NotNull
    private int[] indexes;
    private final int generation;
    @Nullable
    private String toStringValue;

    public TokenizedCommandLine(@NotNull String commandLine, boolean raw, int platform, @NotNull int[] indexes) {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        Intrinsics.checkParameterIsNotNull((Object)indexes, (String)"indexes");
        this.commandLine = commandLine;
        this.raw = raw;
        this.platform = platform;
        int[] nArray = this.indexes = indexes;
        nArray[0] = nArray[0] + 1;
        this.generation = nArray[0];
        this.checkGeneration();
        if (this.platform == 2) {
            this.zeroAllocTokenizeWindows(this.raw);
        } else {
            this.zeroAllocTokenizePOSIX(this.raw);
        }
    }

    public /* synthetic */ TokenizedCommandLine(String string, boolean bl2, int n11, int[] nArray, int n12, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n12 & 4) != 0) {
            n11 = SdkConstants.currentPlatform();
        }
        if ((n12 & 8) != 0) {
            nArray = TokenizedCommandLineKt.allocateTokenizeCommandLineBuffer(string);
        }
        this(string, bl2, n11, nArray);
    }

    @NotNull
    public final String getCommandLine() {
        return this.commandLine;
    }

    public final boolean getRaw() {
        return this.raw;
    }

    public final int getPlatform() {
        return this.platform;
    }

    @Nullable
    public final String removeTokenGroup(@NotNull String token, int extra, boolean matchPrefix, boolean returnFirstExtra) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        this.checkGeneration();
        this.invalidate();
        int read = 1;
        int write = 1;
        String firstExtra = null;
        do {
            int n11 = read >= write ? 1 : 0;
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && n11 == 0) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            n11 = this.isStartOfToken(read);
            bl2 = false;
            bl3 = false;
            if (_Assertions.ENABLED && n11 == 0) {
                boolean bl5 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            n11 = this.isStartOfToken(write);
            bl2 = false;
            bl3 = false;
            if (_Assertions.ENABLED && n11 == 0) {
                boolean bl6 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            if (this.tokenMatches(token, read, matchPrefix)) {
                if (returnFirstExtra) {
                    firstExtra = matchPrefix ? this.tokenStartingAt(read + token.length()) : this.tokenStartingAt(this.nextTokenAfter(read));
                }
                for (int count = 0; count != extra + 1 && !this.isEndOfCommand(read); ++count) {
                    read = this.nextTokenAfter(read);
                }
            } else {
                if (this.isEndOfCommand(read) || this.isEndOfCommand(write)) continue;
                do {
                    n11 = write;
                    write = n11 + 1;
                    int n12 = n11;
                    n11 = read;
                    read = n11 + 1;
                    this.indexes[n12] = this.indexes[n11];
                } while (!this.isEndOfToken(read - 1));
            }
        } while (!this.isEndOfCommand(read));
        this.indexes[write] = Integer.MIN_VALUE;
        return firstExtra;
    }

    public static /* synthetic */ String removeTokenGroup$default(TokenizedCommandLine tokenizedCommandLine, String string, int n11, boolean bl2, boolean bl3, int n12, Object object) {
        if ((n12 & 4) != 0) {
            bl2 = false;
        }
        if ((n12 & 8) != 0) {
            bl3 = false;
        }
        return tokenizedCommandLine.removeTokenGroup(string, n11, bl2, bl3);
    }

    private final String tokenStartingAt(int start) {
        this.checkGeneration();
        StringBuilder token = new StringBuilder();
        int n11 = start;
        int n12 = this.indexes.length;
        if (n11 < n12) {
            block4: while (true) {
                int read = n11++;
                int offset = this.indexes[read];
                switch (offset) {
                    case -2147483648: {
                        break block4;
                    }
                    case 0x7FFFFFFF: {
                        break block4;
                    }
                    default: {
                        token.append(this.commandLine.charAt(offset));
                        if (n11 < n12) continue block4;
                    }
                }
                break;
            }
        }
        return ((Object)StringsKt.trim((CharSequence)token)).toString();
    }

    @Nullable
    public final String removeNth(int n11) {
        this.checkGeneration();
        this.invalidate();
        StringBuilder token = new StringBuilder();
        int tokenNumber = 0;
        int write = 1;
        int n12 = 1;
        int n13 = this.indexes.length;
        if (n12 < n13) {
            block4: do {
                int read = n12++;
                if (tokenNumber != n11) {
                    int n14 = write;
                    write = n14 + 1;
                    this.indexes[n14] = this.indexes[read];
                }
                int offset = this.indexes[read];
                switch (offset) {
                    case -2147483648: {
                        CharSequence charSequence = token;
                        boolean bl2 = false;
                        if (charSequence.length() == 0) {
                            return null;
                        }
                        return token.toString();
                    }
                    case 0x7FFFFFFF: {
                        int n15 = tokenNumber;
                        tokenNumber = n15 + 1;
                        break;
                    }
                    default: {
                        if (tokenNumber != n11) continue block4;
                        token.append(this.commandLine.charAt(offset));
                    }
                }
            } while (n12 < n13);
        }
        return null;
    }

    @NotNull
    public final List<String> toTokenList() {
        this.checkGeneration();
        boolean bl2 = false;
        List result = new ArrayList();
        StringBuilder token = new StringBuilder();
        int i11 = 1;
        while (!this.isEndOfCommand(i11)) {
            Character c11 = this.charAt(i11);
            if (c11 == null) {
                CharSequence charSequence = token;
                boolean bl3 = false;
                if (charSequence.length() > 0) {
                    charSequence = token.toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"token.toString()");
                    result.add(charSequence);
                    token.setLength(0);
                }
            } else {
                token.append(c11.charValue());
            }
            ++i11;
        }
        return result;
    }

    private final TokenizedCommandLine zeroAllocTokenizeWindows(boolean raw) {
        int n11;
        this.checkGeneration();
        this.invalidate();
        boolean quoting = false;
        int i11 = 0;
        int length = this.commandLine.length();
        Character c11 = null;
        int offset = 0;
        offset = 1;
        while (i11 < length && Character.isWhitespace(this.commandLine.charAt(i11))) {
            n11 = i11;
            i11 = n11 + 1;
        }
        block1: while (i11 < length) {
            c11 = Character.valueOf(this.commandLine.charAt(i11));
            n11 = 34;
            if (c11.charValue() == n11) {
                if (raw) {
                    n11 = offset;
                    offset = n11 + 1;
                    this.indexes[n11] = i11;
                }
                quoting = !quoting;
                ++i11;
                continue;
            }
            n11 = 92;
            if (c11.charValue() == n11) {
                boolean quote;
                int forward = i11 + 1;
                int slashCount = 1;
                c11 = StringsKt.getOrNull((CharSequence)this.commandLine, (int)forward);
                while (true) {
                    Character c12 = c11;
                    char c13 = '\\';
                    if (c12 == null || c12.charValue() != c13) break;
                    ++slashCount;
                    c11 = StringsKt.getOrNull((CharSequence)this.commandLine, (int)(++forward));
                }
                boolean odd = slashCount % 2 == 1;
                Character c14 = c11;
                int n12 = 34;
                boolean bl2 = quote = c14 != null && c14.charValue() == n12;
                if (!raw && quote) {
                    slashCount /= 2;
                }
                n12 = 0;
                int n13 = 0;
                n13 = 0;
                int n14 = slashCount;
                while (n13 < n14) {
                    int j11 = n13++;
                    boolean bl3 = false;
                    int n15 = offset;
                    offset = n15 + 1;
                    this.indexes[n15] = i11 + j11;
                }
                if (odd && quote) {
                    n12 = offset;
                    offset = n12 + 1;
                    int n16 = n12;
                    n12 = forward;
                    forward = n12 + 1;
                    this.indexes[n16] = n12;
                }
                i11 = forward;
                continue;
            }
            if (!quoting) {
                n11 = 94;
                if (c11.charValue() == n11) {
                    c11 = StringsKt.getOrNull((CharSequence)this.commandLine, (int)(++i11));
                    if (raw || c11 == null) {
                        n11 = offset;
                        offset = n11 + 1;
                        this.indexes[n11] = i11 - 1;
                    }
                    Character c15 = c11;
                    n11 = 94;
                    if (c15 != null && c15.charValue() == n11) {
                        n11 = offset;
                        offset = n11 + 1;
                        int n17 = n11;
                        n11 = i11;
                        i11 = n11 + 1;
                        this.indexes[n17] = n11;
                    }
                    while (true) {
                        Character c16 = c11;
                        n11 = 13;
                        if (c16 == null || c16.charValue() != n11) {
                            Character c17 = c11;
                            n11 = 10;
                            if (c17 == null || c17.charValue() != n11) continue block1;
                        }
                        c11 = StringsKt.getOrNull((CharSequence)this.commandLine, (int)(++i11));
                    }
                }
            }
            if (!quoting && Character.isWhitespace(c11.charValue())) {
                n11 = offset;
                offset = n11 + 1;
                this.indexes[n11] = Integer.MAX_VALUE;
                c11 = StringsKt.getOrNull((CharSequence)this.commandLine, (int)(++i11));
                while (c11 != null && Character.isWhitespace(c11.charValue())) {
                    c11 = StringsKt.getOrNull((CharSequence)this.commandLine, (int)(++i11));
                }
                continue;
            }
            n11 = offset;
            offset = n11 + 1;
            int n18 = n11;
            n11 = i11;
            i11 = n11 + 1;
            this.indexes[n18] = n11;
        }
        if (!this.isEndOfToken(offset - 1)) {
            n11 = offset;
            offset = n11 + 1;
            this.indexes[n11] = Integer.MAX_VALUE;
        }
        n11 = offset;
        offset = n11 + 1;
        this.indexes[n11] = Integer.MIN_VALUE;
        return this;
    }

    private final TokenizedCommandLine zeroAllocTokenizePOSIX(boolean raw) {
        int n11;
        this.checkGeneration();
        this.invalidate();
        boolean quoting = false;
        char quote = '\u0000';
        boolean escaping = false;
        boolean skipping = true;
        int i11 = 0;
        char c11 = '\u0000';
        int length = this.commandLine.length();
        int offset = 1;
        while (i11 < length) {
            n11 = i11;
            i11 = n11 + 1;
            c11 = this.commandLine.charAt(n11);
            if (skipping) {
                if (Character.isWhitespace(c11)) continue;
                skipping = false;
            }
            if ((quoting || !Character.isWhitespace(c11)) && raw) {
                n11 = offset;
                offset = n11 + 1;
                this.indexes[n11] = i11 - 1;
            }
            if (escaping) {
                escaping = false;
                if (c11 == '\n' || raw) continue;
                n11 = offset;
                offset = n11 + 1;
                this.indexes[n11] = i11 - 1;
                continue;
            }
            if (!(c11 != '\\' || quoting && quote != '\"')) {
                escaping = true;
                continue;
            }
            if (!(quoting || c11 != '\"' && c11 != '\'')) {
                quoting = true;
                quote = c11;
                continue;
            }
            if (quoting && c11 == quote) {
                quoting = false;
                quote = '\u0000';
                continue;
            }
            if (!quoting && Character.isWhitespace(c11)) {
                skipping = true;
                n11 = offset;
                offset = n11 + 1;
                this.indexes[n11] = Integer.MAX_VALUE;
                continue;
            }
            if (raw) continue;
            n11 = offset;
            offset = n11 + 1;
            this.indexes[n11] = i11 - 1;
        }
        if (!this.isEndOfToken(offset - 1)) {
            n11 = offset;
            offset = n11 + 1;
            this.indexes[n11] = Integer.MAX_VALUE;
        }
        this.indexes[offset] = Integer.MIN_VALUE;
        return this;
    }

    @VisibleForTesting
    public final boolean tokenMatches(@NotNull String token, int offset, boolean matchPrefix) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        this.checkGeneration();
        int i11 = 0;
        int index = this.indexes[offset];
        while (index != Integer.MIN_VALUE) {
            boolean endOfToken;
            boolean bl2 = endOfToken = index == Integer.MAX_VALUE;
            if (i11 == token.length()) {
                return endOfToken || matchPrefix;
            }
            if (endOfToken) {
                return false;
            }
            if (token.charAt(i11) != this.commandLine.charAt(index)) {
                return false;
            }
            index = this.indexes[offset + ++i11];
        }
        return false;
    }

    @VisibleForTesting
    public final int nextTokenAfter(int offset) {
        this.checkGeneration();
        int result = offset;
        while (!this.isEndOfToken(result) && !this.isEndOfCommand(result)) {
            ++result;
        }
        return result + 1;
    }

    private final boolean isEndOfToken(int i11) {
        return i11 < this.indexes.length && this.indexes[i11] == Integer.MAX_VALUE;
    }

    private final boolean isEndOfCommand(int i11) {
        return i11 >= this.indexes.length || this.indexes[i11] == Integer.MIN_VALUE;
    }

    private final boolean isStartOfToken(int i11) {
        return i11 == 1 || this.isEndOfToken(i11 - 1);
    }

    private final Character charAt(int i11) {
        return this.isEndOfToken(i11) ? null : Character.valueOf(this.commandLine.charAt(this.indexes[i11]));
    }

    public final int normalizedCommandLineLength() {
        int n11;
        if (this.isEndOfCommand(1)) {
            n11 = 0;
        } else {
            int i11 = 1;
            while (!this.isEndOfCommand(i11 + 1)) {
                ++i11;
            }
            n11 = i11 - 1;
        }
        return n11;
    }

    public final int computeNormalizedCommandLineHashCode() {
        this.checkGeneration();
        long hash = 1469598103934665603L;
        int i11 = 1;
        while (!this.isEndOfCommand(i11) && !this.isEndOfCommand(i11 + 1)) {
            Character c11 = this.charAt(i11);
            hash ^= (long)(c11 == null ? 32 : (int)c11.charValue());
            hash *= 1099511628211L;
            ++i11;
        }
        return (int)hash;
    }

    public final boolean normalizedCommandLineEquals(@NotNull String other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        int length1 = this.normalizedCommandLineLength();
        int length2 = other.length();
        if (length1 == 0 && length2 == 0) {
            return true;
        }
        if (length1 != length2) {
            return false;
        }
        int n11 = 1;
        if (n11 < length1) {
            do {
                int i11;
                Character c11;
                if (((c11 = this.charAt(i11 = n11++)) == null ? (char)' ' : (char)c11.charValue()) == other.charAt(i11 - 1)) continue;
                return false;
            } while (n11 < length1);
        }
        return true;
    }

    @NotNull
    public final String toString(@NotNull String separator) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)separator, (String)"separator");
        this.checkGeneration();
        int i11 = 1;
        if (this.isEndOfCommand(i11)) {
            return "";
        }
        StringBuilder sb2 = new StringBuilder();
        while (!this.isEndOfCommand(i11 + 1)) {
            object = this.charAt(i11);
            sb2.append(object == null ? separator : object);
            ++i11;
        }
        object = sb2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"sb.toString()");
        return object;
    }

    @NotNull
    public String toString() {
        if (this.toStringValue != null) {
            String string = this.toStringValue;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            return string;
        }
        this.toStringValue = this.toString(" ");
        String string = this.toStringValue;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    private final void invalidate() {
        this.toStringValue = null;
    }

    private final void checkGeneration() {
        int n11 = this.indexes[0];
        boolean bl2 = false;
        if (this.generation != Math.abs(n11)) {
            throw new Exception("Buffer indexes was shared with another TokenizedCommandLine after this one");
        }
    }
}

