/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.incfs.install.adb.ddmlib;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import shadow.bundletool.com.android.ddmlib.AdbCommandRejectedException;
import shadow.bundletool.com.android.ddmlib.AndroidDebugBridge;
import shadow.bundletool.com.android.ddmlib.IDevice;
import shadow.bundletool.com.android.ddmlib.TimeoutException;
import shadow.bundletool.com.android.incfs.install.IDeviceConnection;

public class DeviceConnection
implements IDeviceConnection {
    private final SocketChannel mChannel;
    private final Selector mReadSelector;
    private final Selector mWriteSelector;

    public static Factory getFactory(String deviceSerialNumber) throws IOException {
        AndroidDebugBridge adb = AndroidDebugBridge.getBridge();
        if (adb == null) {
            throw new IOException("Unable to connect to adb");
        }
        for (IDevice device : adb.getDevices()) {
            if (!deviceSerialNumber.equals(device.getSerialNumber())) continue;
            return new Factory(device);
        }
        throw new IOException("Failed to find device with serial \"" + deviceSerialNumber + "\"");
    }

    private DeviceConnection(SocketChannel channel) throws IOException {
        this.mChannel = channel;
        this.mChannel.configureBlocking(false);
        this.mReadSelector = Selector.open();
        this.mChannel.register(this.mReadSelector, 1);
        this.mWriteSelector = Selector.open();
        this.mChannel.register(this.mWriteSelector, 4);
    }

    @Override
    public int read(ByteBuffer dst, long timeoutMs) throws IOException {
        this.mReadSelector.select(timeoutMs);
        return this.mChannel.read(dst);
    }

    @Override
    public int write(ByteBuffer src, long timeoutMs) throws IOException {
        this.mWriteSelector.select(timeoutMs);
        return this.mChannel.write(src);
    }

    @Override
    public void close() throws Exception {
        try (SocketChannel c11 = this.mChannel;
             Selector r11 = this.mReadSelector;){
            Selector w11 = this.mWriteSelector;
            if (w11 != null) {
                w11.close();
            }
        }
    }

    public static class Factory
    implements IDeviceConnection.Factory {
        private final IDevice mDevice;

        private Factory(IDevice device) {
            this.mDevice = device;
        }

        @Override
        public IDeviceConnection connectToService(String service, String[] parameters) throws IOException {
            SocketChannel channel;
            try {
                channel = this.mDevice.rawBinder(service, parameters);
            }
            catch (AdbCommandRejectedException | TimeoutException e11) {
                throw new IOException(String.format("Failed invoking binder command \"%s %s\"", service, String.join((CharSequence)" ", parameters)), e11);
            }
            channel.configureBlocking(false);
            return new DeviceConnection(channel);
        }
    }
}

