/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.model.targeting.TargetingDimension;
import com.android.tools.build.bundletool.model.targeting.TargetingUtils;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import java.util.Comparator;

public class DeviceTierParityValidator
extends SubValidator {
    @Override
    public void validateAllModules(ImmutableList<BundleModule> modules) {
        BundleModule referenceModule = null;
        ImmutableSet<Integer> referenceTiers = null;
        for (BundleModule module : modules) {
            ImmutableSet<Integer> moduleTiers = TargetingUtils.extractDeviceTiers(TargetingUtils.extractAssetsTargetedDirectories(module));
            if (moduleTiers.isEmpty()) continue;
            this.validateContiguousTiers(module, moduleTiers);
            this.validateModuleDirectoryParity(module, moduleTiers);
            if (referenceTiers == null) {
                referenceModule = module;
                referenceTiers = moduleTiers;
                continue;
            }
            if (referenceTiers.equals(moduleTiers)) continue;
            throw InvalidBundleException.builder().withUserMessage("All modules with device tier targeting must support the same set of tiers, but module '%s' supports %s and module '%s' supports %s.", referenceModule.getName(), referenceTiers, module.getName(), moduleTiers).build();
        }
    }

    private void validateContiguousTiers(BundleModule module, ImmutableSet<Integer> moduleTiers) {
        int minTier = (Integer)moduleTiers.stream().min(Comparator.naturalOrder()).get();
        int maxTier = (Integer)moduleTiers.stream().max(Comparator.naturalOrder()).get();
        if (minTier != 0 || maxTier != moduleTiers.size() - 1) {
            throw InvalidBundleException.builder().withUserMessage("All modules with device tier targeting must support the same contiguous range of tier values starting from 0, but module '%s' supports %s.", module.getName(), moduleTiers).build();
        }
    }

    private void validateModuleDirectoryParity(BundleModule module, ImmutableSet<Integer> moduleTiers) {
        ImmutableSetMultimap tiersPerDirectory = (ImmutableSetMultimap)TargetingUtils.extractAssetsTargetedDirectories(module).stream().filter(directory -> TargetingUtils.extractDeviceTier(directory).isPresent()).collect(ImmutableSetMultimap.toImmutableSetMultimap(directory -> directory.getSubPathBaseName(TargetingDimension.DEVICE_TIER), directory -> TargetingUtils.extractDeviceTier(directory).get()));
        for (String subpath : tiersPerDirectory.keySet()) {
            if (tiersPerDirectory.get((Object)subpath).equals(moduleTiers)) continue;
            throw InvalidBundleException.builder().withUserMessage("All device-tier-targeted folders in a module must support the same set of tiers, but module '%s' supports %s and folder '%s' supports only %s.", module.getName(), moduleTiers, subpath, tiersPerDirectory.get((Object)subpath)).build();
        }
    }
}

