/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.commands;

import com.android.bundle.Config;
import com.android.bundle.Files;
import com.android.bundle.SdkBundleConfigProto;
import com.android.bundle.SdkModulesConfigOuterClass;
import com.android.tools.build.bundletool.commands.AutoValue_BuildSdkBundleCommand;
import com.android.tools.build.bundletool.commands.BuildBundleCommand;
import com.android.tools.build.bundletool.commands.CommandHelp;
import com.android.tools.build.bundletool.flags.Flag;
import com.android.tools.build.bundletool.flags.ParsedFlags;
import com.android.tools.build.bundletool.io.ZipFlingerBundleSerializer;
import com.android.tools.build.bundletool.model.AndroidManifest;
import com.android.tools.build.bundletool.model.BundleMetadata;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ManifestEditor;
import com.android.tools.build.bundletool.model.ManifestMutator;
import com.android.tools.build.bundletool.model.SdkBundle;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.model.exceptions.InvalidCommandException;
import com.android.tools.build.bundletool.model.targeting.TargetingUtils;
import com.android.tools.build.bundletool.model.utils.BundleModuleParser;
import com.android.tools.build.bundletool.model.utils.files.BufferedIo;
import com.android.tools.build.bundletool.model.utils.files.FilePreconditions;
import com.android.tools.build.bundletool.model.utils.files.FileUtils;
import com.android.tools.build.bundletool.model.version.BundleToolVersion;
import com.android.tools.build.bundletool.validation.SdkBundleModulesValidator;
import com.android.tools.build.bundletool.validation.SdkBundleValidator;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.io.Closer;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

@AutoValue
public abstract class BuildSdkBundleCommand {
    private static final Logger logger = Logger.getLogger(BuildBundleCommand.class.getName());
    public static final String COMMAND_NAME = "build-sdk-bundle";
    private static final Flag<Path> OUTPUT_FLAG = Flag.path("output");
    private static final Flag<Boolean> OVERWRITE_OUTPUT_FLAG = Flag.booleanFlag("overwrite");
    private static final Flag<Path> SDK_BUNDLE_CONFIG_FLAG = Flag.path("sdk-bundle-config");
    private static final Flag<Path> SDK_MODULES_CONFIG_FLAG = Flag.path("sdk-modules-config");
    private static final Flag<ImmutableList<Path>> MODULES_FLAG = Flag.pathList("modules");
    private static final Flag<Path> SDK_INTERFACE_DESCRIPTORS_FLAG = Flag.path("sdk-interface-descriptors");
    private static final Flag<ImmutableMap<ZipPath, Path>> METADATA_FILES_FLAG = Flag.mapCollector("metadata-file", ZipPath.class, Path.class);

    public abstract Path getOutputPath();

    public abstract boolean getOverwriteOutput();

    public abstract ImmutableList<Path> getModulesPaths();

    public abstract Optional<SdkBundleConfigProto.SdkBundleConfig> getSdkBundleConfig();

    public abstract SdkModulesConfigOuterClass.SdkModulesConfig getSdkModulesConfig();

    public abstract Optional<Path> getSdkInterfaceDescriptors();

    public abstract BundleMetadata getBundleMetadata();

    public static Builder builder() {
        return new AutoValue_BuildSdkBundleCommand.Builder().setOverwriteOutput(false);
    }

    public static BuildSdkBundleCommand fromFlags(ParsedFlags flags) {
        Builder builder = BuildSdkBundleCommand.builder().setOutputPath(OUTPUT_FLAG.getRequiredValue(flags)).setModulesPaths(MODULES_FLAG.getRequiredValue(flags)).setSdkModulesConfig(SDK_MODULES_CONFIG_FLAG.getRequiredValue(flags));
        OVERWRITE_OUTPUT_FLAG.getValue(flags).ifPresent(builder::setOverwriteOutput);
        SDK_BUNDLE_CONFIG_FLAG.getValue(flags).ifPresent(builder::setSdkBundleConfig);
        SDK_INTERFACE_DESCRIPTORS_FLAG.getValue(flags).ifPresent(builder::setSdkInterfaceDescriptors);
        METADATA_FILES_FLAG.getValue(flags).ifPresent(metadataFiles -> metadataFiles.forEach(builder::addMetadataFileInternal));
        flags.checkNoUnknownFlags();
        return builder.build();
    }

    public void execute() {
        this.validateInput();
        try (Closer closer = Closer.create();){
            ImmutableList.Builder moduleZipFilesBuilder = ImmutableList.builder();
            for (Path modulePath : this.getModulesPaths()) {
                try {
                    moduleZipFilesBuilder.add((Object)((ZipFile)closer.register((Closeable)new ZipFile(modulePath.toFile()))));
                }
                catch (ZipException e11) {
                    throw CommandExecutionException.builder().withCause(e11).withInternalMessage("File '%s' does not seem to be a valid ZIP file.", modulePath).build();
                }
                catch (IOException e12) {
                    throw CommandExecutionException.builder().withCause(e12).withInternalMessage("Unable to read file '%s'.", modulePath).build();
                }
            }
            ImmutableList moduleZipFiles = moduleZipFilesBuilder.build();
            new SdkBundleModulesValidator().validateModuleZipFiles((ImmutableList<ZipFile>)moduleZipFiles);
            SdkModulesConfigOuterClass.SdkModulesConfig sdkModulesConfig = this.getSdkModulesConfig().toBuilder().setBundletool(Config.Bundletool.newBuilder().setVersion(BundleToolVersion.getCurrentVersion().toString())).build();
            SdkBundleConfigProto.SdkBundleConfig sdkBundleConfig = this.getSdkBundleConfig().orElse(SdkBundleConfigProto.SdkBundleConfig.getDefaultInstance());
            ImmutableList modules = (ImmutableList)moduleZipFiles.stream().map(moduleZipPath -> BundleModuleParser.parseSdkBundleModule(moduleZipPath, sdkModulesConfig)).map(BuildSdkBundleCommand::sanitizeManifest).collect(ImmutableList.toImmutableList());
            new SdkBundleModulesValidator().validateSdkBundleModules((ImmutableList<BundleModule>)modules);
            BundleModule baseModule = this.parseModuleTargeting((BundleModule)Iterables.getOnlyElement((Iterable)modules));
            SdkBundle.Builder sdkBundleBuilder = SdkBundle.builder().setModule(baseModule).setSdkModulesConfig(sdkModulesConfig).setSdkBundleConfig(sdkBundleConfig).setBundleMetadata(this.getBundleMetadata());
            this.getSdkInterfaceDescriptors().map(descriptorPath -> com.google.common.io.Files.asByteSource((File)descriptorPath.toFile())).ifPresent(sdkBundleBuilder::setSdkInterfaceDescriptors);
            SdkBundle sdkBundle = sdkBundleBuilder.build();
            SdkBundleValidator.create().validate(sdkBundle);
            Path outputDirectory = this.getOutputPath().toAbsolutePath().getParent();
            if (Files.notExists(outputDirectory, new LinkOption[0])) {
                logger.info("Output directory '" + outputDirectory + "' does not exist, creating it.");
                FileUtils.createDirectories(outputDirectory);
            }
            if (this.getOverwriteOutput()) {
                Files.deleteIfExists(this.getOutputPath());
            }
            new ZipFlingerBundleSerializer().serializeSdkBundle(sdkBundle, this.getOutputPath());
        }
        catch (IOException e13) {
            throw new UncheckedIOException(e13);
        }
    }

    private void validateInput() {
        this.getModulesPaths().forEach(path -> {
            FilePreconditions.checkFileHasExtension("File", path, ".zip");
            FilePreconditions.checkFileExistsAndReadable(path);
        });
        this.getSdkInterfaceDescriptors().ifPresent(path -> {
            FilePreconditions.checkFileHasExtension("SDK interface descriptors", path, ".jar");
            FilePreconditions.checkFileExistsAndReadable(path);
        });
        if (!this.getOverwriteOutput()) {
            FilePreconditions.checkFileDoesNotExist(this.getOutputPath());
        }
    }

    private BundleModule parseModuleTargeting(BundleModule rawModule) {
        BundleModule.Builder moduleWithTargeting = rawModule.toBuilder();
        Optional<Files.Assets> assetsTargeting = TargetingUtils.generateAssetsTargeting(rawModule);
        assetsTargeting.ifPresent(moduleWithTargeting::setAssetsConfig);
        Optional<Files.NativeLibraries> nativeLibrariesTargeting = TargetingUtils.generateNativeLibrariesTargeting(rawModule);
        nativeLibrariesTargeting.ifPresent(moduleWithTargeting::setNativeConfig);
        return moduleWithTargeting.build();
    }

    private static SdkBundleConfigProto.SdkBundleConfig parseSdkBundleConfigJson(Path sdkBundleConfigJsonPath) {
        SdkBundleConfigProto.SdkBundleConfig.Builder sdkBundleConfig = SdkBundleConfigProto.SdkBundleConfig.newBuilder();
        BuildSdkBundleCommand.populateConfigFromJson(sdkBundleConfigJsonPath, sdkBundleConfig);
        return sdkBundleConfig.build();
    }

    private static SdkModulesConfigOuterClass.SdkModulesConfig parseSdkModulesConfigJson(Path sdkModulesConfigJsonPath) {
        SdkModulesConfigOuterClass.SdkModulesConfig.Builder sdkModulesConfig = SdkModulesConfigOuterClass.SdkModulesConfig.newBuilder();
        BuildSdkBundleCommand.populateConfigFromJson(sdkModulesConfigJsonPath, sdkModulesConfig);
        return sdkModulesConfig.build();
    }

    private static <T extends Message.Builder> void populateConfigFromJson(Path configJsonPath, T builder) {
        try (BufferedReader configReader = BufferedIo.reader(configJsonPath);){
            JsonFormat.parser().merge((Reader)configReader, builder);
        }
        catch (InvalidProtocolBufferException e11) {
            throw InvalidCommandException.builder().withCause(e11).withInternalMessage("The file '%s' is not a valid %s JSON file.", configJsonPath, builder.build().getClass().getSimpleName()).build();
        }
        catch (IOException e12) {
            throw InvalidCommandException.builder().withCause(e12).withInternalMessage("An error occurred while trying to read the file '%s'.", configJsonPath).build();
        }
    }

    private static BundleModule sanitizeManifest(BundleModule bundleModule) {
        return bundleModule.toBuilder().setAndroidManifest(BuildSdkBundleCommand.sanitizeManifest(bundleModule.getAndroidManifest())).build();
    }

    private static AndroidManifest sanitizeManifest(AndroidManifest androidManifest) {
        return androidManifest.applyMutators((ImmutableList<ManifestMutator>)ImmutableList.of(ManifestEditor::removePermissions, ManifestEditor::removeComponents));
    }

    public static CommandHelp help() {
        return CommandHelp.builder().setCommandName(COMMAND_NAME).setCommandDescription(CommandHelp.CommandDescription.builder().setShortDescription("Builds an Android SDK Bundle from a set of Bundle modules provided as zip files.").addAdditionalParagraph("Note that the resource table, the AndroidManifest.xml and the resources must already have been compiled with aapt2 in the proto format.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(OUTPUT_FLAG.getName()).setExampleValue("bundle.asb").setDescription("Path to the where the Android SDK Bundle should be built.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(OVERWRITE_OUTPUT_FLAG.getName()).setOptional(true).setDescription("If set, any previous existing output will be overwritten.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(MODULES_FLAG.getName()).setExampleValue("path/to/module1.zip,path/to/module2.zip,...").setDescription("The list of module files to build the final Android SDK Bundle from.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(SDK_BUNDLE_CONFIG_FLAG.getName()).setExampleValue("SdkBundleConfig.pb.json").setDescription("Path to a JSON file that describes the configuration of the SDK Bundle. This configuration will be merged with BundleTool defaults.").setOptional(true).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(SDK_MODULES_CONFIG_FLAG.getName()).setExampleValue("SdkModulesConfig.pb.json").setDescription("Path to a JSON file that describes the configuration of the SDK modules.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(SDK_INTERFACE_DESCRIPTORS_FLAG.getName()).setExampleValue("path/to/sdk_api_descriptors.jar").setDescription("The packaged public API stubs of this SDK.").setOptional(true).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(METADATA_FILES_FLAG.getName()).setExampleValue("com.some.namespace/file-name:path/to/file").setDescription("Specifies a file that will be included as metadata in the Android SDK Bundle. The format of the flag value is '<bundle-path>:<physical-file>' where 'bundle-path' denotes the file location inside the SDK Bundle's metadata directory, and 'physical-file' is an existing file containing the raw data to be stored. The flag can be repeated.").setOptional(true).build()).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setOutputPath(Path var1);

        public abstract Builder setOverwriteOutput(boolean var1);

        public abstract Builder setModulesPaths(ImmutableList<Path> var1);

        public abstract Builder setSdkBundleConfig(SdkBundleConfigProto.SdkBundleConfig var1);

        public Builder setSdkBundleConfig(Path sdkBundleConfigFile) {
            return this.setSdkBundleConfig(BuildSdkBundleCommand.parseSdkBundleConfigJson(sdkBundleConfigFile));
        }

        public abstract Builder setSdkModulesConfig(SdkModulesConfigOuterClass.SdkModulesConfig var1);

        public Builder setSdkModulesConfig(Path sdkModulesConfigFile) {
            return this.setSdkModulesConfig(BuildSdkBundleCommand.parseSdkModulesConfigJson(sdkModulesConfigFile));
        }

        public abstract Builder setSdkInterfaceDescriptors(Path var1);

        abstract BundleMetadata.Builder bundleMetadataBuilder();

        public Builder addMetadataFile(String metadataDirectory, String fileName, Path file) {
            this.addMetadataFileInternal(ZipPath.create(metadataDirectory).resolve(fileName), file);
            return this;
        }

        void addMetadataFileInternal(ZipPath metadataPath, Path file) {
            if (!Files.exists(file, new LinkOption[0])) {
                throw InvalidCommandException.builder().withInternalMessage("Metadata file '%s' does not exist.", file).build();
            }
            this.bundleMetadataBuilder().addFile(metadataPath, com.google.common.io.Files.asByteSource((File)file.toFile()));
        }

        public abstract BuildSdkBundleCommand build();
    }
}

