/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.androidtools;

import com.android.tools.build.bundletool.androidtools.CommandExecutor;
import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.model.utils.files.BufferedIo;
import com.google.common.collect.ImmutableList;
import com.google.common.io.CharStreams;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class DefaultCommandExecutor
implements CommandExecutor {
    @Override
    public void execute(ImmutableList<String> command, CommandExecutor.CommandOptions options) {
        DefaultCommandExecutor.executeImpl(command, options);
    }

    @Override
    public ImmutableList<String> executeAndCapture(ImmutableList<String> command, CommandExecutor.CommandOptions options) {
        return DefaultCommandExecutor.captureOutput(DefaultCommandExecutor.executeImpl(command, options));
    }

    private static Process executeImpl(ImmutableList<String> command, CommandExecutor.CommandOptions options) {
        try {
            Process process = new ProcessBuilder((List<String>)command).redirectErrorStream(true).start();
            if (!process.waitFor(options.getTimeout().toMillis(), TimeUnit.MILLISECONDS)) {
                DefaultCommandExecutor.printOutput(process);
                throw CommandExecutionException.builder().withInternalMessage("Command timed out: %s", command).build();
            }
            if (process.exitValue() != 0) {
                DefaultCommandExecutor.printOutput(process);
                throw CommandExecutionException.builder().withInternalMessage("Command '%s' didn't terminate successfully (exit code: %d). Check the logs.", command, process.exitValue()).build();
            }
            return process;
        }
        catch (IOException | InterruptedException e11) {
            throw CommandExecutionException.builder().withInternalMessage("Error when executing command: %s", command).withCause(e11).build();
        }
    }

    private static ImmutableList<String> captureOutput(Process process) {
        ImmutableList immutableList;
        block8: {
            BufferedReader outputReader = BufferedIo.reader(process.getInputStream());
            try {
                immutableList = ImmutableList.copyOf((Collection)CharStreams.readLines((Readable)outputReader));
                if (outputReader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (outputReader != null) {
                        try {
                            outputReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e11) {
                    throw new UncheckedIOException(e11);
                }
            }
            outputReader.close();
        }
        return immutableList;
    }

    private static void printOutput(Process process) {
        try (BufferedReader outputReader = BufferedIo.reader(process.getInputStream());){
            String line;
            while ((line = outputReader.readLine()) != null) {
                System.err.println(line);
            }
        }
        catch (IOException e11) {
            System.err.println("Error when printing output of command:" + e11.getMessage());
        }
    }
}

