/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.validation.BundleValidationUtils;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.google.common.collect.ImmutableList;

public class AssetBundleValidator
extends SubValidator {
    @Override
    public void validateAllModules(ImmutableList<BundleModule> modules) {
        AssetBundleValidator.checkAssetOnlyBundleHasOnlyAssetModules(modules);
        AssetBundleValidator.checkAssetOnlyBundleHasOnlyOptionalAssetModules(modules);
    }

    private static void checkAssetOnlyBundleHasOnlyAssetModules(ImmutableList<BundleModule> modules) {
        if (BundleValidationUtils.isAssetOnlyBundle(modules)) {
            modules.stream().filter(module -> !module.getModuleType().equals((Object)BundleModule.ModuleType.ASSET_MODULE)).findFirst().ifPresent(module -> {
                throw InvalidBundleException.builder().withUserMessage("Asset only bundle contains a module that is not an asset module '%s'.", module.getName()).build();
            });
        }
    }

    private static void checkAssetOnlyBundleHasOnlyOptionalAssetModules(ImmutableList<BundleModule> modules) {
        if (BundleValidationUtils.isAssetOnlyBundle(modules)) {
            modules.stream().filter(module -> !module.getDeliveryType().equals((Object)BundleModule.ModuleDeliveryType.NO_INITIAL_INSTALL)).findFirst().ifPresent(module -> {
                throw InvalidBundleException.builder().withUserMessage("Asset-only bundle contains an install-time asset module '%s'.", module.getName()).build();
            });
        }
    }
}

