/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.splitters.ApkGenerationConfiguration;
import com.android.tools.build.bundletool.splitters.AssetModuleSplitter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Optional;

public class AssetSlicesGenerator {
    private final AppBundle appBundle;
    private final ApkGenerationConfiguration apkGenerationConfiguration;
    private final Optional<Long> assetModulesVersionOverride;

    public AssetSlicesGenerator(AppBundle appBundle, ApkGenerationConfiguration apkGenerationConfiguration, Optional<Long> assetModulesVersionOverride) {
        this.appBundle = (AppBundle)Preconditions.checkNotNull((Object)appBundle);
        this.apkGenerationConfiguration = (ApkGenerationConfiguration)Preconditions.checkNotNull((Object)apkGenerationConfiguration);
        this.assetModulesVersionOverride = assetModulesVersionOverride;
    }

    public ImmutableList<ModuleSplit> generateAssetSlices() {
        ImmutableList.Builder splits = ImmutableList.builder();
        Optional appVersionCode = this.appBundle.isAssetOnly() ? Optional.empty() : Optional.of(Long.valueOf(this.appBundle.getBaseModule().getAndroidManifest().getVersionCode().get().intValue()));
        Optional<Object> nonUpfrontAssetModulesVersionCode = this.assetModulesVersionOverride.isPresent() ? this.assetModulesVersionOverride : appVersionCode;
        for (BundleModule module : this.appBundle.getAssetModules().values()) {
            AssetModuleSplitter moduleSplitter = new AssetModuleSplitter(module, this.apkGenerationConfiguration);
            splits.addAll((Iterable)moduleSplitter.splitModule().stream().map(split -> AssetSlicesGenerator.addVersionCode(split, module.getDeliveryType().equals((Object)BundleModule.ModuleDeliveryType.NO_INITIAL_INSTALL) ? nonUpfrontAssetModulesVersionCode : appVersionCode)).collect(ImmutableList.toImmutableList()));
        }
        return splits.build();
    }

    private static ModuleSplit addVersionCode(ModuleSplit moduleSplit, Optional<Long> versionCode) {
        if (!versionCode.isPresent()) {
            return moduleSplit;
        }
        return moduleSplit.toBuilder().setAndroidManifest(moduleSplit.getAndroidManifest().toEditor().setLongVersionCode(versionCode.get()).save()).build();
    }
}

