/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.mergers;

import com.android.tools.build.bundletool.mergers.DexMerger;
import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.model.utils.ThrowableUtils;
import com.android.tools.build.bundletool.model.utils.files.FilePreconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import javax.inject.Inject;
import shadow.bundletool.com.android.tools.r8.CompilationFailedException;
import shadow.bundletool.com.android.tools.r8.CompilationMode;
import shadow.bundletool.com.android.tools.r8.D8;
import shadow.bundletool.com.android.tools.r8.D8Command;
import shadow.bundletool.com.android.tools.r8.OutputMode;

public class D8DexMerger
implements DexMerger {
    private static final String DEX_OVERFLOW_MSG = "Cannot fit requested classes in a single dex file";

    @Inject
    D8DexMerger() {
    }

    @Override
    public ImmutableList<Path> merge(ImmutableList<Path> dexFiles, Path outputDir, Optional<Path> mainDexListFile, boolean isDebuggable, int minSdkVersion) {
        try {
            D8DexMerger.validateInput(dexFiles, outputDir);
            D8Command.Builder command = (D8Command.Builder)((D8Command.Builder)((D8Command.Builder)((D8Command.Builder)D8Command.builder().setOutput(outputDir, OutputMode.DexIndexed)).addProgramFiles((Collection<Path>)dexFiles)).setMinApiLevel(minSdkVersion)).setMode(isDebuggable ? CompilationMode.DEBUG : CompilationMode.RELEASE);
            mainDexListFile.ifPresent(xva$0 -> command.addMainDexListFiles((Path)xva$0));
            D8.run((D8Command)command.build());
            File[] mergedFiles = outputDir.toFile().listFiles();
            return (ImmutableList)Arrays.stream(mergedFiles).map(File::toPath).collect(ImmutableList.toImmutableList());
        }
        catch (CompilationFailedException e4) {
            throw D8DexMerger.translateD8Exception(e4);
        }
    }

    private static void validateInput(ImmutableList<Path> dexFiles, Path outputDir) {
        FilePreconditions.checkDirectoryExistsAndEmpty(outputDir);
        dexFiles.forEach(FilePreconditions::checkFileExistsAndReadable);
    }

    private static CommandExecutionException translateD8Exception(CompilationFailedException d8Exception) {
        if (ThrowableUtils.anyInCausalChainOrSuppressedMatches(d8Exception, t4 -> t4.getMessage() != null && t4.getMessage().contains(DEX_OVERFLOW_MSG))) {
            return CommandExecutionException.builder().withInternalMessage("Dex merging failed because the result does not fit into a single dex file and multidex is not supported by the input.").withCause(d8Exception).build();
        }
        return CommandExecutionException.builder().withInternalMessage("Dex merging failed.").withCause(d8Exception).build();
    }
}

