/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.utils;

import java.util.Arrays;
import shadow.bundletool.com.android.tools.r8.dex.BaseFile;
import shadow.bundletool.com.android.tools.r8.dex.DexOutputBuffer;

public class LebUtils {
    private static final int BITS_PER_ENCODED_BYTE = 7;
    private static final int PAYLOAD_MASK = 127;
    private static final int MORE_DATA_TAG_BIT = 128;
    private static final int MAX_BYTES_PER_VALUE = 5;

    public static int parseUleb128(BaseFile file) {
        byte b;
        int result = 0;
        int shift = 0;
        do {
            b = file.get();
            result |= (b & 0x7F) << shift;
            shift += 7;
        } while ((b & 0xFFFFFF80) == -128);
        assert (shift <= 35);
        assert (result >= 0);
        return result;
    }

    public static byte[] encodeUleb128(int value) {
        byte[] result = new byte[5];
        int bytes = 0;
        for (int remaining = value >>> 7; remaining != 0; remaining >>>= 7) {
            result[bytes++] = (byte)(value & 0x7F | 0x80);
            value = remaining;
        }
        result[bytes++] = (byte)(value & 0x7F);
        return Arrays.copyOf(result, bytes);
    }

    public static void putUleb128(DexOutputBuffer outputBuffer, int value) {
        for (int remaining = value >>> 7; remaining != 0; remaining >>>= 7) {
            outputBuffer.putByte((byte)(value & 0x7F | 0x80));
            value = remaining;
        }
        outputBuffer.putByte((byte)(value & 0x7F));
    }

    public static int sizeAsUleb128(int value) {
        return Math.max(1, (32 - Integer.numberOfLeadingZeros(value) + 6) / 7);
    }

    public static int parseSleb128(BaseFile file) {
        byte b;
        int result = 0;
        int shift = 0;
        do {
            b = file.get();
            result |= (b & 0x7F) << shift;
            shift += 7;
        } while ((b & 0xFFFFFF80) == -128);
        int mask = 1 << shift - 1;
        assert (shift <= 35);
        return (result ^ mask) - mask;
    }

    public static byte[] encodeSleb128(int value) {
        byte[] result = new byte[5];
        int remaining = value >> 7;
        boolean hasMore = true;
        int end = value >= 0 ? 0 : -1;
        int bytes = 0;
        while (hasMore) {
            hasMore = remaining != end || (remaining & 1) != (value >> 6 & 1);
            result[bytes++] = (byte)(value & 0x7F | (hasMore ? 128 : 0));
            value = remaining;
            remaining >>= 7;
        }
        return Arrays.copyOf(result, bytes);
    }

    public static void putSleb128(DexOutputBuffer outputBuffer, int value) {
        int end;
        int remaining = value >> 7;
        boolean hasMore = true;
        int n = end = (value & Integer.MIN_VALUE) == 0 ? 0 : -1;
        while (hasMore) {
            hasMore = remaining != end || (remaining & 1) != (value >> 6 & 1);
            outputBuffer.putByte((byte)(value & 0x7F | (hasMore ? 128 : 0)));
            value = remaining;
            remaining >>= 7;
        }
    }

    public static int sizeAsSleb128(int value) {
        if (value < 0) {
            value ^= 0xFFFFFFFF;
        }
        return (32 - Integer.numberOfLeadingZeros(value) + 7) / 7;
    }

    public static byte[] encodeUleb128p1(int value) {
        return LebUtils.encodeUleb128(value + 1);
    }

    public static byte[][] encodeUleb128p1(int[] values) {
        byte[][] result = new byte[values.length][];
        for (int i = 0; i < result.length; ++i) {
            result[i] = LebUtils.encodeUleb128p1(values[i]);
        }
        return result;
    }
}

