/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.naming;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import shadow.bundletool.com.android.tools.r8.graph.CachedHashValueDexItem;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.utils.StringUtils;

class NamingState<ProtoType extends CachedHashValueDexItem, KeyType> {
    private final NamingState<ProtoType, KeyType> parent;
    private final Map<KeyType, InternalState> usedNames = new HashMap<KeyType, InternalState>();
    private final DexItemFactory itemFactory;
    private final ImmutableList<String> dictionary;
    private final Function<ProtoType, KeyType> keyTransform;

    static <S, T extends CachedHashValueDexItem> NamingState<T, S> createRoot(DexItemFactory itemFactory, ImmutableList<String> dictionary, Function<T, S> keyTransform) {
        return new NamingState<T, S>(null, itemFactory, dictionary, keyTransform);
    }

    private NamingState(NamingState<ProtoType, KeyType> parent, DexItemFactory itemFactory, ImmutableList<String> dictionary, Function<ProtoType, KeyType> keyTransform) {
        this.parent = parent;
        this.itemFactory = itemFactory;
        this.dictionary = dictionary;
        this.keyTransform = keyTransform;
    }

    public NamingState<ProtoType, KeyType> createChild() {
        return new NamingState<ProtoType, KeyType>(this, this.itemFactory, this.dictionary, this.keyTransform);
    }

    private InternalState findInternalStateFor(ProtoType proto) {
        KeyType key = this.keyTransform.apply(proto);
        InternalState result = this.usedNames.get(key);
        if (result == null && this.parent != null) {
            result = super.findInternalStateFor(proto);
        }
        return result;
    }

    private InternalState getOrCreateInternalStateFor(ProtoType proto) {
        KeyType key = this.keyTransform.apply(proto);
        InternalState result = this.usedNames.get(key);
        if (result == null) {
            if (this.parent != null) {
                InternalState parentState = super.getOrCreateInternalStateFor(proto);
                result = parentState.createChild();
            } else {
                result = new InternalState(this.itemFactory, null, (List)this.dictionary);
            }
            this.usedNames.put(key, result);
        }
        return result;
    }

    public DexString getAssignedNameFor(DexString name, ProtoType proto) {
        InternalState state = this.findInternalStateFor(proto);
        if (state == null) {
            return null;
        }
        return state.getAssignedNameFor(name);
    }

    public DexString assignNewNameFor(DexString original, ProtoType proto, boolean markAsUsed) {
        DexString result = this.getAssignedNameFor(original, proto);
        if (result == null) {
            InternalState state = this.getOrCreateInternalStateFor(proto);
            result = state.getNameFor(original, markAsUsed);
        }
        return result;
    }

    public void reserveName(DexString name, ProtoType proto) {
        InternalState state = this.getOrCreateInternalStateFor(proto);
        state.reserveName(name);
    }

    public boolean isReserved(DexString name, ProtoType proto) {
        InternalState state = this.findInternalStateFor(proto);
        if (state == null) {
            return false;
        }
        return state.isReserved(name);
    }

    public boolean isAvailable(DexString original, ProtoType proto, DexString candidate) {
        InternalState state = this.findInternalStateFor(proto);
        if (state == null) {
            return true;
        }
        assert (state.getAssignedNameFor(original) != candidate);
        return state.isAvailable(candidate);
    }

    public void addRenaming(DexString original, ProtoType proto, DexString newName) {
        InternalState state = this.getOrCreateInternalStateFor(proto);
        state.addRenaming(original, newName);
    }

    private static class InternalState {
        private static final int INITIAL_NAME_COUNT = 1;
        private static final char[] EMPTY_CHAR_ARRARY = new char[0];
        protected final DexItemFactory itemFactory;
        private final InternalState parentInternalState;
        private Set<DexString> reservedNames = null;
        private Map<DexString, DexString> renamings = null;
        private int nameCount;
        private final Iterator<String> dictionaryIterator;

        private InternalState(DexItemFactory itemFactory, InternalState parentInternalState, Iterator<String> dictionaryIterator) {
            this.itemFactory = itemFactory;
            this.parentInternalState = parentInternalState;
            this.nameCount = parentInternalState == null ? 1 : parentInternalState.nameCount;
            this.dictionaryIterator = dictionaryIterator;
        }

        private InternalState(DexItemFactory itemFactory, InternalState parentInternalState, List<String> dictionary) {
            this(itemFactory, parentInternalState, dictionary.iterator());
        }

        private boolean isReserved(DexString name) {
            return this.reservedNames != null && this.reservedNames.contains(name) || this.parentInternalState != null && this.parentInternalState.isReserved(name);
        }

        private boolean isAvailable(DexString name) {
            return !(this.renamings != null && this.renamings.containsValue(name) || this.reservedNames != null && this.reservedNames.contains(name) || this.parentInternalState != null && !this.parentInternalState.isAvailable(name));
        }

        public InternalState createChild() {
            return new InternalState(this.itemFactory, this, this.dictionaryIterator);
        }

        public void reserveName(DexString name) {
            if (this.reservedNames == null) {
                this.reservedNames = Sets.newIdentityHashSet();
            }
            this.reservedNames.add(name);
        }

        public DexString getAssignedNameFor(DexString original) {
            DexString result;
            DexString dexString = result = this.renamings == null ? null : this.renamings.get(original);
            if (result == null && this.parentInternalState != null) {
                result = this.parentInternalState.getAssignedNameFor(original);
            }
            return result;
        }

        public DexString getNameFor(DexString original, boolean markAsUsed) {
            DexString name = this.getAssignedNameFor(original);
            if (name != null) {
                return name;
            }
            while (!this.isAvailable(name = this.itemFactory.createString(this.nextSuggestedName()))) {
            }
            if (markAsUsed) {
                this.addRenaming(original, name);
            }
            return name;
        }

        public void addRenaming(DexString original, DexString newName) {
            if (this.renamings == null) {
                this.renamings = HashBiMap.create();
            }
            this.renamings.put(original, newName);
        }

        protected String nextSuggestedName() {
            if (this.dictionaryIterator.hasNext()) {
                return this.dictionaryIterator.next();
            }
            return StringUtils.numberToIdentifier(EMPTY_CHAR_ARRARY, this.nameCount++, false);
        }
    }
}

