/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import shadow.bundletool.com.android.tools.r8.dex.IndexedItemCollection;
import shadow.bundletool.com.android.tools.r8.graph.Descriptor;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItem;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.IndexedDexItem;
import shadow.bundletool.com.android.tools.r8.graph.ObjectToOffsetMapping;
import shadow.bundletool.com.android.tools.r8.graph.PresortedComparable;
import shadow.bundletool.com.android.tools.r8.naming.NamingLens;

public class DexMethodHandle
extends IndexedDexItem
implements PresortedComparable<DexMethodHandle> {
    public MethodHandleType type;
    public Descriptor<? extends DexItem, ? extends Descriptor<?, ?>> fieldOrMethod;

    public DexMethodHandle(MethodHandleType type, Descriptor<? extends DexItem, ? extends Descriptor<?, ?>> fieldOrMethod) {
        this.type = type;
        this.fieldOrMethod = fieldOrMethod;
    }

    @Override
    public int computeHashCode() {
        return this.type.hashCode() + this.fieldOrMethod.computeHashCode() * 7;
    }

    @Override
    public boolean computeEquals(Object other) {
        if (other instanceof DexMethodHandle) {
            DexMethodHandle o = (DexMethodHandle)other;
            return this.type.equals((Object)o.type) && this.fieldOrMethod.equals(o.fieldOrMethod);
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("MethodHandle: {").append((Object)this.type).append(", ").append(this.fieldOrMethod.toSourceString()).append("}");
        return builder.toString();
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems) {
        if (indexedItems.addMethodHandle(this)) {
            this.fieldOrMethod.collectIndexedItems(indexedItems);
        }
    }

    @Override
    public int getOffset(ObjectToOffsetMapping mapping) {
        return mapping.getOffsetFor(this);
    }

    @Override
    public String toSmaliString() {
        return this.toString();
    }

    public boolean isFieldHandle() {
        return this.type.isFieldType();
    }

    public boolean isMethodHandle() {
        return this.type.isMethodType();
    }

    public boolean isStaticHandle() {
        return this.type.isStaticPut() || this.type.isStaticGet() || this.type.isInvokeStatic();
    }

    public DexMethod asMethod() {
        assert (this.isMethodHandle());
        return (DexMethod)this.fieldOrMethod;
    }

    public DexField asField() {
        assert (this.isFieldHandle());
        return (DexField)this.fieldOrMethod;
    }

    @Override
    public int slowCompareTo(DexMethodHandle other) {
        int result = this.type.getValue() - other.type.getValue();
        if (result == 0) {
            if (this.isFieldHandle()) {
                result = this.asField().slowCompareTo(other.asField());
            } else {
                assert (this.isMethodHandle());
                result = this.asMethod().slowCompareTo(other.asMethod());
            }
        }
        return result;
    }

    @Override
    public int slowCompareTo(DexMethodHandle other, NamingLens namingLens) {
        int result = this.type.getValue() - other.type.getValue();
        if (result == 0) {
            if (this.isFieldHandle()) {
                result = this.asField().slowCompareTo(other.asField(), namingLens);
            } else {
                assert (this.isMethodHandle());
                result = this.asMethod().slowCompareTo(other.asMethod(), namingLens);
            }
        }
        return result;
    }

    @Override
    public int layeredCompareTo(DexMethodHandle other, NamingLens namingLens) {
        int result = this.type.getValue() - other.type.getValue();
        if (result == 0) {
            if (this.isFieldHandle()) {
                result = this.asField().layeredCompareTo(other.asField(), namingLens);
            } else {
                assert (this.isMethodHandle());
                result = this.asMethod().layeredCompareTo(other.asMethod(), namingLens);
            }
        }
        return result;
    }

    @Override
    public int compareTo(DexMethodHandle other) {
        return this.sortedCompareTo(other.getSortedIndex());
    }

    public static final class MethodHandleType
    extends Enum<MethodHandleType> {
        public static final /* enum */ MethodHandleType STATIC_PUT = new MethodHandleType(0);
        public static final /* enum */ MethodHandleType STATIC_GET = new MethodHandleType(1);
        public static final /* enum */ MethodHandleType INSTANCE_PUT = new MethodHandleType(2);
        public static final /* enum */ MethodHandleType INSTANCE_GET = new MethodHandleType(3);
        public static final /* enum */ MethodHandleType INVOKE_STATIC = new MethodHandleType(4);
        public static final /* enum */ MethodHandleType INVOKE_INSTANCE = new MethodHandleType(5);
        public static final /* enum */ MethodHandleType INVOKE_CONSTRUCTOR = new MethodHandleType(6);
        public static final /* enum */ MethodHandleType INVOKE_DIRECT = new MethodHandleType(7);
        public static final /* enum */ MethodHandleType INVOKE_INTERFACE = new MethodHandleType(8);
        public static final /* enum */ MethodHandleType INVOKE_SUPER = new MethodHandleType(9);
        private final short value;
        private static final /* synthetic */ MethodHandleType[] $VALUES;

        public static MethodHandleType[] values() {
            return (MethodHandleType[])$VALUES.clone();
        }

        public static MethodHandleType valueOf(String name) {
            return Enum.valueOf(MethodHandleType.class, name);
        }

        private MethodHandleType(short value) {
            this.value = value;
        }

        public short getValue() {
            return this.value;
        }

        public static MethodHandleType getKind(int value) {
            MethodHandleType kind;
            switch (value) {
                case 0: {
                    kind = STATIC_PUT;
                    break;
                }
                case 1: {
                    kind = STATIC_GET;
                    break;
                }
                case 2: {
                    kind = INSTANCE_PUT;
                    break;
                }
                case 3: {
                    kind = INSTANCE_GET;
                    break;
                }
                case 4: {
                    kind = INVOKE_STATIC;
                    break;
                }
                case 5: {
                    kind = INVOKE_INSTANCE;
                    break;
                }
                case 6: {
                    kind = INVOKE_CONSTRUCTOR;
                    break;
                }
                case 7: {
                    kind = INVOKE_DIRECT;
                    break;
                }
                case 8: {
                    kind = INVOKE_INTERFACE;
                    break;
                }
                case 9: {
                    kind = INVOKE_SUPER;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            assert (kind.getValue() == value);
            return kind;
        }

        public boolean isFieldType() {
            return this.isStaticPut() || this.isStaticGet() || this.isInstancePut() || this.isInstanceGet();
        }

        public boolean isMethodType() {
            return this.isInvokeStatic() || this.isInvokeInstance() || this.isInvokeInterface() || this.isInvokeSuper() || this.isInvokeConstructor() || this.isInvokeDirect();
        }

        public boolean isStaticPut() {
            return this == STATIC_PUT;
        }

        public boolean isStaticGet() {
            return this == STATIC_GET;
        }

        public boolean isInstancePut() {
            return this == INSTANCE_PUT;
        }

        public boolean isInstanceGet() {
            return this == INSTANCE_GET;
        }

        public boolean isInvokeStatic() {
            return this == INVOKE_STATIC;
        }

        public boolean isInvokeDirect() {
            return this == INVOKE_DIRECT;
        }

        public boolean isInvokeInstance() {
            return this == INVOKE_INSTANCE;
        }

        public boolean isInvokeInterface() {
            return this == INVOKE_INTERFACE;
        }

        public boolean isInvokeSuper() {
            return this == INVOKE_SUPER;
        }

        public boolean isInvokeConstructor() {
            return this == INVOKE_CONSTRUCTOR;
        }

        static {
            $VALUES = new MethodHandleType[]{STATIC_PUT, STATIC_GET, INSTANCE_PUT, INSTANCE_GET, INVOKE_STATIC, INVOKE_INSTANCE, INVOKE_CONSTRUCTOR, INVOKE_DIRECT, INVOKE_INTERFACE, INVOKE_SUPER};
        }
    }
}

